/****************************************************************************
**
** Copyright (C) 2025 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

checkDebuggerVersion = function(key, expected)
{
    var debuggerVersion = installer.value(key).split('.');
    for (var i = 0; i < expected.length; ++i) {
        if (debuggerVersion.length == i)
            return true;
        if (parseInt(debuggerVersion[i]) < expected[i])
            return true;
        if (parseInt(debuggerVersion[i]) > expected[i])
            return false;
    }
    return false;
}

checkx64DebuggerVersion = function()
{
    return checkDebuggerVersion("HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\Installer\\Dependencies\\Microsoft.Windows.X64DebuggersAndTools.x64.10\\Version", [10, 1, 22621, 755])
}

checkx86DebuggerVersion = function()
{
    return checkDebuggerVersion("HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\Installer\\Dependencies\\Microsoft.Windows.x86DebuggersAndTools.x86.10\\Version", [10, 1, 22621, 755])
}

is64BitSystem = function()
{
    return systemInfo.currentCpuArchitecture == "x86_64";
}

// constructor
function Component()
{
    if (is64BitSystem() && checkx64DebuggerVersion() || checkx86DebuggerVersion())
        component.setValue("RequiresAdminRights", "true");

    if (installer.isOfflineOnly())
        component.setValue("Default", "true");
}

var Dir = new function ()
{
    this.toNativeSeparator = function (path)
        {
        if (systemInfo.productType === "windows")
            return path.replace(/\//g, '\\');
        return path;
    }
}
Component.prototype.createOperations = function()
{
    // Call the base createOperations and afterwards set some registry settings
    // so that the simulator finds its fonts and applications find the simulator
    component.createOperations();

    var dir = Dir.toNativeSeparator(installer.value("TargetDir"));
    if (is64BitSystem() && checkx64DebuggerVersion()) {
        var architecture = installer.value("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment\\PROCESSOR_ARCHITECTURE");
        // On ARM64 architecture, the msiexec with /quiet option does not install the debuggers correctly
        if (architecture == "ARM64")
            component.addElevatedOperation("Execute", "{0,3010,1638,1618,5100}", "msiexec", "/i", dir + "\\vcredist\\X64 Debuggers And Tools-x64_en-us.msi", "/norestart");
        else
            component.addElevatedOperation("Execute", "{0,3010,1638,1618,5100}", "msiexec", "/i", dir + "\\vcredist\\X64 Debuggers And Tools-x64_en-us.msi", "/norestart", "/q");
    }
    if (checkx86DebuggerVersion())
        component.addElevatedOperation("Execute", "{0,3010,1638,1618,5100}", "msiexec", "/i", dir + "\\vcredist\\x86 Debuggers And Tools-x86_en-us.msi", "/norestart", "/q");
}
