/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class MultiInstructionVisitor
implements InstructionVisitor {
    private static final int ARRAY_SIZE_INCREMENT = 5;
    private InstructionVisitor[] instructionVisitors;
    private int instructionVisitorCount;

    public MultiInstructionVisitor() {
    }

    public MultiInstructionVisitor(InstructionVisitor[] instructionVisitorArray) {
        this.instructionVisitors = instructionVisitorArray;
        this.instructionVisitorCount = instructionVisitorArray.length;
    }

    public void addInstructionVisitor(InstructionVisitor instructionVisitor) {
        this.ensureArraySize();
        this.instructionVisitors[this.instructionVisitorCount++] = instructionVisitor;
    }

    private void ensureArraySize() {
        if (this.instructionVisitors == null) {
            this.instructionVisitors = new InstructionVisitor[5];
        } else if (this.instructionVisitors.length == this.instructionVisitorCount) {
            InstructionVisitor[] instructionVisitorArray = new InstructionVisitor[this.instructionVisitorCount + 5];
            System.arraycopy(this.instructionVisitors, 0, instructionVisitorArray, 0, this.instructionVisitorCount);
            this.instructionVisitors = instructionVisitorArray;
        }
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        for (int i = 0; i < this.instructionVisitorCount; ++i) {
            this.instructionVisitors[i].visitSimpleInstruction(clazz, method, codeAttribute, n, simpleInstruction);
        }
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        for (int i = 0; i < this.instructionVisitorCount; ++i) {
            this.instructionVisitors[i].visitVariableInstruction(clazz, method, codeAttribute, n, variableInstruction);
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        for (int i = 0; i < this.instructionVisitorCount; ++i) {
            this.instructionVisitors[i].visitConstantInstruction(clazz, method, codeAttribute, n, constantInstruction);
        }
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        for (int i = 0; i < this.instructionVisitorCount; ++i) {
            this.instructionVisitors[i].visitBranchInstruction(clazz, method, codeAttribute, n, branchInstruction);
        }
    }

    @Override
    public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, TableSwitchInstruction tableSwitchInstruction) {
        for (int i = 0; i < this.instructionVisitorCount; ++i) {
            this.instructionVisitors[i].visitTableSwitchInstruction(clazz, method, codeAttribute, n, tableSwitchInstruction);
        }
    }

    @Override
    public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        for (int i = 0; i < this.instructionVisitorCount; ++i) {
            this.instructionVisitors[i].visitLookUpSwitchInstruction(clazz, method, codeAttribute, n, lookUpSwitchInstruction);
        }
    }
}

