// Copyright 2014 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "xfa/fxfa/parser/xfa_basic_data.h"

#include "xfa/fxfa/parser/xfa_basic_imp.h"
#include "xfa/fxfa/parser/xfa_doclayout.h"
#include "xfa/fxfa/parser/xfa_document.h"
#include "xfa/fxfa/parser/xfa_localemgr.h"
#include "xfa/fxfa/parser/xfa_object.h"
#include "xfa/fxfa/parser/xfa_parser.h"
#include "xfa/fxfa/parser/xfa_script.h"
#include "xfa/fxfa/parser/xfa_script_datawindow.h"
#include "xfa/fxfa/parser/xfa_script_eventpseudomodel.h"
#include "xfa/fxfa/parser/xfa_script_hostpseudomodel.h"
#include "xfa/fxfa/parser/xfa_script_layoutpseudomodel.h"
#include "xfa/fxfa/parser/xfa_script_logpseudomodel.h"
#include "xfa/fxfa/parser/xfa_script_signaturepseudomodel.h"
#include "xfa/fxfa/parser/xfa_utils.h"

const XFA_ATTRIBUTEENUMINFO g_XFAEnumData[] = {
    {0x2a, L"*", XFA_ATTRIBUTEENUM_Asterisk},
    {0x2f, L"/", XFA_ATTRIBUTEENUM_Slash},
    {0x5c, L"\\", XFA_ATTRIBUTEENUM_Backslash},
    {0x239bd, L"on", XFA_ATTRIBUTEENUM_On},
    {0x25356, L"tb", XFA_ATTRIBUTEENUM_Tb},
    {0x25885, L"up", XFA_ATTRIBUTEENUM_Up},
    {0x91b281, L"metaData", XFA_ATTRIBUTEENUM_MetaData},
    {0x1f8dedb, L"delegate", XFA_ATTRIBUTEENUM_Delegate},
    {0x2a6c55a, L"postSubmit", XFA_ATTRIBUTEENUM_PostSubmit},
    {0x31b19c1, L"name", XFA_ATTRIBUTEENUM_Name},
    {0x378a38a, L"cross", XFA_ATTRIBUTEENUM_Cross},
    {0x3848b3f, L"next", XFA_ATTRIBUTEENUM_Next},
    {0x48b6670, L"none", XFA_ATTRIBUTEENUM_None},
    {0x51aafe5, L"shortEdge", XFA_ATTRIBUTEENUM_ShortEdge},
    {0x55264c4, L"1mod10_1mod11", XFA_ATTRIBUTEENUM_1mod10_1mod11},
    {0x5a5c519, L"height", XFA_ATTRIBUTEENUM_Height},
    {0x89ce549, L"crossDiagonal", XFA_ATTRIBUTEENUM_CrossDiagonal},
    {0x9f9d0f9, L"all", XFA_ATTRIBUTEENUM_All},
    {0x9f9db48, L"any", XFA_ATTRIBUTEENUM_Any},
    {0xa126261, L"toRight", XFA_ATTRIBUTEENUM_ToRight},
    {0xa36de29, L"matchTemplate", XFA_ATTRIBUTEENUM_MatchTemplate},
    {0xa48d040, L"dpl", XFA_ATTRIBUTEENUM_Dpl},
    {0xa559c05, L"invisible", XFA_ATTRIBUTEENUM_Invisible},
    {0xa7d48e3, L"fit", XFA_ATTRIBUTEENUM_Fit},
    {0xa8a8f80, L"width", XFA_ATTRIBUTEENUM_Width},
    {0xab466bb, L"preSubmit", XFA_ATTRIBUTEENUM_PreSubmit},
    {0xacc5785, L"ipl", XFA_ATTRIBUTEENUM_Ipl},
    {0xafab0f8, L"flateCompress", XFA_ATTRIBUTEENUM_FlateCompress},
    {0xb355816, L"med", XFA_ATTRIBUTEENUM_Med},
    {0xb69ef77, L"odd", XFA_ATTRIBUTEENUM_Odd},
    {0xb69f9bb, L"off", XFA_ATTRIBUTEENUM_Off},
    {0xb843dba, L"pdf", XFA_ATTRIBUTEENUM_Pdf},
    {0xbb912b8, L"row", XFA_ATTRIBUTEENUM_Row},
    {0xbedaf33, L"top", XFA_ATTRIBUTEENUM_Top},
    {0xc56afcc, L"xdp", XFA_ATTRIBUTEENUM_Xdp},
    {0xc56ba02, L"xfd", XFA_ATTRIBUTEENUM_Xfd},
    {0xc56ddf1, L"xml", XFA_ATTRIBUTEENUM_Xml},
    {0xc8b65f3, L"zip", XFA_ATTRIBUTEENUM_Zip},
    {0xc8b89d6, L"zpl", XFA_ATTRIBUTEENUM_Zpl},
    {0xf55d7ee, L"visible", XFA_ATTRIBUTEENUM_Visible},
    {0xfe3596a, L"exclude", XFA_ATTRIBUTEENUM_Exclude},
    {0x109d7ce7, L"mouseEnter", XFA_ATTRIBUTEENUM_MouseEnter},
    {0x10f1bc0c, L"pair", XFA_ATTRIBUTEENUM_Pair},
    {0x1154efe6, L"filter", XFA_ATTRIBUTEENUM_Filter},
    {0x125bc94b, L"moveLast", XFA_ATTRIBUTEENUM_MoveLast},
    {0x12e1f1f0, L"exportAndImport", XFA_ATTRIBUTEENUM_ExportAndImport},
    {0x13000c60, L"push", XFA_ATTRIBUTEENUM_Push},
    {0x138ee315, L"portrait", XFA_ATTRIBUTEENUM_Portrait},
    {0x14da2125, L"default", XFA_ATTRIBUTEENUM_Default},
    {0x157749a5, L"storedProc", XFA_ATTRIBUTEENUM_StoredProc},
    {0x16641198, L"stayBOF", XFA_ATTRIBUTEENUM_StayBOF},
    {0x16b2fc5b, L"stayEOF", XFA_ATTRIBUTEENUM_StayEOF},
    {0x17fad373, L"postPrint", XFA_ATTRIBUTEENUM_PostPrint},
    {0x193207d0, L"usCarrier", XFA_ATTRIBUTEENUM_UsCarrier},
    {0x193ade3e, L"right", XFA_ATTRIBUTEENUM_Right},
    {0x1bfc72d9, L"preOpen", XFA_ATTRIBUTEENUM_PreOpen},
    {0x1cc9317a, L"actual", XFA_ATTRIBUTEENUM_Actual},
    {0x1f31df1e, L"rest", XFA_ATTRIBUTEENUM_Rest},
    {0x1fb1bf14, L"topCenter", XFA_ATTRIBUTEENUM_TopCenter},
    {0x207de667, L"standardSymbol", XFA_ATTRIBUTEENUM_StandardSymbol},
    {0x2196a452, L"initialize", XFA_ATTRIBUTEENUM_Initialize},
    {0x23bd40c7, L"justifyAll", XFA_ATTRIBUTEENUM_JustifyAll},
    {0x247cf3e9, L"normal", XFA_ATTRIBUTEENUM_Normal},
    {0x25aa946b, L"landscape", XFA_ATTRIBUTEENUM_Landscape},
    {0x2739b5c9, L"nonInteractive", XFA_ATTRIBUTEENUM_NonInteractive},
    {0x27410f03, L"mouseExit", XFA_ATTRIBUTEENUM_MouseExit},
    {0x2854e62c, L"minus", XFA_ATTRIBUTEENUM_Minus},
    {0x287e936a, L"diagonalLeft", XFA_ATTRIBUTEENUM_DiagonalLeft},
    {0x2972a98f, L"simplexPaginated", XFA_ATTRIBUTEENUM_SimplexPaginated},
    {0x29d8225f, L"document", XFA_ATTRIBUTEENUM_Document},
    {0x2a9d3016, L"warning", XFA_ATTRIBUTEENUM_Warning},
    {0x2b35b6d9, L"auto", XFA_ATTRIBUTEENUM_Auto},
    {0x2c1653d9, L"below", XFA_ATTRIBUTEENUM_Below},
    {0x2c1f0540, L"bottomLeft", XFA_ATTRIBUTEENUM_BottomLeft},
    {0x2c44e816, L"bottomCenter", XFA_ATTRIBUTEENUM_BottomCenter},
    {0x2cd3e9f3, L"tcpl", XFA_ATTRIBUTEENUM_Tcpl},
    {0x2d08af85, L"text", XFA_ATTRIBUTEENUM_Text},
    {0x2dc478eb, L"grouping", XFA_ATTRIBUTEENUM_Grouping},
    {0x2ef3afdd, L"secureSymbol", XFA_ATTRIBUTEENUM_SecureSymbol},
    {0x2f2dd29a, L"preExecute", XFA_ATTRIBUTEENUM_PreExecute},
    {0x33c43dec, L"docClose", XFA_ATTRIBUTEENUM_DocClose},
    {0x33f25bb5, L"keyset", XFA_ATTRIBUTEENUM_Keyset},
    {0x34e363da, L"vertical", XFA_ATTRIBUTEENUM_Vertical},
    {0x361fa1b6, L"preSave", XFA_ATTRIBUTEENUM_PreSave},
    {0x36f1c6d8, L"preSign", XFA_ATTRIBUTEENUM_PreSign},
    {0x399f02b5, L"bottom", XFA_ATTRIBUTEENUM_Bottom},
    {0x3b0ab096, L"toTop", XFA_ATTRIBUTEENUM_ToTop},
    {0x3c752495, L"verify", XFA_ATTRIBUTEENUM_Verify},
    {0x3ce05d68, L"first", XFA_ATTRIBUTEENUM_First},
    {0x3ecead94, L"contentArea", XFA_ATTRIBUTEENUM_ContentArea},
    {0x40623b5b, L"solid", XFA_ATTRIBUTEENUM_Solid},
    {0x42c6cd8d, L"pessimistic", XFA_ATTRIBUTEENUM_Pessimistic},
    {0x43ddc6bf, L"duplexPaginated", XFA_ATTRIBUTEENUM_DuplexPaginated},
    {0x442f68c8, L"round", XFA_ATTRIBUTEENUM_Round},
    {0x45efb847, L"remerge", XFA_ATTRIBUTEENUM_Remerge},
    {0x46972265, L"ordered", XFA_ATTRIBUTEENUM_Ordered},
    {0x46f95531, L"percent", XFA_ATTRIBUTEENUM_Percent},
    {0x46fd25ae, L"even", XFA_ATTRIBUTEENUM_Even},
    {0x4731d6ba, L"exit", XFA_ATTRIBUTEENUM_Exit},
    {0x4977356b, L"toolTip", XFA_ATTRIBUTEENUM_ToolTip},
    {0x49b980ee, L"orderedOccurrence", XFA_ATTRIBUTEENUM_OrderedOccurrence},
    {0x4a7e2dfe, L"readOnly", XFA_ATTRIBUTEENUM_ReadOnly},
    {0x4c4e8acb, L"currency", XFA_ATTRIBUTEENUM_Currency},
    {0x4dcf25f8, L"concat", XFA_ATTRIBUTEENUM_Concat},
    {0x4febb826, L"Thai", XFA_ATTRIBUTEENUM_Thai},
    {0x50ef95b2, L"embossed", XFA_ATTRIBUTEENUM_Embossed},
    {0x516e35ce, L"formdata", XFA_ATTRIBUTEENUM_Formdata},
    {0x52fa6f0e, L"Greek", XFA_ATTRIBUTEENUM_Greek},
    {0x54034c2f, L"decimal", XFA_ATTRIBUTEENUM_Decimal},
    {0x542c7300, L"select", XFA_ATTRIBUTEENUM_Select},
    {0x551f0ae5, L"longEdge", XFA_ATTRIBUTEENUM_LongEdge},
    {0x55520a8a, L"protected", XFA_ATTRIBUTEENUM_Protected},
    {0x559f76f3, L"bottomRight", XFA_ATTRIBUTEENUM_BottomRight},
    {0x568cb500, L"zero", XFA_ATTRIBUTEENUM_Zero},
    {0x56bcecb7, L"forwardOnly", XFA_ATTRIBUTEENUM_ForwardOnly},
    {0x56bf456b, L"docReady", XFA_ATTRIBUTEENUM_DocReady},
    {0x573cb40c, L"hidden", XFA_ATTRIBUTEENUM_Hidden},
    {0x582e3424, L"include", XFA_ATTRIBUTEENUM_Include},
    {0x58a3dd29, L"dashed", XFA_ATTRIBUTEENUM_Dashed},
    {0x5955b22b, L"multiSelect", XFA_ATTRIBUTEENUM_MultiSelect},
    {0x598d5c53, L"inactive", XFA_ATTRIBUTEENUM_Inactive},
    {0x59c8f27d, L"embed", XFA_ATTRIBUTEENUM_Embed},
    {0x5e7555e8, L"static", XFA_ATTRIBUTEENUM_Static},
    {0x606d4def, L"onEntry", XFA_ATTRIBUTEENUM_OnEntry},
    {0x6195eafb, L"Cyrillic", XFA_ATTRIBUTEENUM_Cyrillic},
    {0x6491b0f3, L"nonBlank", XFA_ATTRIBUTEENUM_NonBlank},
    {0x67bef031, L"topRight", XFA_ATTRIBUTEENUM_TopRight},
    {0x67df5ebd, L"Hebrew", XFA_ATTRIBUTEENUM_Hebrew},
    {0x6aea98be, L"topLeft", XFA_ATTRIBUTEENUM_TopLeft},
    {0x6c51afc1, L"center", XFA_ATTRIBUTEENUM_Center},
    {0x7145e6bf, L"moveFirst", XFA_ATTRIBUTEENUM_MoveFirst},
    {0x7375465c, L"diamond", XFA_ATTRIBUTEENUM_Diamond},
    {0x7461aef4, L"pageOdd", XFA_ATTRIBUTEENUM_PageOdd},
    {0x75f8aeb2, L"1mod10", XFA_ATTRIBUTEENUM_1mod10},
    {0x76d708e0, L"Korean", XFA_ATTRIBUTEENUM_Korean},
    {0x789f14d7, L"aboveEmbedded", XFA_ATTRIBUTEENUM_AboveEmbedded},
    {0x792ea39f, L"zipCompress", XFA_ATTRIBUTEENUM_ZipCompress},
    {0x7a5b7193, L"numeric", XFA_ATTRIBUTEENUM_Numeric},
    {0x7abec0d2, L"circle", XFA_ATTRIBUTEENUM_Circle},
    {0x7afbba38, L"toBottom", XFA_ATTRIBUTEENUM_ToBottom},
    {0x7b95e661, L"inverted", XFA_ATTRIBUTEENUM_Inverted},
    {0x7baca2e3, L"update", XFA_ATTRIBUTEENUM_Update},
    {0x7eb5da2c, L"isoname", XFA_ATTRIBUTEENUM_Isoname},
    {0x7f6fd3d7, L"server", XFA_ATTRIBUTEENUM_Server},
    {0x814f82b5, L"position", XFA_ATTRIBUTEENUM_Position},
    {0x82deacf0, L"middleCenter", XFA_ATTRIBUTEENUM_MiddleCenter},
    {0x83a49dc6, L"optional", XFA_ATTRIBUTEENUM_Optional},
    {0x861a116f, L"usePrinterSetting", XFA_ATTRIBUTEENUM_UsePrinterSetting},
    {0x86701ce0, L"outline", XFA_ATTRIBUTEENUM_Outline},
    {0x8808385e, L"indexChange", XFA_ATTRIBUTEENUM_IndexChange},
    {0x891f4606, L"change", XFA_ATTRIBUTEENUM_Change},
    {0x89939f36, L"pageArea", XFA_ATTRIBUTEENUM_PageArea},
    {0x8b5c3b25, L"once", XFA_ATTRIBUTEENUM_Once},
    {0x8b5c6962, L"only", XFA_ATTRIBUTEENUM_Only},
    {0x8b90e1f2, L"open", XFA_ATTRIBUTEENUM_Open},
    {0x8bcfe96e, L"caption", XFA_ATTRIBUTEENUM_Caption},
    {0x8ce83ef8, L"raised", XFA_ATTRIBUTEENUM_Raised},
    {0x8d269cae, L"justify", XFA_ATTRIBUTEENUM_Justify},
    {0x8fd520dc, L"refAndDescendants", XFA_ATTRIBUTEENUM_RefAndDescendants},
    {0x9041d4b0, L"short", XFA_ATTRIBUTEENUM_Short},
    {0x90c94426, L"pageFront", XFA_ATTRIBUTEENUM_PageFront},
    {0x936beee5, L"monospace", XFA_ATTRIBUTEENUM_Monospace},
    {0x947fa00f, L"middle", XFA_ATTRIBUTEENUM_Middle},
    {0x9528a7b4, L"prePrint", XFA_ATTRIBUTEENUM_PrePrint},
    {0x959ab231, L"always", XFA_ATTRIBUTEENUM_Always},
    {0x96d61bf0, L"unknown", XFA_ATTRIBUTEENUM_Unknown},
    {0x997194ee, L"toLeft", XFA_ATTRIBUTEENUM_ToLeft},
    {0x9a83a3cd, L"above", XFA_ATTRIBUTEENUM_Above},
    {0x9d0d71c7, L"dashDot", XFA_ATTRIBUTEENUM_DashDot},
    {0x9df56f3e, L"gregorian", XFA_ATTRIBUTEENUM_Gregorian},
    {0x9f6723fd, L"Roman", XFA_ATTRIBUTEENUM_Roman},
    {0x9f693b21, L"mouseDown", XFA_ATTRIBUTEENUM_MouseDown},
    {0xa1429b36, L"symbol", XFA_ATTRIBUTEENUM_Symbol},
    {0xa5aa45cb, L"pageEven", XFA_ATTRIBUTEENUM_PageEven},
    {0xa68635f1, L"sign", XFA_ATTRIBUTEENUM_Sign},
    {0xa7315093, L"addNew", XFA_ATTRIBUTEENUM_AddNew},
    {0xa7a773fa, L"star", XFA_ATTRIBUTEENUM_Star},
    {0xa7d57b45, L"optimistic", XFA_ATTRIBUTEENUM_Optimistic},
    {0xa8077321, L"rl-tb", XFA_ATTRIBUTEENUM_Rl_tb},
    {0xa8f1468d, L"middleRight", XFA_ATTRIBUTEENUM_MiddleRight},
    {0xaa84a1f1, L"maintain", XFA_ATTRIBUTEENUM_Maintain},
    {0xab40b12c, L"package", XFA_ATTRIBUTEENUM_Package},
    {0xac8b4d85, L"SimplifiedChinese", XFA_ATTRIBUTEENUM_SimplifiedChinese},
    {0xadae6744, L"toCenter", XFA_ATTRIBUTEENUM_ToCenter},
    {0xb0129df1, L"back", XFA_ATTRIBUTEENUM_Back},
    {0xb0f088cf, L"unspecified", XFA_ATTRIBUTEENUM_Unspecified},
    {0xb1271067, L"batchOptimistic", XFA_ATTRIBUTEENUM_BatchOptimistic},
    {0xb18313a1, L"bold", XFA_ATTRIBUTEENUM_Bold},
    {0xb1833cad, L"both", XFA_ATTRIBUTEENUM_Both},
    {0xb221123f, L"butt", XFA_ATTRIBUTEENUM_Butt},
    {0xb40c36bf, L"client", XFA_ATTRIBUTEENUM_Client},
    {0xb56c7053, L"2mod10", XFA_ATTRIBUTEENUM_2mod10},
    {0xb683a345, L"imageOnly", XFA_ATTRIBUTEENUM_ImageOnly},
    {0xb7732dea, L"horizontal", XFA_ATTRIBUTEENUM_Horizontal},
    {0xb88652a4, L"dotted", XFA_ATTRIBUTEENUM_Dotted},
    {0xbb2f2880, L"userControl", XFA_ATTRIBUTEENUM_UserControl},
    {0xbbb79c5d, L"diagonalRight", XFA_ATTRIBUTEENUM_DiagonalRight},
    {0xbd077154, L"consumeData", XFA_ATTRIBUTEENUM_ConsumeData},
    {0xbd3fb11e, L"check", XFA_ATTRIBUTEENUM_Check},
    {0xbde9abda, L"data", XFA_ATTRIBUTEENUM_Data},
    {0xbf5a02d8, L"down", XFA_ATTRIBUTEENUM_Down},
    {0xbf7450ee, L"sansSerif", XFA_ATTRIBUTEENUM_SansSerif},
    {0xc02d649f, L"inline", XFA_ATTRIBUTEENUM_Inline},
    {0xc11a9e3a, L"TraditionalChinese", XFA_ATTRIBUTEENUM_TraditionalChinese},
    {0xc16169d8, L"warn", XFA_ATTRIBUTEENUM_Warn},
    {0xc16f071f, L"refOnly", XFA_ATTRIBUTEENUM_RefOnly},
    {0xc27c8ba5, L"interactiveForms", XFA_ATTRIBUTEENUM_InteractiveForms},
    {0xc2d1b15c, L"word", XFA_ATTRIBUTEENUM_Word},
    {0xc3621288, L"unordered", XFA_ATTRIBUTEENUM_Unordered},
    {0xc5251981, L"required", XFA_ATTRIBUTEENUM_Required},
    {0xc7088e7d, L"importOnly", XFA_ATTRIBUTEENUM_ImportOnly},
    {0xc72cf0e3, L"belowEmbedded", XFA_ATTRIBUTEENUM_BelowEmbedded},
    {0xc819cf07, L"Japanese", XFA_ATTRIBUTEENUM_Japanese},
    {0xcdce56b3, L"full", XFA_ATTRIBUTEENUM_Full},
    {0xce0122e3, L"rl-row", XFA_ATTRIBUTEENUM_Rl_row},
    {0xcf7d71f1, L"Vietnamese", XFA_ATTRIBUTEENUM_Vietnamese},
    {0xcfde3e09, L"EastEuropeanRoman", XFA_ATTRIBUTEENUM_EastEuropeanRoman},
    {0xd576d08e, L"mouseUp", XFA_ATTRIBUTEENUM_MouseUp},
    {0xd7a92904, L"exportOnly", XFA_ATTRIBUTEENUM_ExportOnly},
    {0xd8ed1467, L"clear", XFA_ATTRIBUTEENUM_Clear},
    {0xd95657a6, L"click", XFA_ATTRIBUTEENUM_Click},
    {0xd96c7de5, L"base64", XFA_ATTRIBUTEENUM_Base64},
    {0xd9f47f36, L"close", XFA_ATTRIBUTEENUM_Close},
    {0xdb075bde, L"host", XFA_ATTRIBUTEENUM_Host},
    {0xdb103411, L"global", XFA_ATTRIBUTEENUM_Global},
    {0xdb647188, L"blank", XFA_ATTRIBUTEENUM_Blank},
    {0xdb9be968, L"table", XFA_ATTRIBUTEENUM_Table},
    {0xdf590fbb, L"import", XFA_ATTRIBUTEENUM_Import},
    {0xe0e573fb, L"custom", XFA_ATTRIBUTEENUM_Custom},
    {0xe0ecc79a, L"middleLeft", XFA_ATTRIBUTEENUM_MiddleLeft},
    {0xe1452019, L"postExecute", XFA_ATTRIBUTEENUM_PostExecute},
    {0xe1911d98, L"radix", XFA_ATTRIBUTEENUM_Radix},
    {0xe25fa7b8, L"postOpen", XFA_ATTRIBUTEENUM_PostOpen},
    {0xe28dce7e, L"enter", XFA_ATTRIBUTEENUM_Enter},
    {0xe2c44de4, L"ignore", XFA_ATTRIBUTEENUM_Ignore},
    {0xe2cd8c61, L"lr-tb", XFA_ATTRIBUTEENUM_Lr_tb},
    {0xe2da8336, L"fantasy", XFA_ATTRIBUTEENUM_Fantasy},
    {0xe31d5396, L"italic", XFA_ATTRIBUTEENUM_Italic},
    {0xe7ada113, L"author", XFA_ATTRIBUTEENUM_Author},
    {0xe8e7cc18, L"toEdge", XFA_ATTRIBUTEENUM_ToEdge},
    {0xe97aa98b, L"choice", XFA_ATTRIBUTEENUM_Choice},
    {0xeafd2a38, L"disabled", XFA_ATTRIBUTEENUM_Disabled},
    {0xeb2b7972, L"crossHatch", XFA_ATTRIBUTEENUM_CrossHatch},
    {0xeb2db2d7, L"dataRef", XFA_ATTRIBUTEENUM_DataRef},
    {0xec35dc6e, L"dashDotDot", XFA_ATTRIBUTEENUM_DashDotDot},
    {0xef85d351, L"square", XFA_ATTRIBUTEENUM_Square},
    {0xf2102445, L"dynamic", XFA_ATTRIBUTEENUM_Dynamic},
    {0xf272c7be, L"manual", XFA_ATTRIBUTEENUM_Manual},
    {0xf2bbb64d, L"etched", XFA_ATTRIBUTEENUM_Etched},
    {0xf3b8fc6c, L"validationState", XFA_ATTRIBUTEENUM_ValidationState},
    {0xf42f2b81, L"cursive", XFA_ATTRIBUTEENUM_Cursive},
    {0xf54481d4, L"last", XFA_ATTRIBUTEENUM_Last},
    {0xf5ad782b, L"left", XFA_ATTRIBUTEENUM_Left},
    {0xf616da2e, L"link", XFA_ATTRIBUTEENUM_Link},
    {0xf6b4afb0, L"long", XFA_ATTRIBUTEENUM_Long},
    {0xf8636460, L"internationalCarrier",
     XFA_ATTRIBUTEENUM_InternationalCarrier},
    {0xf9fb37ac, L"PDF1.3", XFA_ATTRIBUTEENUM_PDF1_3},
    {0xf9fb37af, L"PDF1.6", XFA_ATTRIBUTEENUM_PDF1_6},
    {0xfbce7f19, L"serif", XFA_ATTRIBUTEENUM_Serif},
    {0xfc82d695, L"postSave", XFA_ATTRIBUTEENUM_PostSave},
    {0xfcef86b5, L"ready", XFA_ATTRIBUTEENUM_Ready},
    {0xfd54fbb7, L"postSign", XFA_ATTRIBUTEENUM_PostSign},
    {0xfdc0aae2, L"Arabic", XFA_ATTRIBUTEENUM_Arabic},
    {0xfe06d2ca, L"error", XFA_ATTRIBUTEENUM_Error},
    {0xfefc4885, L"urlencoded", XFA_ATTRIBUTEENUM_Urlencoded},
    {0xff795ad2, L"lowered", XFA_ATTRIBUTEENUM_Lowered},
};
const int32_t g_iXFAEnumCount =
    sizeof(g_XFAEnumData) / sizeof(XFA_ATTRIBUTEENUMINFO);

static const CXFA_Measurement g_XFAMeasurementData[] = {
    CXFA_Measurement(0, XFA_UNIT_In),
    CXFA_Measurement(0, XFA_UNIT_Pt),
    CXFA_Measurement(5, XFA_UNIT_Mm),
    CXFA_Measurement(0.25, XFA_UNIT_Mm),
    CXFA_Measurement(-1, XFA_UNIT_Unknown),
    CXFA_Measurement(0, XFA_UNIT_Angle),
    CXFA_Measurement(10, XFA_UNIT_Pt),
    CXFA_Measurement(360, XFA_UNIT_Angle),
    CXFA_Measurement(0.5, XFA_UNIT_Pt),
};

const XFA_ATTRIBUTEINFO g_XFAAttributeData[] = {
    {0x68, L"h", XFA_ATTRIBUTE_H, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x77, L"w", XFA_ATTRIBUTE_W, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x78, L"x", XFA_ATTRIBUTE_X, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x79, L"y", XFA_ATTRIBUTE_Y, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x21aed, L"id", XFA_ATTRIBUTE_Id, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template |
         XFA_XDPPACKET_ConnectionSet | XFA_XDPPACKET_Form,
     nullptr},
    {0x25363, L"to", XFA_ATTRIBUTE_To, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Config, nullptr},
    {0xcb0ac9, L"lineThrough", XFA_ATTRIBUTE_LineThrough,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x2282c73, L"hAlign", XFA_ATTRIBUTE_HAlign, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Left},
    {0x2c1c7f1, L"typeface", XFA_ATTRIBUTE_Typeface, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)L"Courier"},
    {0x3106c3a, L"beforeTarget", XFA_ATTRIBUTE_BeforeTarget,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x31b19c1, L"name", XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Config | XFA_XDPPACKET_LocaleSet |
         XFA_XDPPACKET_Template | XFA_XDPPACKET_Datasets | XFA_XDPPACKET_Form |
         XFA_XDPPACKET_ConnectionSet | XFA_XDPPACKET_Form,
     nullptr},
    {0x3848b3f, L"next", XFA_ATTRIBUTE_Next, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_None},
    {0x43e349b, L"dataRowCount", XFA_ATTRIBUTE_DataRowCount,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x5518c25, L"break", XFA_ATTRIBUTE_Break, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Close},
    {0x5ce6195, L"vScrollPolicy", XFA_ATTRIBUTE_VScrollPolicy,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Auto},
    {0x8c74ae9, L"fontHorizontalScale", XFA_ATTRIBUTE_FontHorizontalScale,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)L"100%"},
    {0x8d4f1c7, L"textIndent", XFA_ATTRIBUTE_TextIndent,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x97c1c65, L"context", XFA_ATTRIBUTE_Context, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_UNKNOWN, (void*)0},
    {0x9876578, L"trayOut", XFA_ATTRIBUTE_TrayOut, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Auto},
    {0xa2e3514, L"cap", XFA_ATTRIBUTE_Cap, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Square},
    {0xb3543a6, L"max", XFA_ATTRIBUTE_Max, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xb356ca4, L"min", XFA_ATTRIBUTE_Min, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)1},
    {0xbb8df5d, L"ref", XFA_ATTRIBUTE_Ref, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Config | XFA_XDPPACKET_Template |
         XFA_XDPPACKET_Form,
     nullptr},
    {0xbb8f3df, L"rid", XFA_ATTRIBUTE_Rid, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xc080cd3, L"url", XFA_ATTRIBUTE_Url, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xc0811ed, L"use", XFA_ATTRIBUTE_Use, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template |
         XFA_XDPPACKET_ConnectionSet | XFA_XDPPACKET_Form,
     nullptr},
    {0xcfea02e, L"leftInset", XFA_ATTRIBUTE_LeftInset,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x1026c59d, L"widows", XFA_ATTRIBUTE_Widows, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0x1059ec18, L"level", XFA_ATTRIBUTE_Level, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Config, (void*)0},
    {0x1356caf8, L"bottomInset", XFA_ATTRIBUTE_BottomInset,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x13a08bdb, L"overflowTarget", XFA_ATTRIBUTE_OverflowTarget,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x1414d431, L"allowMacro", XFA_ATTRIBUTE_AllowMacro,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x14a32d52, L"pagePosition", XFA_ATTRIBUTE_PagePosition,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Any},
    {0x1517dfa1, L"columnWidths", XFA_ATTRIBUTE_ColumnWidths,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x169134a1, L"overflowLeader", XFA_ATTRIBUTE_OverflowLeader,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x1b8dce3e, L"action", XFA_ATTRIBUTE_Action, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Include},
    {0x1e459b8f, L"nonRepudiation", XFA_ATTRIBUTE_NonRepudiation,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x1ec8ab2c, L"rate", XFA_ATTRIBUTE_Rate, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)50},
    {0x1ef3a64a, L"allowRichText", XFA_ATTRIBUTE_AllowRichText,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x2038c9b2, L"role", XFA_ATTRIBUTE_Role, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x20914367, L"overflowTrailer", XFA_ATTRIBUTE_OverflowTrailer,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x226ca8f1, L"operation", XFA_ATTRIBUTE_Operation,
     XFA_ATTRIBUTETYPE_NOTSURE, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x24d85167, L"timeout", XFA_ATTRIBUTE_Timeout, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_SourceSet, nullptr},
    {0x25764436, L"topInset", XFA_ATTRIBUTE_TopInset, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x25839852, L"access", XFA_ATTRIBUTE_Access, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Open},
    {0x268b7ec1, L"commandType", XFA_ATTRIBUTE_CommandType,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_SourceSet,
     (void*)XFA_ATTRIBUTEENUM_Unknown},
    {0x28dee6e9, L"format", XFA_ATTRIBUTE_Format, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x28e17e91, L"dataPrep", XFA_ATTRIBUTE_DataPrep, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_None},
    {0x292b88fe, L"widgetData", XFA_ATTRIBUTE_WidgetData,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_UNKNOWN, (void*)0},
    {0x29418bb7, L"abbr", XFA_ATTRIBUTE_Abbr, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_LocaleSet, (void*)0},
    {0x2a82d99c, L"marginRight", XFA_ATTRIBUTE_MarginRight,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x2b5df51e, L"dataDescription", XFA_ATTRIBUTE_DataDescription,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_ConnectionSet, nullptr},
    {0x2bb3f470, L"encipherOnly", XFA_ATTRIBUTE_EncipherOnly,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x2cd79033, L"kerningMode", XFA_ATTRIBUTE_KerningMode,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_None},
    {0x2ee7678f, L"rotate", XFA_ATTRIBUTE_Rotate, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 5)},
    {0x2f105f72, L"wordCharacterCount", XFA_ATTRIBUTE_WordCharacterCount,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)7},
    {0x2f16a382, L"type", XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x34ae103c, L"reserve", XFA_ATTRIBUTE_Reserve, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 4)},
    {0x3650557e, L"textLocation", XFA_ATTRIBUTE_TextLocation,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Below},
    {0x39cdb0a2, L"priority", XFA_ATTRIBUTE_Priority, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Custom},
    {0x3a0273a6, L"underline", XFA_ATTRIBUTE_Underline,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x3b582286, L"moduleWidth", XFA_ATTRIBUTE_ModuleWidth,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 3)},
    {0x3d123c26, L"hyphenate", XFA_ATTRIBUTE_Hyphenate,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x3e7af94f, L"listen", XFA_ATTRIBUTE_Listen, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_RefOnly},
    {0x4156ee3f, L"delimiter", XFA_ATTRIBUTE_Delimiter, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x42fed1fd, L"contentType", XFA_ATTRIBUTE_ContentType,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template |
                                  XFA_XDPPACKET_Datasets | XFA_XDPPACKET_Form,
     nullptr},
    {0x453eaf38, L"startNew", XFA_ATTRIBUTE_StartNew, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0x45a6daf8, L"eofAction", XFA_ATTRIBUTE_EofAction, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_SourceSet, (void*)XFA_ATTRIBUTEENUM_MoveLast},
    {0x47cfa43a, L"allowNeutral", XFA_ATTRIBUTE_AllowNeutral,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x47d03490, L"connection", XFA_ATTRIBUTE_Connection,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x4873c601, L"baselineShift", XFA_ATTRIBUTE_BaselineShift,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x4b319767, L"overlinePeriod", XFA_ATTRIBUTE_OverlinePeriod,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_All},
    {0x4b8bc840, L"fracDigits", XFA_ATTRIBUTE_FracDigits,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)2},
    {0x4ef3d02c, L"orientation", XFA_ATTRIBUTE_Orientation,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Portrait},
    {0x4fdc3454, L"timeStamp", XFA_ATTRIBUTE_TimeStamp, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_XDP, nullptr},
    {0x52666f1c, L"printCheckDigit", XFA_ATTRIBUTE_PrintCheckDigit,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x534729c9, L"marginLeft", XFA_ATTRIBUTE_MarginLeft,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x5392ea58, L"stroke", XFA_ATTRIBUTE_Stroke, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Solid},
    {0x5404d6df, L"moduleHeight", XFA_ATTRIBUTE_ModuleHeight,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 2)},
    {0x54fa722c, L"transferEncoding", XFA_ATTRIBUTE_TransferEncoding,
     XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x552d9ad5, L"usage", XFA_ATTRIBUTE_Usage, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_ExportAndImport},
    {0x570ce835, L"presence", XFA_ATTRIBUTE_Presence, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Visible},
    {0x5739d1ff, L"radixOffset", XFA_ATTRIBUTE_RadixOffset,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x577682ac, L"preserve", XFA_ATTRIBUTE_Preserve, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x58be2870, L"aliasNode", XFA_ATTRIBUTE_AliasNode,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_UNKNOWN, (void*)0},
    {0x5a32e493, L"multiLine", XFA_ATTRIBUTE_MultiLine,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x5a50e9e6, L"version", XFA_ATTRIBUTE_Version, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x5ab23b6c, L"startChar", XFA_ATTRIBUTE_StartChar, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x5b707a35, L"scriptTest", XFA_ATTRIBUTE_ScriptTest,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Error},
    {0x5c054755, L"startAngle", XFA_ATTRIBUTE_StartAngle,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 5)},
    {0x5ec958c0, L"cursorType", XFA_ATTRIBUTE_CursorType,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_SourceSet,
     (void*)XFA_ATTRIBUTEENUM_ForwardOnly},
    {0x5f760b50, L"digitalSignature", XFA_ATTRIBUTE_DigitalSignature,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x60a61edd, L"codeType", XFA_ATTRIBUTE_CodeType, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x60d4c8b1, L"output", XFA_ATTRIBUTE_Output, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_ConnectionSet, nullptr},
    {0x64110ab5, L"bookendTrailer", XFA_ATTRIBUTE_BookendTrailer,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x65e30c67, L"imagingBBox", XFA_ATTRIBUTE_ImagingBBox,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)L"none"},
    {0x66539c48, L"excludeInitialCap", XFA_ATTRIBUTE_ExcludeInitialCap,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x66642f8f, L"force", XFA_ATTRIBUTE_Force, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Config, nullptr},
    {0x69aa2292, L"crlSign", XFA_ATTRIBUTE_CrlSign, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x6a3405dd, L"previous", XFA_ATTRIBUTE_Previous, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_None},
    {0x6a95c976, L"pushCharacterCount", XFA_ATTRIBUTE_PushCharacterCount,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)3},
    {0x6b6ddcfb, L"nullTest", XFA_ATTRIBUTE_NullTest, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Disabled},
    {0x6cfa828a, L"runAt", XFA_ATTRIBUTE_RunAt, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Client},
    {0x731e0665, L"spaceBelow", XFA_ATTRIBUTE_SpaceBelow,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x74788f8b, L"sweepAngle", XFA_ATTRIBUTE_SweepAngle,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 7)},
    {0x78bff531, L"numberOfCells", XFA_ATTRIBUTE_NumberOfCells,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x79543055, L"letterSpacing", XFA_ATTRIBUTE_LetterSpacing,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x79975f2b, L"lockType", XFA_ATTRIBUTE_LockType, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_SourceSet, (void*)XFA_ATTRIBUTEENUM_ReadOnly},
    {0x7a0cc471, L"passwordChar", XFA_ATTRIBUTE_PasswordChar,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)L"*"},
    {0x7a7cc341, L"vAlign", XFA_ATTRIBUTE_VAlign, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)XFA_ATTRIBUTEENUM_Top},
    {0x7b29630a, L"sourceBelow", XFA_ATTRIBUTE_SourceBelow,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Config,
     (void*)XFA_ATTRIBUTEENUM_Update},
    {0x7b95e661, L"inverted", XFA_ATTRIBUTE_Inverted, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0x7c2fd80b, L"mark", XFA_ATTRIBUTE_Mark, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Default},
    {0x7c2ff6ae, L"maxH", XFA_ATTRIBUTE_MaxH, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x7c2ff6bd, L"maxW", XFA_ATTRIBUTE_MaxW, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x7c732a66, L"truncate", XFA_ATTRIBUTE_Truncate, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0x7d02356c, L"minH", XFA_ATTRIBUTE_MinH, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x7d02357b, L"minW", XFA_ATTRIBUTE_MinW, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x7d0b5fca, L"initial", XFA_ATTRIBUTE_Initial, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)1},
    {0x7d9fd7c5, L"mode", XFA_ATTRIBUTE_Mode, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Config, (void*)XFA_ATTRIBUTEENUM_UsePrinterSetting},
    {0x7e7e845e, L"layout", XFA_ATTRIBUTE_Layout, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Position},
    {0x7f6fd3d7, L"server", XFA_ATTRIBUTE_Server, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x824f21b7, L"embedPDF", XFA_ATTRIBUTE_EmbedPDF, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0x8340ea66, L"oddOrEven", XFA_ATTRIBUTE_OddOrEven, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)XFA_ATTRIBUTEENUM_Any},
    {0x836d4d7c, L"tabDefault", XFA_ATTRIBUTE_TabDefault,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x8855805f, L"contains", XFA_ATTRIBUTE_Contains, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Datasets, (void*)XFA_ATTRIBUTEENUM_Data},
    {0x8a692521, L"rightInset", XFA_ATTRIBUTE_RightInset,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x8af2e657, L"maxChars", XFA_ATTRIBUTE_MaxChars, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0x8b90e1f2, L"open", XFA_ATTRIBUTE_Open, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_UserControl},
    {0x8c99377e, L"relation", XFA_ATTRIBUTE_Relation, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x8d181d61, L"wideNarrowRatio", XFA_ATTRIBUTE_WideNarrowRatio,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)L"3:1"},
    {0x8e1c2921, L"relevant", XFA_ATTRIBUTE_Relevant, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x8e29d794, L"signatureType", XFA_ATTRIBUTE_SignatureType,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Filter},
    {0x8ec6204c, L"lineThroughPeriod", XFA_ATTRIBUTE_LineThroughPeriod,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_All},
    {0x8ed182d1, L"shape", XFA_ATTRIBUTE_Shape, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Square},
    {0x8fa01790, L"tabStops", XFA_ATTRIBUTE_TabStops, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x8fc36c0a, L"outputBelow", XFA_ATTRIBUTE_OutputBelow,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Config,
     (void*)XFA_ATTRIBUTEENUM_Warn},
    {0x9041d4b0, L"short", XFA_ATTRIBUTE_Short, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x907c7719, L"fontVerticalScale", XFA_ATTRIBUTE_FontVerticalScale,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)L"100%"},
    {0x94446dcc, L"thickness", XFA_ATTRIBUTE_Thickness,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 8)},
    {0x957fa006, L"commitOn", XFA_ATTRIBUTE_CommitOn, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Select},
    {0x982bd892, L"remainCharacterCount", XFA_ATTRIBUTE_RemainCharacterCount,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)3},
    {0x98fd4d81, L"keyAgreement", XFA_ATTRIBUTE_KeyAgreement,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x99800d7a, L"errorCorrectionLevel", XFA_ATTRIBUTE_ErrorCorrectionLevel,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x9a63da3d, L"upsMode", XFA_ATTRIBUTE_UpsMode, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_UsCarrier},
    {0x9cc17d75, L"mergeMode", XFA_ATTRIBUTE_MergeMode, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_ConsumeData},
    {0x9d833d75, L"circular", XFA_ATTRIBUTE_Circular, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0x9d8ee204, L"psName", XFA_ATTRIBUTE_PsName, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Config, nullptr},
    {0x9dcc3ab3, L"trailer", XFA_ATTRIBUTE_Trailer, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xa0933954, L"unicodeRange", XFA_ATTRIBUTE_UnicodeRange,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Config, nullptr},
    {0xa1b0d2f5, L"executeType", XFA_ATTRIBUTE_ExecuteType,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Import},
    {0xa25a883d, L"duplexImposition", XFA_ATTRIBUTE_DuplexImposition,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_LongEdge},
    {0xa42ca1b7, L"trayIn", XFA_ATTRIBUTE_TrayIn, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Auto},
    {0xa433f001, L"bindingNode", XFA_ATTRIBUTE_BindingNode,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_UNKNOWN, (void*)0},
    {0xa5340ff5, L"bofAction", XFA_ATTRIBUTE_BofAction, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_SourceSet, (void*)XFA_ATTRIBUTEENUM_MoveFirst},
    {0xa5b410cf, L"save", XFA_ATTRIBUTE_Save, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0xa6118c89, L"targetType", XFA_ATTRIBUTE_TargetType,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Auto},
    {0xa66404cb, L"keyEncipherment", XFA_ATTRIBUTE_KeyEncipherment,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xa6710262, L"credentialServerPolicy",
     XFA_ATTRIBUTE_CredentialServerPolicy, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {0xa686975b, L"size", XFA_ATTRIBUTE_Size, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 6)},
    {0xa85e74f3, L"initialNumber", XFA_ATTRIBUTE_InitialNumber,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)1},
    {0xabef37e3, L"slope", XFA_ATTRIBUTE_Slope, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Backslash},
    {0xabfa6c4f, L"cSpace", XFA_ATTRIBUTE_CSpace, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)L"SRGB"},
    {0xac06e2b0, L"colSpan", XFA_ATTRIBUTE_ColSpan, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)1},
    {0xadc4c77b, L"binding", XFA_ATTRIBUTE_Binding, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xaf754613, L"checksum", XFA_ATTRIBUTE_Checksum, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form | XFA_XDPPACKET_Form, nullptr},
    {0xb045fbc5, L"charEncoding", XFA_ATTRIBUTE_CharEncoding,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)L"UTF-8"},
    {0xb0e5485d, L"bind", XFA_ATTRIBUTE_Bind, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_SourceSet, nullptr},
    {0xb12128b7, L"textEntry", XFA_ATTRIBUTE_TextEntry,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0xb373a862, L"archive", XFA_ATTRIBUTE_Archive, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xb598a1f7, L"uuid", XFA_ATTRIBUTE_Uuid, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_XDP, nullptr},
    {0xb5e49bf2, L"posture", XFA_ATTRIBUTE_Posture, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Normal},
    {0xb6b44172, L"after", XFA_ATTRIBUTE_After, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Auto},
    {0xb716467b, L"orphans", XFA_ATTRIBUTE_Orphans, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0xbc0c4695, L"qualifiedName", XFA_ATTRIBUTE_QualifiedName,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_UNKNOWN, nullptr},
    {0xbc254332, L"usehref", XFA_ATTRIBUTE_Usehref, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template |
         XFA_XDPPACKET_ConnectionSet | XFA_XDPPACKET_Form,
     nullptr},
    {0xbc8fa350, L"locale", XFA_ATTRIBUTE_Locale, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xbd6e1d88, L"weight", XFA_ATTRIBUTE_Weight, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Normal},
    {0xbd96a0e9, L"underlinePeriod", XFA_ATTRIBUTE_UnderlinePeriod,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_All},
    {0xbde9abda, L"data", XFA_ATTRIBUTE_Data, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Link},
    {0xbe52dfbf, L"desc", XFA_ATTRIBUTE_Desc, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_LocaleSet, nullptr},
    {0xbe9ba472, L"numbered", XFA_ATTRIBUTE_Numbered, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)1},
    {0xc035c6b1, L"dataColumnCount", XFA_ATTRIBUTE_DataColumnCount,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xc0ec9fa4, L"overline", XFA_ATTRIBUTE_Overline, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0xc2ba0923, L"urlPolicy", XFA_ATTRIBUTE_UrlPolicy, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xc2bd40fd, L"anchorType", XFA_ATTRIBUTE_AnchorType,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_TopLeft},
    {0xc39a88bd, L"labelRef", XFA_ATTRIBUTE_LabelRef, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xc3c1442f, L"bookendLeader", XFA_ATTRIBUTE_BookendLeader,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xc4547a08, L"maxLength", XFA_ATTRIBUTE_MaxLength,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)-1},
    {0xc4fed09b, L"accessKey", XFA_ATTRIBUTE_AccessKey, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xc5762157, L"cursorLocation", XFA_ATTRIBUTE_CursorLocation,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_SourceSet,
     (void*)XFA_ATTRIBUTEENUM_Client},
    {0xc860f30a, L"delayedOpen", XFA_ATTRIBUTE_DelayedOpen,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_SourceSet, nullptr},
    {0xc8da4da7, L"target", XFA_ATTRIBUTE_Target, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xca5dc27c, L"dataEncipherment", XFA_ATTRIBUTE_DataEncipherment,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xcb150479, L"afterTarget", XFA_ATTRIBUTE_AfterTarget,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xcbcaf66d, L"leader", XFA_ATTRIBUTE_Leader, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xcca7897e, L"picker", XFA_ATTRIBUTE_Picker, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Host},
    {0xcd7f7b54, L"from", XFA_ATTRIBUTE_From, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Config, nullptr},
    {0xcea5e62c, L"baseProfile", XFA_ATTRIBUTE_BaseProfile,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Full},
    {0xd171b240, L"aspect", XFA_ATTRIBUTE_Aspect, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)XFA_ATTRIBUTEENUM_Fit},
    {0xd3c84d25, L"rowColumnRatio", XFA_ATTRIBUTE_RowColumnRatio,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xd4b01921, L"lineHeight", XFA_ATTRIBUTE_LineHeight,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 1)},
    {0xd4cc53f8, L"highlight", XFA_ATTRIBUTE_Highlight, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Inverted},
    {0xd50f903a, L"valueRef", XFA_ATTRIBUTE_ValueRef, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xd52482e0, L"maxEntries", XFA_ATTRIBUTE_MaxEntries,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Config, (void*)5},
    {0xd57c513c, L"dataLength", XFA_ATTRIBUTE_DataLength,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xd6128d8d, L"activity", XFA_ATTRIBUTE_Activity, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Click},
    {0xd6a39990, L"input", XFA_ATTRIBUTE_Input, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_ConnectionSet, nullptr},
    {0xd6e27f1d, L"value", XFA_ATTRIBUTE_Value, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Config | XFA_XDPPACKET_LocaleSet |
         XFA_XDPPACKET_Template | XFA_XDPPACKET_Datasets |
         XFA_XDPPACKET_ConnectionSet | XFA_XDPPACKET_Form,
     nullptr},
    {0xd70798c2, L"blankOrNotBlank", XFA_ATTRIBUTE_BlankOrNotBlank,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Any},
    {0xd861f8af, L"addRevocationInfo", XFA_ATTRIBUTE_AddRevocationInfo,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xd8f982bf, L"genericFamily", XFA_ATTRIBUTE_GenericFamily,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Config,
     (void*)XFA_ATTRIBUTEENUM_Serif},
    {0xd996fa9b, L"hand", XFA_ATTRIBUTE_Hand, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Even},
    {0xdb55fec5, L"href", XFA_ATTRIBUTE_Href, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xdc75676c, L"textEncoding", XFA_ATTRIBUTE_TextEncoding,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xde7f92ba, L"leadDigits", XFA_ATTRIBUTE_LeadDigits,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)-1},
    {0xe11a2cbc, L"permissions", XFA_ATTRIBUTE_Permissions,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)2},
    {0xe18b5659, L"spaceAbove", XFA_ATTRIBUTE_SpaceAbove,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0xe1a26b56, L"codeBase", XFA_ATTRIBUTE_CodeBase, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xe349d044, L"stock", XFA_ATTRIBUTE_Stock, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xe372ae97, L"isNull", XFA_ATTRIBUTE_IsNull, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Datasets, (void*)0},
    {0xe4c3a5e5, L"restoreState", XFA_ATTRIBUTE_RestoreState,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Manual},
    {0xe5c96d6a, L"excludeAllCaps", XFA_ATTRIBUTE_ExcludeAllCaps,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0xe64b1129, L"formatTest", XFA_ATTRIBUTE_FormatTest,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Warning},
    {0xe6f99487, L"hScrollPolicy", XFA_ATTRIBUTE_HScrollPolicy,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Auto},
    {0xe8dddf50, L"join", XFA_ATTRIBUTE_Join, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Square},
    {0xe8f118a8, L"keyCertSign", XFA_ATTRIBUTE_KeyCertSign,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xe948b9a8, L"radius", XFA_ATTRIBUTE_Radius, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0xe996b2fe, L"sourceAbove", XFA_ATTRIBUTE_SourceAbove,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Config,
     (void*)XFA_ATTRIBUTEENUM_Warn},
    {0xea7090a0, L"override", XFA_ATTRIBUTE_Override, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xeb091003, L"classId", XFA_ATTRIBUTE_ClassId, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xeb511b54, L"disable", XFA_ATTRIBUTE_Disable, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0xeda9017a, L"scope", XFA_ATTRIBUTE_Scope, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xf197844d, L"match", XFA_ATTRIBUTE_Match, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Once},
    {0xf2009339, L"placement", XFA_ATTRIBUTE_Placement, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Left},
    {0xf4ffce73, L"before", XFA_ATTRIBUTE_Before, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Auto},
    {0xf531b059, L"writingScript", XFA_ATTRIBUTE_WritingScript,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Config,
     (void*)XFA_ATTRIBUTEENUM_Asterisk},
    {0xf575ca75, L"endChar", XFA_ATTRIBUTE_EndChar, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xf6b47749, L"lock", XFA_ATTRIBUTE_Lock, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Config, (void*)0},
    {0xf6b4afb0, L"long", XFA_ATTRIBUTE_Long, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0xf6b59543, L"intact", XFA_ATTRIBUTE_Intact, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_None},
    {0xf889e747, L"xdpContent", XFA_ATTRIBUTE_XdpContent,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xfea53ec6, L"decipherOnly", XFA_ATTRIBUTE_DecipherOnly,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
};
const int32_t g_iXFAAttributeCount =
    sizeof(g_XFAAttributeData) / sizeof(XFA_ATTRIBUTEINFO);

const XFA_NOTSUREATTRIBUTE g_XFANotsureAttributes[] = {
    {XFA_Element::SubformSet, XFA_ATTRIBUTE_Relation, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Ordered},
    {XFA_Element::NumberPattern, XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Numeric},
    {XFA_Element::KeyUsage, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::LabelPrinter, XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Zpl},
    {XFA_Element::CalendarSymbols, XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Gregorian},
    {XFA_Element::Barcode, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Cdata,
     nullptr},
    {XFA_Element::Barcode, XFA_ATTRIBUTE_Checksum, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_None},
    {XFA_Element::TimePattern, XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Med},
    {XFA_Element::BatchOutput, XFA_ATTRIBUTE_Format, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_None},
    {XFA_Element::SubjectDNs, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Issuers, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::EncryptionMethods, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Pattern, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_CrossHatch},
    {XFA_Element::Compress, XFA_ATTRIBUTE_Scope, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_ImageOnly},
    {XFA_Element::Image, XFA_ATTRIBUTE_TransferEncoding, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Base64},
    {XFA_Element::TimeStamp, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Subform, XFA_ATTRIBUTE_Scope, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Name},
    {XFA_Element::Handler, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Record, XFA_ATTRIBUTE_Max, XFA_ATTRIBUTETYPE_Integer,
     (void*)0},
    {XFA_Element::Command, XFA_ATTRIBUTE_Timeout, XFA_ATTRIBUTETYPE_Integer,
     (void*)30},
    {XFA_Element::DigestMethods, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::PageSet, XFA_ATTRIBUTE_Relation, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_OrderedOccurrence},
    {XFA_Element::Equate, XFA_ATTRIBUTE_From, XFA_ATTRIBUTETYPE_Cdata, nullptr},
    {XFA_Element::Equate, XFA_ATTRIBUTE_To, XFA_ATTRIBUTETYPE_Cdata, nullptr},
    {XFA_Element::Traverse, XFA_ATTRIBUTE_Operation, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Next},
    {XFA_Element::Encodings, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Signing, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Oids, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Signature, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_PDF1_3},
    {XFA_Element::ExData, XFA_ATTRIBUTE_TransferEncoding,
     XFA_ATTRIBUTETYPE_Enum, (void*)XFA_ATTRIBUTEENUM_None},
    {XFA_Element::Linear, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_ToRight},
    {XFA_Element::CurrencySymbol, XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Symbol},
    {XFA_Element::EquateRange, XFA_ATTRIBUTE_From, XFA_ATTRIBUTETYPE_Cdata,
     nullptr},
    {XFA_Element::EquateRange, XFA_ATTRIBUTE_To, XFA_ATTRIBUTETYPE_Cdata,
     nullptr},
    {XFA_Element::SignData, XFA_ATTRIBUTE_Operation, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Sign},
    {XFA_Element::DatePattern, XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Med},
    {XFA_Element::Bind, XFA_ATTRIBUTE_TransferEncoding, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_None},
    {XFA_Element::Reasons, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::AppearanceFilter, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Form, XFA_ATTRIBUTE_Checksum, XFA_ATTRIBUTETYPE_Cdata,
     nullptr},
    {XFA_Element::Value, XFA_ATTRIBUTE_Override, XFA_ATTRIBUTETYPE_Boolean,
     (void*)0},
    {XFA_Element::Calculate, XFA_ATTRIBUTE_Override, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Error},
    {XFA_Element::Connect, XFA_ATTRIBUTE_Timeout, XFA_ATTRIBUTETYPE_Integer,
     (void*)15},
    {XFA_Element::Submit, XFA_ATTRIBUTE_Format, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Xdp},
    {XFA_Element::Radial, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_ToEdge},
    {XFA_Element::LockDocument, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Occur, XFA_ATTRIBUTE_Max, XFA_ATTRIBUTETYPE_Integer,
     (void*)1},
    {XFA_Element::NumberSymbol, XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Decimal},
};
const int32_t g_iXFANotsureCount =
    sizeof(g_XFANotsureAttributes) / sizeof(XFA_NOTSUREATTRIBUTE);

const XFA_ELEMENTINFO g_XFAElementData[] = {
    {0x23ee3, L"ps", XFA_Element::Ps, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x25363, L"to", XFA_Element::To, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x2587e, L"ui", XFA_Element::Ui,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x1c648b, L"recordSet", XFA_Element::RecordSet, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::Node},
    {0x171428f, L"subsetBelow", XFA_Element::SubsetBelow, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x1a0776a, L"subformSet", XFA_Element::SubformSet,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x2340d70, L"adobeExtensionLevel", XFA_Element::AdobeExtensionLevel,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x2c1c7f1, L"typeface", XFA_Element::Typeface, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::Node},
    {0x5518c25, L"break", XFA_Element::Break,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x5fff523, L"fontInfo", XFA_Element::FontInfo, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x653a227, L"numberPattern", XFA_Element::NumberPattern,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::ContentNode},
    {0x65b4a05, L"dynamicRender", XFA_Element::DynamicRender,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x7e4362e, L"printScaling", XFA_Element::PrintScaling,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x7fe6d3a, L"checkButton", XFA_Element::CheckButton,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x80cf58f, L"datePatterns", XFA_Element::DatePatterns,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0x811929d, L"sourceSet", XFA_Element::SourceSet, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::ModelNode},
    {0x9f9d612, L"amd", XFA_Element::Amd, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x9f9efb6, L"arc", XFA_Element::Arc,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xa48835e, L"day", XFA_Element::Day, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::ContentNode},
    {0xa6328b8, L"era", XFA_Element::Era, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::ContentNode},
    {0xae6a0a0, L"jog", XFA_Element::Jog, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xb1b3d22, L"log", XFA_Element::Log, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xb35439e, L"map", XFA_Element::Map,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_SourceSet, XFA_ObjectType::Node},
    {0xb355301, L"mdp", XFA_Element::Mdp,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xb420438, L"breakBefore", XFA_Element::BreakBefore,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xb6a091c, L"oid", XFA_Element::Oid,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::TextNode},
    {0xb84389f, L"pcl", XFA_Element::Pcl, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xb843dba, L"pdf", XFA_Element::Pdf, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xbb8df5d, L"ref", XFA_Element::Ref,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::TextNode},
    {0xc080cd0, L"uri", XFA_Element::Uri,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_ConnectionSet,
     XFA_ObjectType::TextNode},
    {0xc56afbf, L"xdc", XFA_Element::Xdc,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Xdc, XFA_ObjectType::ModelNode},
    {0xc56afcc, L"xdp", XFA_Element::Xdp, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xc56b9ff, L"xfa", XFA_Element::Xfa, XFA_XDPPACKET_XDP,
     XFA_ObjectType::ModelNode},
    {0xc56fcb7, L"xsl", XFA_Element::Xsl, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xc8b89d6, L"zpl", XFA_Element::Zpl, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xc9bae94, L"cache", XFA_Element::Cache, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xcb016be, L"margin", XFA_Element::Margin,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xe1378fe, L"keyUsage", XFA_Element::KeyUsage,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xfe3596a, L"exclude", XFA_Element::Exclude, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x10395ac7, L"choiceList", XFA_Element::ChoiceList,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x1059ec18, L"level", XFA_Element::Level, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x10874804, L"labelPrinter", XFA_Element::LabelPrinter,
     XFA_XDPPACKET_Config, XFA_ObjectType::Node},
    {0x10c40e03, L"calendarSymbols", XFA_Element::CalendarSymbols,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0x10f1ea24, L"para", XFA_Element::Para,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x10f1ea37, L"part", XFA_Element::Part, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x1140975b, L"pdfa", XFA_Element::Pdfa, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x1154efe6, L"filter", XFA_Element::Filter,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x13f41de1, L"present", XFA_Element::Present, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x1827e6ea, L"pagination", XFA_Element::Pagination, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x18463707, L"encoding", XFA_Element::Encoding,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::NodeC},
    {0x185e41e2, L"event", XFA_Element::Event,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x1adb142d, L"whitespace", XFA_Element::Whitespace, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x1f3f64c3, L"defaultUi", XFA_Element::DefaultUi,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x204e87cb, L"dataModel", XFA_Element::DataModel, XFA_XDPPACKET_Datasets,
     XFA_ObjectType::ModelNode},
    {0x2057b350, L"barcode", XFA_Element::Barcode,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x20596bad, L"timePattern", XFA_Element::TimePattern,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::ContentNode},
    {0x210b74d3, L"batchOutput", XFA_Element::BatchOutput, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x212ff0e2, L"enforce", XFA_Element::Enforce, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x21d351b4, L"currencySymbols", XFA_Element::CurrencySymbols,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0x21db83c5, L"addSilentPrint", XFA_Element::AddSilentPrint,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x22266258, L"rename", XFA_Element::Rename, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x226ca8f1, L"operation", XFA_Element::Operation,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::TextNode},
    {0x23e27b84, L"typefaces", XFA_Element::Typefaces, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::Node},
    {0x23f4aa75, L"subjectDNs", XFA_Element::SubjectDNs,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x240d5e8e, L"issuers", XFA_Element::Issuers,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x2457a033, L"signaturePseudoModel", XFA_Element::SignaturePseudoModel,
     XFA_XDPPACKET_XDP, XFA_ObjectType::Object},
    {0x24a52f8a, L"wsdlConnection", XFA_Element::WsdlConnection,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::Node},
    {0x254ebd07, L"debug", XFA_Element::Debug, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x2655c66a, L"delta", XFA_Element::Delta, XFA_XDPPACKET_Form,
     XFA_ObjectType::Object},
    {0x26c0daec, L"eraNames", XFA_Element::EraNames, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::Node},
    {0x273ab03b, L"modifyAnnots", XFA_Element::ModifyAnnots,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x27875bb4, L"startNode", XFA_Element::StartNode, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x285d0dbc, L"button", XFA_Element::Button,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x28dee6e9, L"format", XFA_Element::Format,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x2a23349e, L"border", XFA_Element::Border,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x2ae67f19, L"area", XFA_Element::Area,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x2c3c4c67, L"hyphenation", XFA_Element::Hyphenation,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x2d08af85, L"text", XFA_Element::Text,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContentNode},
    {0x2d71b00f, L"time", XFA_Element::Time,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0x2f16a382, L"type", XFA_Element::Type, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x2fe057e9, L"overprint", XFA_Element::Overprint, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x302aee16, L"certificates", XFA_Element::Certificates,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x30b227df, L"encryptionMethods", XFA_Element::EncryptionMethods,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x32b900d1, L"setProperty", XFA_Element::SetProperty,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x337d9e45, L"printerName", XFA_Element::PrinterName, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x33edda4b, L"startPage", XFA_Element::StartPage, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x381943e4, L"pageOffset", XFA_Element::PageOffset, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x382106cd, L"dateTime", XFA_Element::DateTime,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0x386e7421, L"comb", XFA_Element::Comb,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x390acd9e, L"pattern", XFA_Element::Pattern,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x3942163e, L"ifEmpty", XFA_Element::IfEmpty, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x39944a7b, L"suppressBanner", XFA_Element::SuppressBanner,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x3b3c3dca, L"outputBin", XFA_Element::OutputBin, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x3b8a4024, L"field", XFA_Element::Field,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x3c15352f, L"agent", XFA_Element::Agent, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x3d7e8668, L"outputXSL", XFA_Element::OutputXSL, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x3e1c91c5, L"adjustData", XFA_Element::AdjustData, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x3e7a9408, L"autoSave", XFA_Element::AutoSave, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x3ecead94, L"contentArea", XFA_Element::ContentArea,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x3ef334e3, L"eventPseudoModel", XFA_Element::EventPseudoModel,
     XFA_XDPPACKET_XDP, XFA_ObjectType::Object},
    {0x3fadaec0, L"wsdlAddress", XFA_Element::WsdlAddress,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::TextNode},
    {0x40623b5b, L"solid", XFA_Element::Solid,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x41f0bd76, L"dateTimeSymbols", XFA_Element::DateTimeSymbols,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::ContentNode},
    {0x444e7523, L"encryptionLevel", XFA_Element::EncryptionLevel,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x4523af55, L"edge", XFA_Element::Edge,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x45d5e3c1, L"stipple", XFA_Element::Stipple,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x475e4e87, L"attributes", XFA_Element::Attributes, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x487a8c87, L"versionControl", XFA_Element::VersionControl,
     XFA_XDPPACKET_Config, XFA_ObjectType::Node},
    {0x48e5248c, L"meridiem", XFA_Element::Meridiem, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::ContentNode},
    {0x48f36719, L"exclGroup", XFA_Element::ExclGroup,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x4977356b, L"toolTip", XFA_Element::ToolTip,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::TextNode},
    {0x499afecc, L"compress", XFA_Element::Compress, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x4a0c4948, L"reason", XFA_Element::Reason,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::TextNode},
    {0x4bdcce13, L"execute", XFA_Element::Execute,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x4c56b216, L"contentCopy", XFA_Element::ContentCopy, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x4cc176d3, L"dateTimeEdit", XFA_Element::DateTimeEdit,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x4e1e39b6, L"config", XFA_Element::Config, XFA_XDPPACKET_Config,
     XFA_ObjectType::ModelNode},
    {0x4e2d6083, L"image", XFA_Element::Image,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0x4e814150, L"#xHTML", XFA_Element::SharpxHTML,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Config | XFA_XDPPACKET_LocaleSet |
         XFA_XDPPACKET_ConnectionSet | XFA_XDPPACKET_SourceSet |
         XFA_XDPPACKET_Form,
     XFA_ObjectType::NodeV},
    {0x4f2388c1, L"numberOfCopies", XFA_Element::NumberOfCopies,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x4f512e30, L"behaviorOverride", XFA_Element::BehaviorOverride,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x4fdc3454, L"timeStamp", XFA_Element::TimeStamp,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x51d90546, L"month", XFA_Element::Month, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::ContentNode},
    {0x523437e4, L"viewerPreferences", XFA_Element::ViewerPreferences,
     XFA_XDPPACKET_Config, XFA_ObjectType::Node},
    {0x53abc1c6, L"scriptModel", XFA_Element::ScriptModel, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x54034c2f, L"decimal", XFA_Element::Decimal,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0x54202c9e, L"subform", XFA_Element::Subform,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x542c7300, L"select", XFA_Element::Select, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::TextNode},
    {0x5436d198, L"window", XFA_Element::Window, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x5473b6dc, L"localeSet", XFA_Element::LocaleSet,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_LocaleSet, XFA_ObjectType::ModelNode},
    {0x56ae179e, L"handler", XFA_Element::Handler,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::TextNode},
    {0x5700bd5f, L"hostPseudoModel", XFA_Element::HostPseudoModel,
     XFA_XDPPACKET_XDP, XFA_ObjectType::Object},
    {0x570ce835, L"presence", XFA_Element::Presence, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x5779d65f, L"record", XFA_Element::Record, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x59c8f27d, L"embed", XFA_Element::Embed, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x5a50e9e6, L"version", XFA_Element::Version, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x5b8383df, L"command", XFA_Element::Command, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::Node},
    {0x5c43c6c3, L"copies", XFA_Element::Copies, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x5e0c2c49, L"staple", XFA_Element::Staple, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x5e5083dd, L"submitFormat", XFA_Element::SubmitFormat,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x5e8c5d20, L"boolean", XFA_Element::Boolean,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContentNode},
    {0x60490a85, L"message", XFA_Element::Message,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::Node},
    {0x60d4c8b1, L"output", XFA_Element::Output, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x61810081, L"psMap", XFA_Element::PsMap, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x62bd904b, L"excludeNS", XFA_Element::ExcludeNS, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x669d4f77, L"assist", XFA_Element::Assist,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x67334a1c, L"picture", XFA_Element::Picture,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContentNode},
    {0x67fe7334, L"traversal", XFA_Element::Traversal,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x6894589c, L"silentPrint", XFA_Element::SilentPrint, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x68a16bbd, L"webClient", XFA_Element::WebClient, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x69f115df, L"layoutPseudoModel", XFA_Element::LayoutPseudoModel,
     XFA_XDPPACKET_XDP, XFA_ObjectType::Object},
    {0x6a4bc084, L"producer", XFA_Element::Producer, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x6a9e04c9, L"corner", XFA_Element::Corner,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x6ccd7274, L"msgId", XFA_Element::MsgId, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x6e67921f, L"color", XFA_Element::Color,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x6ec217a5, L"keep", XFA_Element::Keep,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x6eef1116, L"query", XFA_Element::Query, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::Node},
    {0x7033bfd5, L"insert", XFA_Element::Insert, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::TextNode},
    {0x704af389, L"imageEdit", XFA_Element::ImageEdit,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x7233018a, L"validate", XFA_Element::Validate,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContentNode},
    {0x72ba47b4, L"digestMethods", XFA_Element::DigestMethods,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x72f2aa7a, L"numberPatterns", XFA_Element::NumberPatterns,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0x74caed29, L"pageSet", XFA_Element::PageSet,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x7568e6ae, L"integer", XFA_Element::Integer,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContentNode},
    {0x76182db9, L"soapAddress", XFA_Element::SoapAddress,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::TextNode},
    {0x773146c5, L"equate", XFA_Element::Equate, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x77d449dd, L"formFieldFilling", XFA_Element::FormFieldFilling,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x7889d68a, L"pageRange", XFA_Element::PageRange, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x7baca2e3, L"update", XFA_Element::Update, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::TextNode},
    {0x7ce89001, L"connectString", XFA_Element::ConnectString,
     XFA_XDPPACKET_SourceSet, XFA_ObjectType::TextNode},
    {0x7d9fd7c5, L"mode", XFA_Element::Mode, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x7e7e845e, L"layout", XFA_Element::Layout, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x7e845c34, L"#xml", XFA_Element::Sharpxml,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::NodeV},
    {0x7fb341df, L"xsdConnection", XFA_Element::XsdConnection,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::Node},
    {0x7ffb51cc, L"traverse", XFA_Element::Traverse,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x80203b5a, L"encodings", XFA_Element::Encodings,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x803550fc, L"template", XFA_Element::Template,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ModelNode},
    {0x803d5bbc, L"acrobat", XFA_Element::Acrobat, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0x821d6569, L"validationMessaging", XFA_Element::ValidationMessaging,
     XFA_XDPPACKET_Config, XFA_ObjectType::NodeV},
    {0x830e688f, L"signing", XFA_Element::Signing,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x83a550d2, L"dataWindow", XFA_Element::DataWindow, XFA_XDPPACKET_Datasets,
     XFA_ObjectType::Object},
    {0x83dab9f5, L"script", XFA_Element::Script,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContentNode},
    {0x8411ebcd, L"addViewerPreferences", XFA_Element::AddViewerPreferences,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x8777642e, L"alwaysEmbed", XFA_Element::AlwaysEmbed, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x877a6b39, L"passwordEdit", XFA_Element::PasswordEdit,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x87e84c99, L"numericEdit", XFA_Element::NumericEdit,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x8852cdec, L"encryptionMethod", XFA_Element::EncryptionMethod,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::NodeC},
    {0x891f4606, L"change", XFA_Element::Change, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x89939f36, L"pageArea", XFA_Element::PageArea,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0x8a9d6247, L"submitUrl", XFA_Element::SubmitUrl, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0x8ad8b90f, L"oids", XFA_Element::Oids,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x8b036f32, L"signature", XFA_Element::Signature,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x8b128efb, L"ADBE_JSConsole", XFA_Element::ADBE_JSConsole,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0x8bcfe96e, L"caption", XFA_Element::Caption,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x8e1c2921, L"relevant", XFA_Element::Relevant, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x8e3f0a4b, L"flipLabel", XFA_Element::FlipLabel, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0x900280b7, L"exData", XFA_Element::ExData,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0x91e80352, L"dayNames", XFA_Element::DayNames, XFA_XDPPACKET_LocaleSet,
     XFA_ObjectType::Node},
    {0x93113b11, L"soapAction", XFA_Element::SoapAction,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::TextNode},
    {0x938b09f6, L"defaultTypeface", XFA_Element::DefaultTypeface,
     XFA_XDPPACKET_Config, XFA_ObjectType::NodeV},
    {0x95b37897, L"manifest", XFA_Element::Manifest,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x97b76b54, L"overflow", XFA_Element::Overflow,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x9a57861b, L"linear", XFA_Element::Linear,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0x9ad5a821, L"currencySymbol", XFA_Element::CurrencySymbol,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::ContentNode},
    {0x9c6471b3, L"delete", XFA_Element::Delete, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::TextNode},
    {0x9deea61d, L"deltas", XFA_Element::Deltas, XFA_XDPPACKET_Form,
     XFA_ObjectType::Object},
    {0x9e67de21, L"digestMethod", XFA_Element::DigestMethod,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::NodeC},
    {0x9f3e9510, L"instanceManager", XFA_Element::InstanceManager,
     XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xa0799892, L"equateRange", XFA_Element::EquateRange, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xa084a381, L"medium", XFA_Element::Medium,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xa1211b8b, L"textEdit", XFA_Element::TextEdit,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xa17008f0, L"templateCache", XFA_Element::TemplateCache,
     XFA_XDPPACKET_Config, XFA_ObjectType::Node},
    {0xa4f7b88f, L"compressObjectStream", XFA_Element::CompressObjectStream,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xa65f5d17, L"dataValue", XFA_Element::DataValue, XFA_XDPPACKET_Datasets,
     XFA_ObjectType::Node},
    {0xa6caaa89, L"accessibleContent", XFA_Element::AccessibleContent,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xa8c7d5e2, L"nodeList", XFA_Element::NodeList, XFA_XDPPACKET_XDP,
     XFA_ObjectType::NodeList},
    {0xa94cc00b, L"includeXDPContent", XFA_Element::IncludeXDPContent,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xa9b081a1, L"xmlConnection", XFA_Element::XmlConnection,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::Node},
    {0xab2a3b74, L"validateApprovalSignatures",
     XFA_Element::ValidateApprovalSignatures, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xab8c5a2b, L"signData", XFA_Element::SignData,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xabaa2ceb, L"packets", XFA_Element::Packets, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xadba359c, L"datePattern", XFA_Element::DatePattern,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::ContentNode},
    {0xae222b2b, L"duplexOption", XFA_Element::DuplexOption,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xb012effb, L"base", XFA_Element::Base, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xb0e5485d, L"bind", XFA_Element::Bind,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::Node},
    {0xb45d61b2, L"compression", XFA_Element::Compression, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xb563f0ff, L"user", XFA_Element::User, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::TextNode},
    {0xb5848ad5, L"rectangle", XFA_Element::Rectangle,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xb6dacb72, L"effectiveOutputPolicy", XFA_Element::EffectiveOutputPolicy,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::Node},
    {0xb7d7654d, L"ADBE_JSDebugger", XFA_Element::ADBE_JSDebugger,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xbab37f73, L"acrobat7", XFA_Element::Acrobat7, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xbc70081e, L"interactive", XFA_Element::Interactive, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xbc8fa350, L"locale", XFA_Element::Locale,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0xbcd44940, L"currentPage", XFA_Element::CurrentPage, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xbde9abda, L"data", XFA_Element::Data, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xbde9abde, L"date", XFA_Element::Date,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0xbe52dfbf, L"desc", XFA_Element::Desc,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xbf4b6405, L"encrypt", XFA_Element::Encrypt,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Config | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContentNode},
    {0xbfa87cce, L"draw", XFA_Element::Draw,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0xc181ff4b, L"encryption", XFA_Element::Encryption, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xc1970f40, L"meridiemNames", XFA_Element::MeridiemNames,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0xc5ad9f5e, L"messaging", XFA_Element::Messaging, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xc69549f4, L"speak", XFA_Element::Speak,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::TextNode},
    {0xc7743dc7, L"dataGroup", XFA_Element::DataGroup, XFA_XDPPACKET_Datasets,
     XFA_ObjectType::Node},
    {0xc7eb20e9, L"common", XFA_Element::Common, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xc85d4528, L"#text", XFA_Element::Sharptext,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Config | XFA_XDPPACKET_LocaleSet |
         XFA_XDPPACKET_ConnectionSet | XFA_XDPPACKET_SourceSet |
         XFA_XDPPACKET_Form,
     XFA_ObjectType::NodeV},
    {0xc861556a, L"paginationOverride", XFA_Element::PaginationOverride,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xc903dabb, L"reasons", XFA_Element::Reasons,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xc9a8127f, L"signatureProperties", XFA_Element::SignatureProperties,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xca010c2d, L"threshold", XFA_Element::Threshold, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xcb4c5e96, L"appearanceFilter", XFA_Element::AppearanceFilter,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::NodeC},
    {0xcc92aba7, L"fill", XFA_Element::Fill,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xcd308b77, L"font", XFA_Element::Font,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Config | XFA_XDPPACKET_Form,
     XFA_ObjectType::Node},
    {0xcd309ff4, L"form", XFA_Element::Form, XFA_XDPPACKET_Form,
     XFA_ObjectType::ModelNode},
    {0xcebcca2d, L"mediumInfo", XFA_Element::MediumInfo, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xcfe0d643, L"certificate", XFA_Element::Certificate,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::TextNode},
    {0xd012c033, L"password", XFA_Element::Password, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::TextNode},
    {0xd01604bd, L"runScripts", XFA_Element::RunScripts, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xd1227e6f, L"trace", XFA_Element::Trace, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xd1532876, L"float", XFA_Element::Float,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0xd17a6c30, L"renderPolicy", XFA_Element::RenderPolicy,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xd4bf6823, L"logPseudoModel", XFA_Element::LogPseudoModel,
     XFA_XDPPACKET_XDP, XFA_ObjectType::Object},
    {0xd58aa962, L"destination", XFA_Element::Destination, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xd6e27f1d, L"value", XFA_Element::Value,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xd7a14462, L"bookend", XFA_Element::Bookend,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xd8c31254, L"exObject", XFA_Element::ExObject,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xda6a8590, L"openAction", XFA_Element::OpenAction, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xdab4fb7d, L"neverEmbed", XFA_Element::NeverEmbed, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xdb98475f, L"bindItems", XFA_Element::BindItems,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xdbfbe02e, L"calculate", XFA_Element::Calculate,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xdd7676ed, L"print", XFA_Element::Print, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xdde273d7, L"extras", XFA_Element::Extras,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::Node},
    {0xde146b34, L"proto", XFA_Element::Proto,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xdf059321, L"dSigData", XFA_Element::DSigData,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xdfccf030, L"creator", XFA_Element::Creator, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xdff78c6a, L"connect", XFA_Element::Connect,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::Node},
    {0xe11a2cbc, L"permissions", XFA_Element::Permissions, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xe14c801c, L"connectionSet", XFA_Element::ConnectionSet,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::ModelNode},
    {0xe1c83a14, L"submit", XFA_Element::Submit,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xe29821cd, L"range", XFA_Element::Range, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xe38d83c7, L"linearized", XFA_Element::Linearized, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xe3aa2578, L"packet", XFA_Element::Packet, XFA_XDPPACKET_XDP,
     XFA_ObjectType::NodeC},
    {0xe3aa860e, L"rootElement", XFA_Element::RootElement,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::TextNode},
    {0xe3e553fa, L"plaintextMetadata", XFA_Element::PlaintextMetadata,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xe3e6e4f2, L"numberSymbols", XFA_Element::NumberSymbols,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0xe3f067f6, L"printHighQuality", XFA_Element::PrintHighQuality,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xe3fd078c, L"driver", XFA_Element::Driver, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xe48b34f2, L"incrementalLoad", XFA_Element::IncrementalLoad,
     XFA_XDPPACKET_Config, XFA_ObjectType::NodeV},
    {0xe550e7c2, L"subjectDN", XFA_Element::SubjectDN,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::NodeC},
    {0xe6669a78, L"compressLogicalStructure",
     XFA_Element::CompressLogicalStructure, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xe7a7ea02, L"incrementalMerge", XFA_Element::IncrementalMerge,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xe948530d, L"radial", XFA_Element::Radial,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xea8d6999, L"variables", XFA_Element::Variables,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     XFA_ObjectType::ContainerNode},
    {0xeaa142c0, L"timePatterns", XFA_Element::TimePatterns,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0xeb943a71, L"effectiveInputPolicy", XFA_Element::EffectiveInputPolicy,
     XFA_XDPPACKET_ConnectionSet, XFA_ObjectType::Node},
    {0xef04a2bc, L"nameAttr", XFA_Element::NameAttr, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xf07222ab, L"conformance", XFA_Element::Conformance, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xf0aaaadc, L"transform", XFA_Element::Transform, XFA_XDPPACKET_Config,
     XFA_ObjectType::Node},
    {0xf1433e88, L"lockDocument", XFA_Element::LockDocument,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::ContentNode},
    {0xf54eb997, L"breakAfter", XFA_Element::BreakAfter,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xf616da28, L"line", XFA_Element::Line,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xf616f3dc, L"list", XFA_Element::List, XFA_XDPPACKET_XDP,
     XFA_ObjectType::List},
    {0xf7055fb1, L"source", XFA_Element::Source, XFA_XDPPACKET_SourceSet,
     XFA_ObjectType::Node},
    {0xf7eebe1c, L"occur", XFA_Element::Occur,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
    {0xf8d10d97, L"pickTrayByPDFSize", XFA_Element::PickTrayByPDFSize,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xf8f19e3a, L"monthNames", XFA_Element::MonthNames,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::Node},
    {0xf984149b, L"severity", XFA_Element::Severity, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xf9bcb037, L"groupParent", XFA_Element::GroupParent, XFA_XDPPACKET_Config,
     XFA_ObjectType::NodeV},
    {0xfbc42fff, L"documentAssembly", XFA_Element::DocumentAssembly,
     XFA_XDPPACKET_Config, XFA_ObjectType::ContentNode},
    {0xfc78159f, L"numberSymbol", XFA_Element::NumberSymbol,
     XFA_XDPPACKET_LocaleSet, XFA_ObjectType::ContentNode},
    {0xfcbd606c, L"tagged", XFA_Element::Tagged, XFA_XDPPACKET_Config,
     XFA_ObjectType::ContentNode},
    {0xff063802, L"items", XFA_Element::Items,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, XFA_ObjectType::Node},
};
const int32_t g_iXFAElementCount = FX_ArraySize(g_XFAElementData);
static_assert(g_iXFAElementCount ==
                  (static_cast<int32_t>(XFA_Element::Items) + 1),
              "g_XFAElementData size does not match XFA_Elements");

const XFA_ELEMENTHIERARCHY g_XFAElementPropertyIndex[] = {
    {0, 8},    {8, 0},   {8, 14},   {22, 0},   {22, 0},   {22, 6},   {28, 0},
    {28, 0},   {28, 1},  {29, 3},   {32, 0},   {32, 0},   {32, 0},   {32, 3},
    {35, 1},   {36, 0},  {36, 0},   {36, 2},   {38, 0},   {38, 0},   {38, 0},
    {38, 4},   {42, 0},  {42, 0},   {42, 1},   {43, 0},   {43, 8},   {51, 19},
    {70, 0},   {70, 0},  {70, 2},   {72, 1},   {73, 0},   {73, 2},   {75, 4},
    {79, 1},   {80, 1},  {81, 0},   {81, 0},   {81, 3},   {84, 0},   {84, 4},
    {88, 4},   {92, 1},  {93, 0},   {93, 4},   {97, 9},   {106, 14}, {120, 0},
    {120, 0},  {120, 5}, {125, 0},  {125, 1},  {126, 0},  {126, 0},  {126, 0},
    {126, 0},  {126, 0}, {126, 1},  {127, 0},  {127, 0},  {127, 0},  {127, 0},
    {127, 0},  {127, 0}, {127, 0},  {127, 6},  {133, 1},  {134, 0},  {134, 1},
    {135, 0},  {135, 0}, {135, 1},  {136, 2},  {138, 5},  {143, 2},  {145, 0},
    {145, 0},  {145, 0}, {145, 0},  {145, 0},  {145, 5},  {150, 0},  {150, 0},
    {150, 0},  {150, 0}, {150, 0},  {150, 0},  {150, 0},  {150, 2},  {152, 0},
    {152, 0},  {152, 0}, {152, 17}, {169, 0},  {169, 1},  {170, 0},  {170, 0},
    {170, 2},  {172, 0}, {172, 0},  {172, 1},  {173, 0},  {173, 0},  {173, 2},
    {175, 2},  {177, 0}, {177, 0},  {177, 0},  {177, 11}, {188, 0},  {188, 0},
    {188, 0},  {188, 0}, {188, 0},  {188, 4},  {192, 3},  {195, 0},  {195, 0},
    {195, 0},  {195, 0}, {195, 0},  {195, 0},  {195, 9},  {204, 0},  {204, 0},
    {204, 17}, {221, 0}, {221, 0},  {221, 0},  {221, 0},  {221, 0},  {221, 0},
    {221, 0},  {221, 0}, {221, 0},  {221, 4},  {225, 0},  {225, 0},  {225, 0},
    {225, 0},  {225, 2}, {227, 3},  {230, 0},  {230, 0},  {230, 2},  {232, 0},
    {232, 1},  {233, 2}, {235, 2},  {237, 0},  {237, 0},  {237, 2},  {239, 0},
    {239, 1},  {240, 1}, {241, 2},  {243, 0},  {243, 3},  {246, 4},  {250, 0},
    {250, 1},  {251, 2}, {253, 0},  {253, 0},  {253, 0},  {253, 0},  {253, 0},
    {253, 0},  {253, 0}, {253, 0},  {253, 0},  {253, 0},  {253, 2},  {255, 2},
    {257, 0},  {257, 6}, {263, 5},  {268, 0},  {268, 0},  {268, 0},  {268, 3},
    {271, 0},  {271, 0}, {271, 3},  {274, 4},  {278, 0},  {278, 0},  {278, 4},
    {282, 0},  {282, 0}, {282, 5},  {287, 0},  {287, 5},  {292, 0},  {292, 0},
    {292, 0},  {292, 1}, {293, 0},  {293, 0},  {293, 1},  {294, 0},  {294, 2},
    {296, 0},  {296, 0}, {296, 0},  {296, 0},  {296, 1},  {297, 0},  {297, 0},
    {297, 4},  {301, 0}, {301, 0},  {301, 0},  {301, 0},  {301, 0},  {301, 0},
    {301, 1},  {302, 0}, {302, 2},  {304, 0},  {304, 0},  {304, 0},  {304, 0},
    {304, 1},  {305, 4}, {309, 0},  {309, 3},  {312, 0},  {312, 0},  {312, 1},
    {313, 0},  {313, 8}, {321, 0},  {321, 10}, {331, 0},  {331, 10}, {341, 1},
    {342, 12}, {354, 3}, {357, 1},  {358, 0},  {358, 0},  {358, 0},  {358, 8},
    {366, 0},  {366, 0}, {366, 0},  {366, 0},  {366, 0},  {366, 0},  {366, 7},
    {373, 2},  {375, 0}, {375, 1},  {376, 0},  {376, 0},  {376, 0},  {376, 0},
    {376, 0},  {376, 0}, {376, 0},  {376, 0},  {376, 13}, {389, 0},  {389, 1},
    {390, 1},  {391, 0}, {391, 0},  {391, 3},  {394, 0},  {394, 0},  {394, 0},
    {394, 0},  {394, 0}, {394, 4},  {398, 9},  {407, 0},  {407, 1},  {408, 0},
    {408, 0},  {408, 0}, {408, 0},  {408, 0},  {408, 1},  {409, 0},  {409, 2},
    {411, 0},  {411, 0}, {411, 0},  {411, 0},  {411, 2},  {413, 0},  {413, 1},
    {414, 0},  {414, 0}, {414, 0},  {414, 7},  {421, 0},  {421, 1},  {422, 1},
    {423, 0},  {423, 1}, {424, 1},  {425, 0},  {425, 1},  {426, 0},  {426, 0},
    {426, 0},  {426, 0}, {426, 0},  {426, 0},
};

const XFA_PROPERTY g_XFAElementPropertyData[] = {
    {XFA_Element::FontInfo, 1, 0},
    {XFA_Element::Jog, 1, 0},
    {XFA_Element::Xdc, 1, 0},
    {XFA_Element::BatchOutput, 1, 0},
    {XFA_Element::OutputBin, 1, 0},
    {XFA_Element::Compress, 1, 0},
    {XFA_Element::Staple, 1, 0},
    {XFA_Element::MediumInfo, 1, 0},
    {XFA_Element::CheckButton, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::ChoiceList, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::DefaultUi, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Barcode, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Button, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::DateTimeEdit, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Picture, 1, 0},
    {XFA_Element::ImageEdit, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::PasswordEdit, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::NumericEdit, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Signature, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::TextEdit, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::ExObject, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Break, 1, 0},
    {XFA_Element::Overflow, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Bookend, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Occur, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::SubsetBelow, 1, 0},
    {XFA_Element::Map, 1, 0},
    {XFA_Element::Embed, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::DatePattern, 4, 0},
    {XFA_Element::Edge, 1, 0},
    {XFA_Element::Fill, 1, 0},
    {XFA_Element::To, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Mode, 1, 0},
    {XFA_Element::Threshold, 1, 0},
    {XFA_Element::Script, 1, 0},
    {XFA_Element::FontInfo, 1, 0},
    {XFA_Element::Jog, 1, 0},
    {XFA_Element::Xdc, 1, 0},
    {XFA_Element::BatchOutput, 1, 0},
    {XFA_Element::PageOffset, 1, 0},
    {XFA_Element::OutputBin, 1, 0},
    {XFA_Element::Staple, 1, 0},
    {XFA_Element::MediumInfo, 1, 0},
    {XFA_Element::AdobeExtensionLevel, 1, 0},
    {XFA_Element::FontInfo, 1, 0},
    {XFA_Element::Xdc, 1, 0},
    {XFA_Element::Pdfa, 1, 0},
    {XFA_Element::BatchOutput, 1, 0},
    {XFA_Element::ViewerPreferences, 1, 0},
    {XFA_Element::ScriptModel, 1, 0},
    {XFA_Element::Version, 1, 0},
    {XFA_Element::SubmitFormat, 1, 0},
    {XFA_Element::SilentPrint, 1, 0},
    {XFA_Element::Producer, 1, 0},
    {XFA_Element::Compression, 1, 0},
    {XFA_Element::Interactive, 1, 0},
    {XFA_Element::Encryption, 1, 0},
    {XFA_Element::RenderPolicy, 1, 0},
    {XFA_Element::OpenAction, 1, 0},
    {XFA_Element::Creator, 1, 0},
    {XFA_Element::Linearized, 1, 0},
    {XFA_Element::Tagged, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Xsl, 1, 0},
    {XFA_Element::Packets, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Debug, 1, 0},
    {XFA_Element::FontInfo, 1, 0},
    {XFA_Element::Xdc, 1, 0},
    {XFA_Element::BatchOutput, 1, 0},
    {XFA_Element::FlipLabel, 1, 0},
    {XFA_Element::TemplateCache, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::FontInfo, 1, 0},
    {XFA_Element::Xdc, 1, 0},
    {XFA_Element::BatchOutput, 1, 0},
    {XFA_Element::FlipLabel, 1, 0},
    {XFA_Element::EraNames, 1, 0},
    {XFA_Element::DayNames, 2, 0},
    {XFA_Element::MeridiemNames, 1, 0},
    {XFA_Element::MonthNames, 2, 0},
    {XFA_Element::Hyphenation, 1, 0},
    {XFA_Element::Amd, 1, 0},
    {XFA_Element::Part, 1, 0},
    {XFA_Element::IncludeXDPContent, 1, 0},
    {XFA_Element::Conformance, 1, 0},
    {XFA_Element::Mdp, 1, 0},
    {XFA_Element::Certificates, 1, 0},
    {XFA_Element::TimeStamp, 1, 0},
    {XFA_Element::Handler, 1, 0},
    {XFA_Element::DigestMethods, 1, 0},
    {XFA_Element::Encodings, 1, 0},
    {XFA_Element::Reasons, 1, 0},
    {XFA_Element::AppearanceFilter, 1, 0},
    {XFA_Element::LockDocument, 1, 0},
    {XFA_Element::Xdp, 1, 0},
    {XFA_Element::Cache, 1, 0},
    {XFA_Element::Pagination, 1, 0},
    {XFA_Element::Overprint, 1, 0},
    {XFA_Element::BehaviorOverride, 1, 0},
    {XFA_Element::Copies, 1, 0},
    {XFA_Element::Output, 1, 0},
    {XFA_Element::Validate, 1, 0},
    {XFA_Element::Layout, 1, 0},
    {XFA_Element::Script, 1, 0},
    {XFA_Element::Common, 1, 0},
    {XFA_Element::PaginationOverride, 1, 0},
    {XFA_Element::Destination, 1, 0},
    {XFA_Element::IncrementalMerge, 1, 0},
    {XFA_Element::Execute, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Script, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::SignData, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Submit, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::CurrencySymbol, 3, 0},
    {XFA_Element::Operation, 1, 0},
    {XFA_Element::WsdlAddress, 1, 0},
    {XFA_Element::SoapAddress, 1, 0},
    {XFA_Element::SoapAction, 1, 0},
    {XFA_Element::EffectiveOutputPolicy, 1, 0},
    {XFA_Element::EffectiveInputPolicy, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Era, 2, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Picture, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Edge, 4, 0},
    {XFA_Element::Corner, 4, 0},
    {XFA_Element::Fill, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::KeyUsage, 1, 0},
    {XFA_Element::SubjectDNs, 1, 0},
    {XFA_Element::Issuers, 1, 0},
    {XFA_Element::Signing, 1, 0},
    {XFA_Element::Oids, 1, 0},
    {XFA_Element::Color, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Ui, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Para, 1, 0},
    {XFA_Element::Format, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Assist, 1, 0},
    {XFA_Element::Traversal, 1, 0},
    {XFA_Element::Keep, 1, 0},
    {XFA_Element::Validate, 1, 0},
    {XFA_Element::Caption, 1, 0},
    {XFA_Element::Bind, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Font, 1, 0},
    {XFA_Element::Value, 1, 0},
    {XFA_Element::Calculate, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Items, 2, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Color, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Color, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Para, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Assist, 1, 0},
    {XFA_Element::Traversal, 1, 0},
    {XFA_Element::Validate, 1, 0},
    {XFA_Element::Caption, 1, 0},
    {XFA_Element::Bind, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Calculate, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Comb, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Present, 1, 0},
    {XFA_Element::Acrobat, 1, 0},
    {XFA_Element::Trace, 1, 0},
    {XFA_Element::PrintScaling, 1, 0},
    {XFA_Element::Enforce, 1, 0},
    {XFA_Element::NumberOfCopies, 1, 0},
    {XFA_Element::PageRange, 1, 0},
    {XFA_Element::AddViewerPreferences, 1, 0},
    {XFA_Element::ADBE_JSConsole, 1, 0},
    {XFA_Element::DuplexOption, 1, 0},
    {XFA_Element::ADBE_JSDebugger, 1, 0},
    {XFA_Element::PickTrayByPDFSize, 1, 0},
    {XFA_Element::Break, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Para, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Assist, 1, 0},
    {XFA_Element::Traversal, 1, 0},
    {XFA_Element::Keep, 1, 0},
    {XFA_Element::Validate, 1, 0},
    {XFA_Element::PageSet, 1, 0},
    {XFA_Element::Overflow, 1, 0},
    {XFA_Element::Bind, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Bookend, 1, 0},
    {XFA_Element::Calculate, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Variables, 1, 0},
    {XFA_Element::Occur, 1, 0},
    {XFA_Element::Query, 1, 0},
    {XFA_Element::Insert, 1, 0},
    {XFA_Element::Update, 1, 0},
    {XFA_Element::Delete, 1, 0},
    {XFA_Element::MsgId, 1, 0},
    {XFA_Element::Severity, 1, 0},
    {XFA_Element::To, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Type, 1, 0},
    {XFA_Element::ToolTip, 1, 0},
    {XFA_Element::Speak, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::AddSilentPrint, 1, 0},
    {XFA_Element::PrinterName, 1, 0},
    {XFA_Element::FontInfo, 1, 0},
    {XFA_Element::Xdc, 1, 0},
    {XFA_Element::Color, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::RecordSet, 1, 0},
    {XFA_Element::Select, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Message, 1, 0},
    {XFA_Element::Picture, 1, 0},
    {XFA_Element::Script, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::NumberPattern, 4, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Occur, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::RootElement, 1, 0},
    {XFA_Element::Script, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Xsl, 1, 0},
    {XFA_Element::StartPage, 1, 0},
    {XFA_Element::Relevant, 1, 0},
    {XFA_Element::Base, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::AutoSave, 1, 0},
    {XFA_Element::Validate, 1, 0},
    {XFA_Element::ValidateApprovalSignatures, 1, 0},
    {XFA_Element::Acrobat7, 1, 0},
    {XFA_Element::Common, 1, 0},
    {XFA_Element::Exclude, 1, 0},
    {XFA_Element::CurrentPage, 1, 0},
    {XFA_Element::RunScripts, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Comb, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Medium, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Occur, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Filter, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Manifest, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Para, 1, 0},
    {XFA_Element::Font, 1, 0},
    {XFA_Element::Value, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Day, 7, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Color, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Occur, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Comb, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Filter, 1, 0},
    {XFA_Element::Manifest, 1, 0},
    {XFA_Element::Picture, 1, 0},
    {XFA_Element::Level, 1, 0},
    {XFA_Element::Type, 1, 0},
    {XFA_Element::CompressObjectStream, 1, 0},
    {XFA_Element::CompressLogicalStructure, 1, 0},
    {XFA_Element::Edge, 4, 0},
    {XFA_Element::Corner, 4, 0},
    {XFA_Element::Fill, 1, 0},
    {XFA_Element::DynamicRender, 1, 0},
    {XFA_Element::DatePatterns, 1, 0},
    {XFA_Element::CalendarSymbols, 1, 0},
    {XFA_Element::CurrencySymbols, 1, 0},
    {XFA_Element::Typefaces, 1, 0},
    {XFA_Element::DateTimeSymbols, 1, 0},
    {XFA_Element::NumberPatterns, 1, 0},
    {XFA_Element::NumberSymbols, 1, 0},
    {XFA_Element::TimePatterns, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Xsl, 1, 0},
    {XFA_Element::StartNode, 1, 0},
    {XFA_Element::OutputXSL, 1, 0},
    {XFA_Element::AdjustData, 1, 0},
    {XFA_Element::Attributes, 1, 0},
    {XFA_Element::Window, 1, 0},
    {XFA_Element::Record, 1, 0},
    {XFA_Element::Range, 1, 0},
    {XFA_Element::IncrementalLoad, 1, 0},
    {XFA_Element::Text, 1, 0},
    {XFA_Element::Time, 1, 0},
    {XFA_Element::DateTime, 1, 0},
    {XFA_Element::Image, 1, 0},
    {XFA_Element::Decimal, 1, 0},
    {XFA_Element::Boolean, 1, 0},
    {XFA_Element::Integer, 1, 0},
    {XFA_Element::ExData, 1, 0},
    {XFA_Element::Date, 1, 0},
    {XFA_Element::Float, 1, 0},
    {XFA_Element::Certificate, 1, 0},
    {XFA_Element::Ui, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Para, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Assist, 1, 0},
    {XFA_Element::Traversal, 1, 0},
    {XFA_Element::Keep, 1, 0},
    {XFA_Element::Caption, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Font, 1, 0},
    {XFA_Element::Value, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::EncryptionLevel, 1, 0},
    {XFA_Element::Encrypt, 1, 0},
    {XFA_Element::Permissions, 1, 0},
    {XFA_Element::Meridiem, 2, 0},
    {XFA_Element::SuppressBanner, 1, 0},
    {XFA_Element::VersionControl, 1, 0},
    {XFA_Element::LocaleSet, 1, 0},
    {XFA_Element::Template, 1, 0},
    {XFA_Element::ValidationMessaging, 1, 0},
    {XFA_Element::Locale, 1, 0},
    {XFA_Element::Data, 1, 0},
    {XFA_Element::Messaging, 1, 0},
    {XFA_Element::Pattern, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Solid, 1,
     XFA_PROPERTYFLAG_OneOf | XFA_PROPERTYFLAG_DefaultOneOf},
    {XFA_Element::Stipple, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Color, 1, 0},
    {XFA_Element::Linear, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Radial, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Fill, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Map, 1, 0},
    {XFA_Element::Arc, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Text, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Time, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::DateTime, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Image, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Decimal, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Boolean, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Integer, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::ExData, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Rectangle, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Date, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Float, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Line, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Destination, 1, 0},
    {XFA_Element::Message, 1, 0},
    {XFA_Element::Script, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Picture, 1, 0},
    {XFA_Element::ConnectString, 1, 0},
    {XFA_Element::User, 1, 0},
    {XFA_Element::Password, 1, 0},
    {XFA_Element::ModifyAnnots, 1, 0},
    {XFA_Element::ContentCopy, 1, 0},
    {XFA_Element::FormFieldFilling, 1, 0},
    {XFA_Element::Change, 1, 0},
    {XFA_Element::AccessibleContent, 1, 0},
    {XFA_Element::Print, 1, 0},
    {XFA_Element::PlaintextMetadata, 1, 0},
    {XFA_Element::PrintHighQuality, 1, 0},
    {XFA_Element::DocumentAssembly, 1, 0},
    {XFA_Element::Encrypt, 1, 0},
    {XFA_Element::NumberSymbol, 5, 0},
    {XFA_Element::FontInfo, 1, 0},
    {XFA_Element::Xdc, 1, 0},
    {XFA_Element::Color, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::TimePattern, 4, 0},
    {XFA_Element::Whitespace, 1, 0},
    {XFA_Element::Rename, 1, 0},
    {XFA_Element::IfEmpty, 1, 0},
    {XFA_Element::Presence, 1, 0},
    {XFA_Element::Picture, 1, 0},
    {XFA_Element::NameAttr, 1, 0},
    {XFA_Element::GroupParent, 1, 0},
    {XFA_Element::Script, 1, 0},
    {XFA_Element::Edge, 1, 0},
    {XFA_Element::Connect, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Month, 12, 0},
};

const XFA_ELEMENTHIERARCHY g_XFAElementAttributeIndex[] = {
    {0, 3},    {3, 2},    {5, 3},    {8, 10},   {18, 2},   {20, 6},   {26, 2},
    {28, 1},   {29, 13},  {42, 2},   {44, 1},   {45, 2},   {47, 2},   {49, 7},
    {56, 0},   {56, 4},   {60, 2},   {62, 7},   {69, 0},   {69, 0},   {69, 2},
    {71, 2},   {73, 8},   {81, 5},   {86, 8},   {94, 4},   {98, 3},   {101, 3},
    {104, 3},  {107, 6},  {113, 2},  {115, 2},  {117, 2},  {119, 2},  {121, 3},
    {124, 2},  {126, 7},  {133, 13}, {146, 2},  {148, 6},  {154, 2},  {156, 3},
    {159, 1},  {160, 17}, {177, 2},  {179, 2},  {181, 6},  {187, 2},  {189, 2},
    {191, 3},  {194, 7},  {201, 2},  {203, 3},  {206, 0},  {206, 21}, {227, 1},
    {228, 3},  {231, 2},  {233, 0},  {233, 2},  {235, 2},  {237, 6},  {243, 0},
    {243, 4},  {247, 4},  {251, 0},  {251, 2},  {253, 2},  {255, 0},  {255, 0},
    {255, 2},  {257, 2},  {259, 4},  {263, 3},  {266, 7},  {273, 10}, {283, 9},
    {292, 6},  {298, 4},  {302, 2},  {304, 2},  {306, 6},  {312, 4},  {316, 3},
    {319, 2},  {321, 2},  {323, 4},  {327, 4},  {331, 4},  {335, 4},  {339, 2},
    {341, 2},  {343, 2},  {345, 22}, {367, 3},  {370, 2},  {372, 2},  {374, 2},
    {376, 9},  {385, 0},  {385, 4},  {389, 3},  {392, 0},  {392, 2},  {394, 7},
    {401, 4},  {405, 2},  {407, 4},  {411, 0},  {411, 21}, {432, 4},  {436, 3},
    {439, 4},  {443, 6},  {449, 2},  {451, 5},  {456, 2},  {458, 8},  {466, 1},
    {467, 2},  {469, 2},  {471, 5},  {476, 0},  {476, 2},  {478, 2},  {480, 6},
    {486, 26}, {512, 4},  {516, 2},  {518, 2},  {520, 4},  {524, 0},  {524, 2},
    {526, 2},  {528, 2},  {530, 2},  {532, 5},  {537, 2},  {539, 3},  {542, 2},
    {544, 4},  {548, 5},  {553, 2},  {555, 0},  {555, 2},  {557, 4},  {561, 5},
    {566, 3},  {569, 2},  {571, 3},  {574, 0},  {574, 2},  {576, 9},  {585, 2},
    {587, 5},  {592, 6},  {598, 5},  {603, 4},  {607, 4},  {611, 8},  {619, 4},
    {623, 0},  {623, 7},  {630, 4},  {634, 4},  {638, 5},  {643, 2},  {645, 2},
    {647, 4},  {651, 4},  {655, 2},  {657, 2},  {659, 1},  {660, 2},  {662, 5},
    {667, 4},  {671, 3},  {674, 2},  {676, 2},  {678, 4},  {682, 0},  {682, 9},
    {691, 2},  {693, 2},  {695, 5},  {700, 4},  {704, 3},  {707, 2},  {709, 10},
    {719, 2},  {721, 4},  {725, 4},  {729, 2},  {731, 6},  {737, 2},  {739, 2},
    {741, 9},  {750, 1},  {751, 4},  {755, 3},  {758, 5},  {763, 6},  {769, 4},
    {773, 1},  {774, 4},  {778, 0},  {778, 3},  {781, 1},  {782, 5},  {787, 10},
    {797, 7},  {804, 3},  {807, 2},  {809, 5},  {814, 2},  {816, 0},  {816, 2},
    {818, 2},  {820, 2},  {822, 6},  {828, 2},  {830, 1},  {831, 2},  {833, 2},
    {835, 8},  {843, 2},  {845, 4},  {849, 4},  {853, 4},  {857, 2},  {859, 2},
    {861, 2},  {863, 3},  {866, 2},  {868, 2},  {870, 4},  {874, 3},  {877, 5},
    {882, 20}, {902, 2},  {904, 0},  {904, 2},  {906, 6},  {912, 1},  {913, 2},
    {915, 1},  {916, 2},  {918, 4},  {922, 2},  {924, 2},  {926, 4},  {930, 4},
    {934, 20}, {954, 1},  {955, 2},  {957, 4},  {961, 4},  {965, 2},  {967, 2},
    {969, 4},  {973, 2},  {975, 0},  {975, 2},  {977, 5},  {982, 5},  {987, 8},
    {995, 2},  {997, 2},  {999, 4},  {1003, 4}, {1007, 2}, {1009, 4}, {1013, 0},
    {1013, 1}, {1014, 2}, {1016, 9}, {1025, 2}, {1027, 0}, {1027, 8}, {1035, 2},
    {1037, 2}, {1039, 0}, {1039, 4}, {1043, 2}, {1045, 0}, {1045, 2}, {1047, 3},
    {1050, 2}, {1052, 5}, {1057, 2}, {1059, 2}, {1061, 4}, {1065, 3}, {1068, 0},
    {1068, 4}, {1072, 2}, {1074, 2}, {1076, 3}, {1079, 4}, {1083, 8}, {1091, 5},
    {1096, 0}, {1096, 4}, {1100, 6}, {1106, 2}, {1108, 1}, {1109, 2}, {1111, 2},
    {1113, 2}, {1115, 1}, {1116, 2}, {1118, 7},
};
static_assert(FX_ArraySize(g_XFAElementAttributeIndex) ==
                  (static_cast<int32_t>(XFA_Element::Items) + 1),
              "gXFAElementAttributeIndex size does not match XFA_Element");

const uint8_t g_XFAElementAttributeData[] = {
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Max,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_EofAction,
    XFA_ATTRIBUTE_CursorType,
    XFA_ATTRIBUTE_LockType,
    XFA_ATTRIBUTE_BofAction,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_CursorLocation,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Relation,
    XFA_ATTRIBUTE_Relevant,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_BeforeTarget,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_OverflowTarget,
    XFA_ATTRIBUTE_OverflowLeader,
    XFA_ATTRIBUTE_OverflowTrailer,
    XFA_ATTRIBUTE_StartNew,
    XFA_ATTRIBUTE_BookendTrailer,
    XFA_ATTRIBUTE_After,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_BookendLeader,
    XFA_ATTRIBUTE_AfterTarget,
    XFA_ATTRIBUTE_Before,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_AllowNeutral,
    XFA_ATTRIBUTE_Mark,
    XFA_ATTRIBUTE_Shape,
    XFA_ATTRIBUTE_Size,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_StartAngle,
    XFA_ATTRIBUTE_SweepAngle,
    XFA_ATTRIBUTE_Circular,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Hand,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Bind,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_From,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_SignatureType,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Permissions,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_StartNew,
    XFA_ATTRIBUTE_Trailer,
    XFA_ATTRIBUTE_TargetType,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Target,
    XFA_ATTRIBUTE_Leader,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_TimeStamp,
    XFA_ATTRIBUTE_Uuid,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_LeftInset,
    XFA_ATTRIBUTE_BottomInset,
    XFA_ATTRIBUTE_TopInset,
    XFA_ATTRIBUTE_RightInset,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_NonRepudiation,
    XFA_ATTRIBUTE_EncipherOnly,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_DigitalSignature,
    XFA_ATTRIBUTE_CrlSign,
    XFA_ATTRIBUTE_KeyAgreement,
    XFA_ATTRIBUTE_KeyEncipherment,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_DataEncipherment,
    XFA_ATTRIBUTE_KeyCertSign,
    XFA_ATTRIBUTE_DecipherOnly,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Open,
    XFA_ATTRIBUTE_CommitOn,
    XFA_ATTRIBUTE_TextEntry,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_HAlign,
    XFA_ATTRIBUTE_TextIndent,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Widows,
    XFA_ATTRIBUTE_MarginRight,
    XFA_ATTRIBUTE_MarginLeft,
    XFA_ATTRIBUTE_RadixOffset,
    XFA_ATTRIBUTE_Preserve,
    XFA_ATTRIBUTE_SpaceBelow,
    XFA_ATTRIBUTE_VAlign,
    XFA_ATTRIBUTE_TabDefault,
    XFA_ATTRIBUTE_TabStops,
    XFA_ATTRIBUTE_Orphans,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_LineHeight,
    XFA_ATTRIBUTE_SpaceAbove,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Version,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_AddRevocationInfo,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Ref,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Listen,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Activity,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_DataRowCount,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_DataPrep,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_TextLocation,
    XFA_ATTRIBUTE_ModuleWidth,
    XFA_ATTRIBUTE_PrintCheckDigit,
    XFA_ATTRIBUTE_ModuleHeight,
    XFA_ATTRIBUTE_StartChar,
    XFA_ATTRIBUTE_Truncate,
    XFA_ATTRIBUTE_WideNarrowRatio,
    XFA_ATTRIBUTE_ErrorCorrectionLevel,
    XFA_ATTRIBUTE_UpsMode,
    XFA_ATTRIBUTE_Checksum,
    XFA_ATTRIBUTE_CharEncoding,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_DataColumnCount,
    XFA_ATTRIBUTE_RowColumnRatio,
    XFA_ATTRIBUTE_DataLength,
    XFA_ATTRIBUTE_EndChar,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Format,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Output,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Input,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_DataDescription,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Highlight,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Break,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Presence,
    XFA_ATTRIBUTE_Relevant,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Hand,
    XFA_ATTRIBUTE_X,
    XFA_ATTRIBUTE_Y,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Level,
    XFA_ATTRIBUTE_Relevant,
    XFA_ATTRIBUTE_ColSpan,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_WordCharacterCount,
    XFA_ATTRIBUTE_Hyphenate,
    XFA_ATTRIBUTE_ExcludeInitialCap,
    XFA_ATTRIBUTE_PushCharacterCount,
    XFA_ATTRIBUTE_RemainCharacterCount,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_ExcludeAllCaps,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Rid,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_MaxChars,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Url,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_CredentialServerPolicy,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_UrlPolicy,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Ref,
    XFA_ATTRIBUTE_Connection,
    XFA_ATTRIBUTE_Target,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_X,
    XFA_ATTRIBUTE_Y,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_NumberOfCells,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_H,
    XFA_ATTRIBUTE_W,
    XFA_ATTRIBUTE_X,
    XFA_ATTRIBUTE_Y,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_HAlign,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Access,
    XFA_ATTRIBUTE_Rotate,
    XFA_ATTRIBUTE_Presence,
    XFA_ATTRIBUTE_VAlign,
    XFA_ATTRIBUTE_MaxH,
    XFA_ATTRIBUTE_MaxW,
    XFA_ATTRIBUTE_MinH,
    XFA_ATTRIBUTE_MinW,
    XFA_ATTRIBUTE_Relevant,
    XFA_ATTRIBUTE_ColSpan,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Locale,
    XFA_ATTRIBUTE_AnchorType,
    XFA_ATTRIBUTE_AccessKey,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_H,
    XFA_ATTRIBUTE_W,
    XFA_ATTRIBUTE_X,
    XFA_ATTRIBUTE_Y,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Relevant,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Cap,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Stroke,
    XFA_ATTRIBUTE_Presence,
    XFA_ATTRIBUTE_Thickness,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Rate,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_SourceBelow,
    XFA_ATTRIBUTE_OutputBelow,
    XFA_ATTRIBUTE_SourceAbove,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_H,
    XFA_ATTRIBUTE_W,
    XFA_ATTRIBUTE_X,
    XFA_ATTRIBUTE_Y,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_HAlign,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Access,
    XFA_ATTRIBUTE_Presence,
    XFA_ATTRIBUTE_VAlign,
    XFA_ATTRIBUTE_MaxH,
    XFA_ATTRIBUTE_MaxW,
    XFA_ATTRIBUTE_MinH,
    XFA_ATTRIBUTE_MinW,
    XFA_ATTRIBUTE_Layout,
    XFA_ATTRIBUTE_Relevant,
    XFA_ATTRIBUTE_ColSpan,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_AnchorType,
    XFA_ATTRIBUTE_AccessKey,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Rid,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Scope,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Connection,
    XFA_ATTRIBUTE_RunAt,
    XFA_ATTRIBUTE_ExecuteType,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Picker,
    XFA_ATTRIBUTE_HScrollPolicy,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_ContentType,
    XFA_ATTRIBUTE_TransferEncoding,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Aspect,
    XFA_ATTRIBUTE_Href,
    XFA_ATTRIBUTE_Value,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Server,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_FracDigits,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_LeadDigits,
    XFA_ATTRIBUTE_H,
    XFA_ATTRIBUTE_W,
    XFA_ATTRIBUTE_X,
    XFA_ATTRIBUTE_Y,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_HAlign,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_AllowMacro,
    XFA_ATTRIBUTE_ColumnWidths,
    XFA_ATTRIBUTE_Access,
    XFA_ATTRIBUTE_Presence,
    XFA_ATTRIBUTE_VAlign,
    XFA_ATTRIBUTE_MaxH,
    XFA_ATTRIBUTE_MaxW,
    XFA_ATTRIBUTE_MinH,
    XFA_ATTRIBUTE_MinW,
    XFA_ATTRIBUTE_Layout,
    XFA_ATTRIBUTE_Relevant,
    XFA_ATTRIBUTE_MergeMode,
    XFA_ATTRIBUTE_ColSpan,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Locale,
    XFA_ATTRIBUTE_AnchorType,
    XFA_ATTRIBUTE_RestoreState,
    XFA_ATTRIBUTE_Scope,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Timeout,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Mode,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Role,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Stroke,
    XFA_ATTRIBUTE_Presence,
    XFA_ATTRIBUTE_Inverted,
    XFA_ATTRIBUTE_Thickness,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Join,
    XFA_ATTRIBUTE_Radius,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_CSpace,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Value,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Next,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Previous,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Intact,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_CommandType,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Data,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_ScriptTest,
    XFA_ATTRIBUTE_NullTest,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_FormatTest,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Relation,
    XFA_ATTRIBUTE_Relevant,
    XFA_ATTRIBUTE_DuplexImposition,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_To,
    XFA_ATTRIBUTE_Force,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_From,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Value,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_DataDescription,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Ref,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Operation,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_BaseProfile,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_ContentType,
    XFA_ATTRIBUTE_RunAt,
    XFA_ATTRIBUTE_Binding,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_PasswordChar,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_HScrollPolicy,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_HScrollPolicy,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_PagePosition,
    XFA_ATTRIBUTE_OddOrEven,
    XFA_ATTRIBUTE_Relevant,
    XFA_ATTRIBUTE_InitialNumber,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Numbered,
    XFA_ATTRIBUTE_BlankOrNotBlank,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Reserve,
    XFA_ATTRIBUTE_Presence,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Placement,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Rid,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_ContentType,
    XFA_ATTRIBUTE_TransferEncoding,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_MaxLength,
    XFA_ATTRIBUTE_Href,
    XFA_ATTRIBUTE_Abbr,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_WritingScript,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Action,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Trailer,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Target,
    XFA_ATTRIBUTE_Leader,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_To,
    XFA_ATTRIBUTE_UnicodeRange,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_From,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_TrayOut,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Orientation,
    XFA_ATTRIBUTE_ImagingBBox,
    XFA_ATTRIBUTE_Short,
    XFA_ATTRIBUTE_TrayIn,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Stock,
    XFA_ATTRIBUTE_Long,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_VScrollPolicy,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_AllowRichText,
    XFA_ATTRIBUTE_MultiLine,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_HScrollPolicy,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_MaxEntries,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_ContentType,
    XFA_ATTRIBUTE_Contains,
    XFA_ATTRIBUTE_Value,
    XFA_ATTRIBUTE_IsNull,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_DataDescription,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Ref,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Operation,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Target,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Ref,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_ContentType,
    XFA_ATTRIBUTE_TransferEncoding,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Match,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Hand,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_H,
    XFA_ATTRIBUTE_W,
    XFA_ATTRIBUTE_X,
    XFA_ATTRIBUTE_Y,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_HAlign,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Rotate,
    XFA_ATTRIBUTE_Presence,
    XFA_ATTRIBUTE_VAlign,
    XFA_ATTRIBUTE_MaxH,
    XFA_ATTRIBUTE_MaxW,
    XFA_ATTRIBUTE_MinH,
    XFA_ATTRIBUTE_MinW,
    XFA_ATTRIBUTE_Relevant,
    XFA_ATTRIBUTE_ColSpan,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Locale,
    XFA_ATTRIBUTE_AnchorType,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Rid,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Priority,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Disable,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Value,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Presence,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_LineThrough,
    XFA_ATTRIBUTE_Typeface,
    XFA_ATTRIBUTE_FontHorizontalScale,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_KerningMode,
    XFA_ATTRIBUTE_Underline,
    XFA_ATTRIBUTE_BaselineShift,
    XFA_ATTRIBUTE_OverlinePeriod,
    XFA_ATTRIBUTE_LetterSpacing,
    XFA_ATTRIBUTE_LineThroughPeriod,
    XFA_ATTRIBUTE_FontVerticalScale,
    XFA_ATTRIBUTE_PsName,
    XFA_ATTRIBUTE_Size,
    XFA_ATTRIBUTE_Posture,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Weight,
    XFA_ATTRIBUTE_UnderlinePeriod,
    XFA_ATTRIBUTE_Overline,
    XFA_ATTRIBUTE_GenericFamily,
    XFA_ATTRIBUTE_Checksum,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Relevant,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Override,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Trailer,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Leader,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_CodeType,
    XFA_ATTRIBUTE_Archive,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_CodeBase,
    XFA_ATTRIBUTE_ClassId,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Ref,
    XFA_ATTRIBUTE_Connection,
    XFA_ATTRIBUTE_LabelRef,
    XFA_ATTRIBUTE_ValueRef,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Override,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Value,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Ref,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Timeout,
    XFA_ATTRIBUTE_Connection,
    XFA_ATTRIBUTE_Usage,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_DelayedOpen,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Format,
    XFA_ATTRIBUTE_EmbedPDF,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Target,
    XFA_ATTRIBUTE_TextEncoding,
    XFA_ATTRIBUTE_XdpContent,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Delimiter,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Ref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Type,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_StartNew,
    XFA_ATTRIBUTE_Trailer,
    XFA_ATTRIBUTE_TargetType,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Target,
    XFA_ATTRIBUTE_Leader,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Slope,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Hand,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Max,
    XFA_ATTRIBUTE_Min,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Initial,
    XFA_ATTRIBUTE_Usehref,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Abbr,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Desc,
    XFA_ATTRIBUTE_Lock,
    XFA_ATTRIBUTE_Id,
    XFA_ATTRIBUTE_Name,
    XFA_ATTRIBUTE_Ref,
    XFA_ATTRIBUTE_Use,
    XFA_ATTRIBUTE_Presence,
    XFA_ATTRIBUTE_Save,
    XFA_ATTRIBUTE_Usehref,
};

const XFA_PACKETINFO g_XFAPacketData[] = {
    {0x0, nullptr, XFA_XDPPACKET_USER, nullptr,
     XFA_XDPPACKET_FLAGS_NOMATCH | XFA_XDPPACKET_FLAGS_SUPPORTMANY},
    {0x811929d, L"sourceSet", XFA_XDPPACKET_SourceSet,
     L"http://www.xfa.org/schema/xfa-source-set/",
     XFA_XDPPACKET_FLAGS_NOMATCH | XFA_XDPPACKET_FLAGS_SUPPORTONE},
    {0xb843dba, L"pdf", XFA_XDPPACKET_Pdf, L"http://ns.adobe.com/xdp/pdf/",
     XFA_XDPPACKET_FLAGS_COMPLETEMATCH | XFA_XDPPACKET_FLAGS_SUPPORTONE},
    {0xc56afbf, L"xdc", XFA_XDPPACKET_Xdc, L"http://www.xfa.org/schema/xdc/",
     XFA_XDPPACKET_FLAGS_NOMATCH | XFA_XDPPACKET_FLAGS_SUPPORTONE},
    {0xc56afcc, L"xdp", XFA_XDPPACKET_XDP, L"http://ns.adobe.com/xdp/",
     XFA_XDPPACKET_FLAGS_COMPLETEMATCH | XFA_XDPPACKET_FLAGS_SUPPORTONE},
    {0x132a8fbc, L"xmpmeta", XFA_XDPPACKET_Xmpmeta,
     L"http://ns.adobe.com/xmpmeta/",
     XFA_XDPPACKET_FLAGS_NOMATCH | XFA_XDPPACKET_FLAGS_SUPPORTMANY},
    {0x48d004a8, L"xfdf", XFA_XDPPACKET_Xfdf, L"http://ns.adobe.com/xfdf/",
     XFA_XDPPACKET_FLAGS_NOMATCH | XFA_XDPPACKET_FLAGS_SUPPORTONE},
    {0x4e1e39b6, L"config", XFA_XDPPACKET_Config,
     L"http://www.xfa.org/schema/xci/",
     XFA_XDPPACKET_FLAGS_NOMATCH | XFA_XDPPACKET_FLAGS_SUPPORTONE},
    {0x5473b6dc, L"localeSet", XFA_XDPPACKET_LocaleSet,
     L"http://www.xfa.org/schema/xfa-locale-set/",
     XFA_XDPPACKET_FLAGS_NOMATCH | XFA_XDPPACKET_FLAGS_SUPPORTONE},
    {0x6038580a, L"stylesheet", XFA_XDPPACKET_Stylesheet,
     L"http://www.w3.org/1999/XSL/Transform",
     XFA_XDPPACKET_FLAGS_NOMATCH | XFA_XDPPACKET_FLAGS_SUPPORTMANY},
    {0x803550fc, L"template", XFA_XDPPACKET_Template,
     L"http://www.xfa.org/schema/xfa-template/",
     XFA_XDPPACKET_FLAGS_NOMATCH | XFA_XDPPACKET_FLAGS_SUPPORTONE},
    {0x8b036f32, L"signature", XFA_XDPPACKET_Signature,
     L"http://www.w3.org/2000/09/xmldsig#",
     XFA_XDPPACKET_FLAGS_NOMATCH | XFA_XDPPACKET_FLAGS_SUPPORTONE},
    {0x99b95079, L"datasets", XFA_XDPPACKET_Datasets,
     L"http://www.xfa.org/schema/xfa-data/",
     XFA_XDPPACKET_FLAGS_PREFIXMATCH | XFA_XDPPACKET_FLAGS_SUPPORTONE},
    {0xcd309ff4, L"form", XFA_XDPPACKET_Form,
     L"http://www.xfa.org/schema/xfa-form/",
     XFA_XDPPACKET_FLAGS_NOMATCH | XFA_XDPPACKET_FLAGS_SUPPORTONE},
    {0xe14c801c, L"connectionSet", XFA_XDPPACKET_ConnectionSet,
     L"http://www.xfa.org/schema/xfa-connection-set/",
     XFA_XDPPACKET_FLAGS_NOMATCH | XFA_XDPPACKET_FLAGS_SUPPORTONE},
};
const int32_t g_iXFAPacketCount =
    sizeof(g_XFAPacketData) / sizeof(XFA_PACKETINFO);

const XFA_SCRIPTHIERARCHY g_XFAScriptIndex[] = {
    {0, 0, 0, 2, 316},      {0, 0, 2, 2, 316},       {0, 0, 4, 2, 316},
    {0, 0, 6, 8, 316},      {0, 0, 14, 4, 316},      {0, 0, 18, 5, 317},
    {0, 0, 23, 2, 316},     {0, 0, 25, 1, 316},      {0, 0, 26, 12, 316},
    {0, 0, 38, 2, 316},     {0, 0, 40, 1, 316},      {0, 0, 41, 3, 316},
    {0, 0, 44, 2, 316},     {0, 0, 46, 6, 316},      {0, 0, 52, 0, 316},
    {0, 0, 52, 2, 319},     {0, 0, 54, 2, 316},      {0, 0, 56, 6, 316},
    {0, 0, 62, 0, 316},     {0, 0, 62, 0, 316},      {0, 0, 62, 2, 316},
    {0, 0, 64, 2, 316},     {0, 0, 66, 6, 316},      {0, 0, 72, 4, 316},
    {0, 0, 76, 7, 316},     {0, 0, 83, 2, 320},      {0, 0, 85, 3, 316},
    {0, 0, 88, 3, 316},     {0, 0, 91, 2, 320},      {0, 0, 93, 6, 320},
    {0, 0, 99, 4, 316},     {0, 0, 103, 2, 316},     {0, 0, 105, 3, 319},
    {0, 0, 108, 4, 316},    {0, 0, 112, 3, 316},     {0, 0, 115, 2, 316},
    {0, 0, 117, 6, 316},    {0, 0, 123, 12, 316},    {0, 0, 135, 2, 316},
    {0, 0, 137, 5, 316},    {0, 0, 142, 2, 316},     {0, 0, 144, 3, 316},
    {0, 0, 147, 1, 316},    {0, 0, 148, 14, 316},    {0, 0, 162, 2, 316},
    {0, 0, 164, 2, 316},    {0, 0, 166, 3, 316},     {0, 0, 169, 2, 316},
    {0, 0, 171, 2, 316},    {0, 0, 173, 2, 316},     {0, 0, 175, 4, 316},
    {0, 0, 179, 2, 316},    {0, 0, 181, 2, 316},     {0, 0, 183, 0, 319},
    {0, 0, 183, 20, 316},   {0, 0, 203, 1, 316},     {0, 0, 204, 3, 316},
    {0, 0, 207, 2, 316},    {0, 0, 209, 0, 316},     {0, 0, 209, 2, 316},
    {0, 0, 211, 2, 316},    {0, 0, 213, 4, 320},     {0, 0, 217, 0, 316},
    {0, 0, 217, 1, 316},    {0, 0, 218, 3, 316},     {0, 4, 221, 0, 312},
    {4, 1, 221, 1, 316},    {5, 0, 222, 2, 316},     {5, 1, 224, 3, -1},
    {6, 0, 227, 0, 316},    {6, 0, 227, 2, 316},     {6, 0, 229, 2, 316},
    {6, 0, 231, 3, 316},    {6, 0, 234, 2, 316},     {6, 0, 236, 6, 316},
    {6, 0, 242, 10, 317},   {6, 0, 252, 9, 316},     {6, 0, 261, 5, 318},
    {6, 0, 266, 4, 318},    {6, 0, 270, 2, 316},     {6, 0, 272, 2, 316},
    {6, 0, 274, 5, 316},    {6, 0, 279, 3, 316},     {6, 0, 282, 2, 316},
    {6, 0, 284, 2, 316},    {6, 0, 286, 2, 316},     {6, 0, 288, 2, 316},
    {6, 0, 290, 4, 316},    {6, 0, 294, 3, 316},     {6, 0, 297, 3, 316},
    {6, 0, 300, 2, 316},    {6, 0, 302, 2, 316},     {6, 0, 304, 2, 316},
    {6, 13, 306, 36, 317},  {19, 0, 342, 3, 316},    {19, 0, 345, 2, 316},
    {19, 0, 347, 2, 316},   {19, 0, 349, 2, 316},    {19, 0, 351, 7, 317},
    {19, 2, 358, 16, 312},  {21, 0, 374, 2, 320},    {21, 0, 376, 2, 316},
    {21, 0, 378, 0, 316},   {21, 0, 378, 2, 316},    {21, 0, 380, 6, 316},
    {21, 0, 386, 3, 316},   {21, 0, 389, 2, 316},    {21, 0, 391, 4, 316},
    {21, 0, 395, 0, 316},   {21, 5, 395, 30, 316},   {26, 0, 425, 2, 320},
    {26, 0, 427, 3, 316},   {26, 0, 430, 2, 320},    {26, 0, 432, 5, 316},
    {26, 0, 437, 2, 316},   {26, 0, 439, 3, 316},    {26, 0, 442, 2, 316},
    {26, 0, 444, 8, 316},   {26, 0, 452, 1, 316},    {26, 0, 453, 2, 316},
    {26, 0, 455, 2, 316},   {26, 0, 457, 4, 316},    {26, 0, 461, 0, 316},
    {26, 0, 461, 2, 316},   {26, 0, 463, 2, 316},    {26, 0, 465, 6, 318},
    {26, 5, 471, 31, 317},  {31, 0, 502, 2, 320},    {31, 0, 504, 2, 316},
    {31, 0, 506, 2, 316},   {31, 0, 508, 4, 320},    {31, 16, 512, 14, 312},
    {47, 0, 526, 2, 316},   {47, 0, 528, 2, 316},    {47, 0, 530, 2, 316},
    {47, 0, 532, 2, 316},   {47, 0, 534, 3, 316},    {47, 0, 537, 2, 316},
    {47, 0, 539, 3, 316},   {47, 0, 542, 3, 316},    {47, 0, 545, 4, 318},
    {47, 0, 549, 4, 316},   {47, 0, 553, 2, 316},    {47, 0, 555, 0, 316},
    {47, 0, 555, 2, 316},   {47, 0, 557, 3, 316},    {47, 0, 560, 6, 316},
    {47, 0, 566, 2, 316},   {47, 0, 568, 2, 316},    {47, 0, 570, 3, 316},
    {47, 19, 573, 1, 312},  {66, 0, 574, 2, 316},    {66, 0, 576, 8, 316},
    {66, 0, 584, 2, 316},   {66, 0, 586, 4, 316},    {66, 0, 590, 5, 316},
    {66, 0, 595, 3, 316},   {66, 0, 598, 2, 320},    {66, 0, 600, 3, 316},
    {66, 0, 603, 7, 316},   {66, 0, 610, 3, 316},    {66, 0, 613, 0, 316},
    {66, 0, 613, 4, 317},   {66, 0, 617, 4, 318},    {66, 0, 621, 2, 320},
    {66, 0, 623, 5, 316},   {66, 0, 628, 2, 316},    {66, 0, 630, 2, 316},
    {66, 0, 632, 2, 320},   {66, 0, 634, 2, 320},    {66, 0, 636, 4, 316},
    {66, 0, 640, 2, 316},   {66, 0, 642, 1, 316},    {66, 0, 643, 1, 316},
    {66, 0, 644, 4, 316},   {66, 0, 648, 3, 316},    {66, 7, 651, 2, 319},
    {73, 0, 653, 2, 316},   {73, 0, 655, 2, 316},    {73, 0, 657, 3, 316},
    {73, 4, 660, 4, 312},   {77, 0, 664, 10, 316},   {77, 0, 674, 2, 316},
    {77, 0, 676, 4, 316},   {77, 0, 680, 4, 316},    {77, 0, 684, 3, 316},
    {77, 0, 687, 2, 316},   {77, 0, 689, 2, 316},    {77, 0, 691, 8, 317},
    {77, 0, 699, 3, 316},   {77, 0, 702, 3, 316},    {77, 0, 705, 2, 316},
    {77, 0, 707, 2, 316},   {77, 0, 709, 5, 316},    {77, 0, 714, 4, 316},
    {77, 0, 718, 2, 316},   {77, 0, 720, 8, 318},    {77, 0, 728, 1, 316},
    {77, 0, 729, 2, 320},   {77, 0, 731, 3, 316},    {77, 1, 734, 4, 316},
    {78, 0, 738, 5, 316},   {78, 0, 743, 3, 316},    {78, 0, 746, 1, 316},
    {78, 0, 747, 2, 320},   {78, 0, 749, 0, 313},    {78, 0, 749, 2, 316},
    {78, 5, 751, 3, 316},   {83, 0, 754, 5, 316},    {83, 0, 759, 7, 316},
    {83, 0, 766, 6, 316},   {83, 0, 772, 3, 316},    {83, 0, 775, 2, 316},
    {83, 0, 777, 5, 316},   {83, 0, 782, 2, 316},    {83, 0, 784, 0, 314},
    {83, 0, 784, 2, 316},   {83, 0, 786, 1, 316},    {83, 0, 787, 2, 316},
    {83, 0, 789, 5, 316},   {83, 0, 794, 2, 316},    {83, 0, 796, 1, 316},
    {83, 0, 797, 2, 316},   {83, 0, 799, 2, 316},    {83, 0, 801, 6, 316},
    {83, 0, 807, 2, 316},   {83, 0, 809, 2, 320},    {83, 0, 811, 3, 316},
    {83, 0, 814, 4, 316},   {83, 0, 818, 2, 316},    {83, 0, 820, 2, 316},
    {83, 0, 822, 2, 316},   {83, 0, 824, 2, 316},    {83, 0, 826, 2, 316},
    {83, 0, 828, 2, 316},   {83, 0, 830, 4, 318},    {83, 1, 834, 2, 316},
    {84, 0, 836, 5, 316},   {84, 0, 841, 20, 317},   {84, 0, 861, 2, 316},
    {84, 0, 863, 0, 316},   {84, 0, 863, 2, 316},    {84, 0, 865, 4, 320},
    {84, 0, 869, 0, 316},   {84, 0, 869, 2, 316},    {84, 0, 871, 1, 316},
    {84, 0, 872, 2, 316},   {84, 0, 874, 3, 316},    {84, 0, 877, 2, 316},
    {84, 0, 879, 2, 316},   {84, 0, 881, 4, 316},    {84, 0, 885, 3, 316},
    {84, 0, 888, 17, 316},  {84, 6, 905, 1, 319},    {90, 0, 906, 2, 316},
    {90, 0, 908, 2, 320},   {90, 0, 910, 2, 320},    {90, 0, 912, 2, 316},
    {90, 0, 914, 2, 316},   {90, 0, 916, 4, 318},    {90, 0, 920, 2, 316},
    {90, 5, 922, 0, 312},   {95, 0, 922, 2, 316},    {95, 0, 924, 4, 316},
    {95, 0, 928, 4, 316},   {95, 0, 932, 6, 316},    {95, 0, 938, 2, 316},
    {95, 0, 940, 4, 316},   {95, 0, 944, 3, 316},    {95, 0, 947, 3, 316},
    {95, 0, 950, 2, 316},   {95, 0, 952, 3, 316},    {95, 0, 955, 0, 316},
    {95, 0, 955, 0, 316},   {95, 0, 955, 2, 316},    {95, 0, 957, 7, 316},
    {95, 0, 964, 2, 316},   {95, 0, 966, 0, 319},    {95, 0, 966, 7, 316},
    {95, 0, 973, 2, 316},   {95, 0, 975, 2, 316},    {95, 3, 977, 1, 316},
    {98, 0, 978, 2, 320},   {98, 0, 980, 4, 316},    {98, 0, 984, 0, 316},
    {98, 0, 984, 2, 316},   {98, 0, 986, 2, 316},    {98, 0, 988, 4, 316},
    {98, 0, 992, 1, 316},   {98, 0, 993, 2, 316},    {98, 0, 995, 2, 316},
    {98, 0, 997, 3, 316},   {98, 0, 1000, 2, 317},   {98, 0, 1002, 0, 316},
    {98, 0, 1002, 4, 316},  {98, 0, 1006, 4, 316},   {98, 0, 1010, 2, 316},
    {98, 0, 1012, 3, 316},  {98, 0, 1015, 4, 316},   {98, 0, 1019, 7, 316},
    {98, 0, 1026, 4, 316},  {98, 0, 1030, 1, 313},   {98, 17, 1031, 3, 316},
    {115, 0, 1034, 5, 316}, {115, 0, 1039, 2, 316},  {115, 0, 1041, 1, 316},
    {115, 0, 1042, 4, 316}, {115, 0, 1046, 2, 316},  {115, 0, 1048, 2, 316},
    {115, 0, 1050, 1, 316}, {115, 0, 1051, 2, 316},  {115, 0, 1053, 5, 316},
    {115, 0, 1058, 1, -1},  {115, 4, 1059, 1, 312},  {119, 1, 1060, 0, 313},
    {120, 2, 1060, 8, 312}, {122, 11, 1068, 6, 315}, {133, 2, 1074, 0, 316},
    {135, 0, 1074, 0, 316}, {135, 3, 1074, 2, 316},  {138, 0, 1076, 2, 316},
};

const XFA_METHODINFO g_SomMethodData[] = {
    {0x3c752495, L"verify", (XFA_METHOD_CALLBACK)&CScript_SignaturePseudoModel::
                                Script_SignaturePseudoModel_Verify},
    {0xa68635f1, L"sign", (XFA_METHOD_CALLBACK)&CScript_SignaturePseudoModel::
                              Script_SignaturePseudoModel_Sign},
    {0xa7f2c5e6, L"enumerate",
     (XFA_METHOD_CALLBACK)&CScript_SignaturePseudoModel::
         Script_SignaturePseudoModel_Enumerate},
    {0xd8ed1467, L"clear", (XFA_METHOD_CALLBACK)&CScript_SignaturePseudoModel::
                               Script_SignaturePseudoModel_Clear},
    {0x4bdcce13, L"execute",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_WsdlConnection_Execute},
    {0x1c296ba4, L"restore",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Delta_Restore},
    {0x7d123a9, L"clearItems",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_ClearItems},
    {0xfb0b007, L"execEvent",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_ExecEvent},
    {0x6716ce97, L"execInitialize",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_ExecInitialize},
    {0x7bb919c2, L"deleteItem",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_DeleteItem},
    {0x9f053d5e, L"getSaveItem",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_GetSaveItem},
    {0xbbd32747, L"boundItem",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_BoundItem},
    {0xc492d950, L"getItemState",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_GetItemState},
    {0xc6013cd3, L"execCalculate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_ExecCalculate},
    {0xd8930d0e, L"setItems",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_SetItems},
    {0xe0f15045, L"getDisplayItem",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_GetDisplayItem},
    {0xe23acddc, L"setItemState",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_SetItemState},
    {0xe2dfb2f8, L"addItem",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_AddItem},
    {0xef8ce48f, L"execValidate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_ExecValidate},
    {0x461079ef, L"emit", (XFA_METHOD_CALLBACK)&CScript_EventPseudoModel::
                              Script_EventPseudoModel_Emit},
    {0xfec90c63, L"reset", (XFA_METHOD_CALLBACK)&CScript_EventPseudoModel::
                               Script_EventPseudoModel_Reset},
    {0xfb0b007, L"execEvent",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ExclGroup_ExecEvent},
    {0x3d832221, L"selectedMember",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ExclGroup_SelectedMember},
    {0x6716ce97, L"execInitialize",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ExclGroup_ExecInitialize},
    {0xc6013cd3, L"execCalculate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ExclGroup_ExecCalculate},
    {0xef8ce48f, L"execValidate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ExclGroup_ExecValidate},
    {0xfb0b007, L"execEvent",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Subform_ExecEvent},
    {0x6716ce97, L"execInitialize",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Subform_ExecInitialize},
    {0xc6013cd3, L"execCalculate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Subform_ExecCalculate},
    {0xd9b9b1f1, L"getInvalidObjects",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Subform_GetInvalidObjects},
    {0xef8ce48f, L"execValidate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Subform_ExecValidate},
    {0xa366b7c, L"exportData", (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
                                   Script_HostPseudoModel_ExportData},
    {0x16cc226c, L"gotoURL", (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
                                 Script_HostPseudoModel_GotoURL},
    {0x1e0722f5, L"pageDown", (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
                                  Script_HostPseudoModel_PageDown},
    {0x3e66cb2c, L"setFocus", (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
                                  Script_HostPseudoModel_SetFocus},
    {0x4ac9faae, L"openList", (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
                                  Script_HostPseudoModel_OpenList},
    {0x7b89714f, L"response", (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
                                  Script_HostPseudoModel_Response},
    {0x7fd9fd58, L"documentInBatch",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
         Script_HostPseudoModel_DocumentInBatch},
    {0xaf1d019d, L"resetData", (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
                                   Script_HostPseudoModel_ResetData},
    {0xb07be13c, L"beep", (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
                              Script_HostPseudoModel_Beep},
    {0xb1882ca0, L"getFocus", (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
                                  Script_HostPseudoModel_GetFocus},
    {0xbf4ba9ee, L"messageBox", (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
                                    Script_HostPseudoModel_MessageBox},
    {0xd6d4dbc1, L"documentCountInBatch",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
         Script_HostPseudoModel_DocumentCountInBatch},
    {0xdd7676ed, L"print", (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
                               Script_HostPseudoModel_Print},
    {0xe2f863d0, L"currentDateTime",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
         Script_HostPseudoModel_CurrentDateTime},
    {0xf995d0f5, L"importData", (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
                                    Script_HostPseudoModel_ImportData},
    {0xfeb96b62, L"pageUp", (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::
                                Script_HostPseudoModel_PageUp},
    {0x68, L"h", (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
                     Script_LayoutPseudoModel_H},
    {0x77, L"w", (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
                     Script_LayoutPseudoModel_W},
    {0x78, L"x", (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
                     Script_LayoutPseudoModel_X},
    {0x79, L"y", (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
                     Script_LayoutPseudoModel_Y},
    {0x5460206, L"pageCount", (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
                                  Script_LayoutPseudoModel_PageCount},
    {0x5eb5b0f, L"pageSpan", (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
                                 Script_LayoutPseudoModel_PageSpan},
    {0x10f1b1bd, L"page", (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
                              Script_LayoutPseudoModel_Page},
    {0x1c1e6318, L"pageContent",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
         Script_LayoutPseudoModel_PageContent},
    {0x1c1f4a5c, L"absPageCount",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
         Script_LayoutPseudoModel_AbsPageCount},
    {0x1ec47db5, L"absPageCountInBatch",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
         Script_LayoutPseudoModel_AbsPageCountInBatch},
    {0x2e4ecbdb, L"sheetCountInBatch",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
         Script_LayoutPseudoModel_SheetCountInBatch},
    {0x2fcff4b5, L"relayout", (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
                                  Script_LayoutPseudoModel_Relayout},
    {0x3bf1c2a5, L"absPageSpan",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
         Script_LayoutPseudoModel_AbsPageSpan},
    {0x5775c2cc, L"absPageInBatch",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
         Script_LayoutPseudoModel_AbsPageInBatch},
    {0x8c5feb32, L"sheetInBatch",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
         Script_LayoutPseudoModel_SheetInBatch},
    {0x8f3a8379, L"sheet", (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
                               Script_LayoutPseudoModel_Sheet},
    {0x96f3c4cb, L"relayoutPageArea",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
         Script_LayoutPseudoModel_RelayoutPageArea},
    {0xd2a4a542, L"sheetCount",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
         Script_LayoutPseudoModel_SheetCount},
    {0xe74f0653, L"absPage", (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::
                                 Script_LayoutPseudoModel_AbsPage},
    {0x44c352ad, L"formNodes",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Template_FormNodes},
    {0x45efb847, L"remerge",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Template_Remerge},
    {0x6716ce97, L"execInitialize",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Template_ExecInitialize},
    {0x712c6afa, L"createNode",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Template_CreateNode},
    {0xa8a35e25, L"recalculate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Template_Recalculate},
    {0xc6013cd3, L"execCalculate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Template_ExecCalculate},
    {0xef8ce48f, L"execValidate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Template_ExecValidate},
    {0x4cc1c0f9, L"moveCurrentRecord",
     (XFA_METHOD_CALLBACK)&CScript_DataWindow::
         Script_DataWindow_MoveCurrentRecord},
    {0x5779d65f, L"record",
     (XFA_METHOD_CALLBACK)&CScript_DataWindow::Script_DataWindow_Record},
    {0x8a476498, L"gotoRecord",
     (XFA_METHOD_CALLBACK)&CScript_DataWindow::Script_DataWindow_GotoRecord},
    {0xaac241c8, L"isRecordGroup",
     (XFA_METHOD_CALLBACK)&CScript_DataWindow::Script_DataWindow_IsRecordGroup},
    {0x1c6f4277, L"evaluate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Manifest_Evaluate},
    {0x2afec2cc, L"moveInstance",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_InstanceManager_MoveInstance},
    {0x2bf94a63, L"removeInstance",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_InstanceManager_RemoveInstance},
    {0x303adaf4, L"setInstances",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_InstanceManager_SetInstances},
    {0x4d76b89e, L"addInstance",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_InstanceManager_AddInstance},
    {0xc660dc8a, L"insertInstance",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_InstanceManager_InsertInstance},
    {0xddfd1ea1, L"metadata",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Desc_Metadata},
    {0x44c352ad, L"formNodes",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Form_FormNodes},
    {0x45efb847, L"remerge",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Form_Remerge},
    {0x6716ce97, L"execInitialize",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Form_ExecInitialize},
    {0xa8a35e25, L"recalculate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Form_Recalculate},
    {0xc6013cd3, L"execCalculate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Form_ExecCalculate},
    {0xef8ce48f, L"execValidate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Form_ExecValidate},
    {0x60490a85, L"message", (XFA_METHOD_CALLBACK)&CScript_LogPseudoModel::
                                 Script_LogPseudoModel_Message},
    {0x60ecfcc9, L"traceDeactivate",
     (XFA_METHOD_CALLBACK)&CScript_LogPseudoModel::
         Script_LogPseudoModel_TraceDeactivate},
    {0x86a0f4c0, L"traceActivate",
     (XFA_METHOD_CALLBACK)&CScript_LogPseudoModel::
         Script_LogPseudoModel_TraceActivate},
    {0x93eac39a, L"traceEnabled", (XFA_METHOD_CALLBACK)&CScript_LogPseudoModel::
                                      Script_LogPseudoModel_TraceEnabled},
    {0xd1227e6f, L"trace",
     (XFA_METHOD_CALLBACK)&CScript_LogPseudoModel::Script_LogPseudoModel_Trace},
    {0x36c0ee14, L"getAttribute",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Packet_GetAttribute},
    {0x5468e2a0, L"setAttribute",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Packet_SetAttribute},
    {0xadc48de2, L"removeAttribute",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Packet_RemoveAttribute},
    {0x3848b3f, L"next", (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Next},
    {0x14e25bc8, L"cancelBatch",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_CancelBatch},
    {0x3ce05d68, L"first",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_First},
    {0x649e1e65, L"updateBatch",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_UpdateBatch},
    {0x6a3405dd, L"previous",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Previous},
    {0x74818fb3, L"isBOF",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_IsBOF},
    {0x74d07a76, L"isEOF",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_IsEOF},
    {0x7613cb66, L"cancel",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Cancel},
    {0x7baca2e3, L"update",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Update},
    {0x8b90e1f2, L"open", (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Open},
    {0x9c6471b3, L"delete",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Delete},
    {0xa7315093, L"addNew",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_AddNew},
    {0xa7ce5f8d, L"requery",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Requery},
    {0xc7368674, L"resync",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Resync},
    {0xd9f47f36, L"close",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Close},
    {0xf54481d4, L"last", (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Last},
    {0xf7965460, L"hasDataChanged",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_HasDataChanged},
    {0x6275f6af, L"item",
     (XFA_METHOD_CALLBACK)&CXFA_NodeList::Script_ListClass_Item},
    {0x7033bfd5, L"insert",
     (XFA_METHOD_CALLBACK)&CXFA_NodeList::Script_ListClass_Insert},
    {0x9cab7cae, L"remove",
     (XFA_METHOD_CALLBACK)&CXFA_NodeList::Script_ListClass_Remove},
    {0xda12e518, L"append",
     (XFA_METHOD_CALLBACK)&CXFA_NodeList::Script_ListClass_Append},
    {0xd892a054, L"namedItem",
     (XFA_METHOD_CALLBACK)&CXFA_NodeList::Script_TreelistClass_NamedItem},
    {0xba2dd386, L"resolveNode",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_TreeClass_ResolveNode},
    {0xe509e2b9, L"resolveNodes",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_TreeClass_ResolveNodes},
    {0x1bca1ebd, L"applyXSL",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_ApplyXSL},
    {0x36c0ee14, L"getAttribute",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_GetAttribute},
    {0x5468e2a0, L"setAttribute",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_SetAttribute},
    {0x5ee00996, L"setElement",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_SetElement},
    {0x92dada4f, L"saveFilteredXML",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_SaveFilteredXML},
    {0x9c456500, L"saveXML",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_SaveXML},
    {0xabd3200a, L"getElement",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_GetElement},
    {0xb269c60d, L"isPropertySpecified",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_IsPropertySpecified},
    {0xb528be91, L"loadXML",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_LoadXML},
    {0xd9f46591, L"clone",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_Clone},
    {0xe006a76b, L"assignNode",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_AssignNode},
    {0x7303fcea, L"getDelta",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ContainerClass_GetDelta},
    {0xe7742c9d, L"getDeltas",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ContainerClass_GetDeltas},
    {0x30ff6aad, L"clearErrorList",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ModelClass_ClearErrorList},
    {0x712c6afa, L"createNode",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ModelClass_CreateNode},
    {0x83a6411d, L"isCompatibleNS",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ModelClass_IsCompatibleNS},
};
const int32_t g_iSomMethodCount =
    sizeof(g_SomMethodData) / sizeof(XFA_METHODINFO);

const XFA_SCRIPTATTRIBUTEINFO g_SomAttributeData[] = {
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xb3543a6, L"max",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Max, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x45a6daf8, L"eofAction",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_EofAction, XFA_SCRIPT_Basic},
    {0x5ec958c0, L"cursorType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CursorType, XFA_SCRIPT_Basic},
    {0x79975f2b, L"lockType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LockType, XFA_SCRIPT_Basic},
    {0xa5340ff5, L"bofAction",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_BofAction, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc5762157, L"cursorLocation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CursorLocation, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1ee2d24d, L"instanceIndex",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_InstanceIndex, -1,
     XFA_SCRIPT_Basic},
    {0x8c99377e, L"relation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relation, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0x3106c3a, L"beforeTarget",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_BeforeTarget, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x13a08bdb, L"overflowTarget",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_OverflowTarget, XFA_SCRIPT_Basic},
    {0x169134a1, L"overflowLeader",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_OverflowLeader, XFA_SCRIPT_Basic},
    {0x20914367, L"overflowTrailer",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_OverflowTrailer, XFA_SCRIPT_Basic},
    {0x453eaf38, L"startNew",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_StartNew, XFA_SCRIPT_Basic},
    {0x64110ab5, L"bookendTrailer",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_BookendTrailer, XFA_SCRIPT_Basic},
    {0xb6b44172, L"after",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_After, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc3c1442f, L"bookendLeader",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_BookendLeader, XFA_SCRIPT_Basic},
    {0xcb150479, L"afterTarget",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AfterTarget, XFA_SCRIPT_Basic},
    {0xf4ffce73, L"before",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Before, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue_Read, -1,
     XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x47cfa43a, L"allowNeutral",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AllowNeutral, XFA_SCRIPT_Basic},
    {0x7c2fd80b, L"mark",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Mark, XFA_SCRIPT_Basic},
    {0x8ed182d1, L"shape",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Shape, XFA_SCRIPT_Basic},
    {0xa686975b, L"size",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Size, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x5c054755, L"startAngle",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_StartAngle, XFA_SCRIPT_Basic},
    {0x74788f8b, L"sweepAngle",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_SweepAngle, XFA_SCRIPT_Basic},
    {0x9d833d75, L"circular",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Circular, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd996fa9b, L"hand",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Hand, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xb0e5485d, L"bind",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Bind, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xcd7f7b54, L"from",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_From, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x8e29d794, L"signatureType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_SignatureType, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe11a2cbc, L"permissions",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Permissions, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x453eaf38, L"startNew",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_StartNew, XFA_SCRIPT_Basic},
    {0x9dcc3ab3, L"trailer",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Trailer, XFA_SCRIPT_Basic},
    {0xa6118c89, L"targetType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TargetType, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Target, XFA_SCRIPT_Basic},
    {0xcbcaf66d, L"leader",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Leader, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x2d574d58, L"this", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Xfa_This,
     -1, XFA_SCRIPT_Object},
    {0x4fdc3454, L"timeStamp",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TimeStamp, XFA_SCRIPT_Basic},
    {0xb598a1f7, L"uuid",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Uuid, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xcfea02e, L"leftInset",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LeftInset, XFA_SCRIPT_Basic},
    {0x1356caf8, L"bottomInset",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_BottomInset, XFA_SCRIPT_Basic},
    {0x25764436, L"topInset",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TopInset, XFA_SCRIPT_Basic},
    {0x8a692521, L"rightInset",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_RightInset, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1e459b8f, L"nonRepudiation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_NonRepudiation, XFA_SCRIPT_Basic},
    {0x2bb3f470, L"encipherOnly",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_EncipherOnly, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0x5f760b50, L"digitalSignature",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DigitalSignature, XFA_SCRIPT_Basic},
    {0x69aa2292, L"crlSign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CrlSign, XFA_SCRIPT_Basic},
    {0x98fd4d81, L"keyAgreement",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_KeyAgreement, XFA_SCRIPT_Basic},
    {0xa66404cb, L"keyEncipherment",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_KeyEncipherment, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xca5dc27c, L"dataEncipherment",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataEncipherment, XFA_SCRIPT_Basic},
    {0xe8f118a8, L"keyCertSign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_KeyCertSign, XFA_SCRIPT_Basic},
    {0xfea53ec6, L"decipherOnly",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DecipherOnly, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x8b90e1f2, L"open",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Open, XFA_SCRIPT_Basic},
    {0x957fa006, L"commitOn",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CommitOn, XFA_SCRIPT_Basic},
    {0xb12128b7, L"textEntry",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TextEntry, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0x2282c73, L"hAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HAlign, XFA_SCRIPT_Basic},
    {0x8d4f1c7, L"textIndent",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TextIndent, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2a82d99c, L"marginRight",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MarginRight, XFA_SCRIPT_Basic},
    {0x534729c9, L"marginLeft",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MarginLeft, XFA_SCRIPT_Basic},
    {0x5739d1ff, L"radixOffset",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_RadixOffset, XFA_SCRIPT_Basic},
    {0x577682ac, L"preserve",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Preserve, XFA_SCRIPT_Basic},
    {0x731e0665, L"spaceBelow",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_SpaceBelow, XFA_SCRIPT_Basic},
    {0x7a7cc341, L"vAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_VAlign, XFA_SCRIPT_Basic},
    {0x836d4d7c, L"tabDefault",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TabDefault, XFA_SCRIPT_Basic},
    {0x8fa01790, L"tabStops",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TabStops, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd4b01921, L"lineHeight",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LineHeight, XFA_SCRIPT_Basic},
    {0xe18b5659, L"spaceAbove",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_SpaceAbove, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd861f8af, L"addRevocationInfo",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AddRevocationInfo, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbb8df5d, L"ref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Ref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6128d8d, L"activity",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Activity, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x43e349b, L"dataRowCount",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataRowCount, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x28e17e91, L"dataPrep",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataPrep, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0x3650557e, L"textLocation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TextLocation, XFA_SCRIPT_Basic},
    {0x3b582286, L"moduleWidth",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ModuleWidth, XFA_SCRIPT_Basic},
    {0x52666f1c, L"printCheckDigit",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_PrintCheckDigit, XFA_SCRIPT_Basic},
    {0x5404d6df, L"moduleHeight",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ModuleHeight, XFA_SCRIPT_Basic},
    {0x5ab23b6c, L"startChar",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_StartChar, XFA_SCRIPT_Basic},
    {0x7c732a66, L"truncate",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Truncate, XFA_SCRIPT_Basic},
    {0x8d181d61, L"wideNarrowRatio",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_WideNarrowRatio, XFA_SCRIPT_Basic},
    {0x99800d7a, L"errorCorrectionLevel",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ErrorCorrectionLevel, XFA_SCRIPT_Basic},
    {0x9a63da3d, L"upsMode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_UpsMode, XFA_SCRIPT_Basic},
    {0xaf754613, L"checksum",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Checksum, XFA_SCRIPT_Basic},
    {0xb045fbc5, L"charEncoding",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CharEncoding, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc035c6b1, L"dataColumnCount",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataColumnCount, XFA_SCRIPT_Basic},
    {0xd3c84d25, L"rowColumnRatio",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_RowColumnRatio, XFA_SCRIPT_Basic},
    {0xd57c513c, L"dataLength",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataLength, XFA_SCRIPT_Basic},
    {0xf575ca75, L"endChar",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_EndChar, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0x28dee6e9, L"format",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Format, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x60d4c8b1, L"output",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Output, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6a39990, L"input",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Input, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x2b5df51e, L"dataDescription",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataDescription, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x6c0d9600, L"currentValue",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Delta_CurrentValue, -1,
     XFA_SCRIPT_Basic},
    {0x942643f0, L"savedValue",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Delta_SavedValue, -1,
     XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Delta_Target, -1,
     XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd4cc53f8, L"highlight",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Highlight, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x5518c25, L"break",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Break, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd996fa9b, L"hand",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Hand, XFA_SCRIPT_Basic},
    {0x78, L"x", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_X, XFA_SCRIPT_Basic},
    {0x79, L"y", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Y, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1059ec18, L"level",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_Integer,
     XFA_ATTRIBUTE_Level, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xac06e2b0, L"colSpan",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ColSpan, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x21aed, L"id",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Id, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f105f72, L"wordCharacterCount",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_WordCharacterCount, XFA_SCRIPT_Basic},
    {0x3d123c26, L"hyphenate",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Hyphenate, XFA_SCRIPT_Basic},
    {0x66539c48, L"excludeInitialCap",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ExcludeInitialCap, XFA_SCRIPT_Basic},
    {0x6a95c976, L"pushCharacterCount",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_PushCharacterCount, XFA_SCRIPT_Basic},
    {0x982bd892, L"remainCharacterCount",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_RemainCharacterCount, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe5c96d6a, L"excludeAllCaps",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ExcludeAllCaps, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x8af2e657, L"maxChars",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxChars, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc080cd3, L"url",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Url, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa6710262, L"credentialServerPolicy",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CredentialServerPolicy, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc2ba0923, L"urlPolicy",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_UrlPolicy, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x47d03490, L"connection",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Connection, XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Target, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x78bff531, L"numberOfCells",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_Integer,
     XFA_ATTRIBUTE_NumberOfCells, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x68, L"h", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_H, XFA_SCRIPT_Basic},
    {0x77, L"w", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_W, XFA_SCRIPT_Basic},
    {0x78, L"x", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_X, XFA_SCRIPT_Basic},
    {0x79, L"y", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Y, XFA_SCRIPT_Basic},
    {0x2282c73, L"hAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HAlign, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1abbd7e0, L"dataNode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DataNode, -1,
     XFA_SCRIPT_Object},
    {0x25839852, L"access",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Access, XFA_SCRIPT_Basic},
    {0x2ee7678f, L"rotate",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Rotate, XFA_SCRIPT_Basic},
    {0x3b1ddd06, L"fillColor",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_FillColor, -1,
     XFA_SCRIPT_Basic},
    {0x54c399e3, L"formattedValue",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Field_FormattedValue, -1,
     XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0x5a3b375d, L"borderColor",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_BorderColor, -1,
     XFA_SCRIPT_Basic},
    {0x5e936ed6, L"fontColor",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_FontColor, -1,
     XFA_SCRIPT_Basic},
    {0x6826c408, L"parentSubform",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Field_ParentSubform, -1,
     XFA_SCRIPT_Basic},
    {0x79b67434, L"mandatoryMessage",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_MandatoryMessage, -1,
     XFA_SCRIPT_Basic},
    {0x7a7cc341, L"vAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_VAlign, XFA_SCRIPT_Basic},
    {0x7c2ff6ae, L"maxH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxH, XFA_SCRIPT_Basic},
    {0x7c2ff6bd, L"maxW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxW, XFA_SCRIPT_Basic},
    {0x7d02356c, L"minH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinH, XFA_SCRIPT_Basic},
    {0x7d02357b, L"minW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinW, XFA_SCRIPT_Basic},
    {0x85fd6faf, L"mandatory",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_Mandatory, -1,
     XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0x964fb42e, L"formatMessage",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Field_FormatMessage, -1,
     XFA_SCRIPT_Basic},
    {0xa03cf627, L"rawValue",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xa60dd202, L"length",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Field_Length, -1,
     XFA_SCRIPT_Basic},
    {0xac06e2b0, L"colSpan",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ColSpan, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbc8fa350, L"locale",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Locale, XFA_SCRIPT_Basic},
    {0xc2bd40fd, L"anchorType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AnchorType, XFA_SCRIPT_Basic},
    {0xc4fed09b, L"accessKey",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AccessKey, XFA_SCRIPT_Basic},
    {0xcabfa3d0, L"validationMessage",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_ValidationMessage, -1,
     XFA_SCRIPT_Basic},
    {0xdcecd663, L"editValue",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Field_EditValue, -1,
     XFA_SCRIPT_Basic},
    {0xe07e5061, L"selectedIndex",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Field_SelectedIndex, -1,
     XFA_SCRIPT_Basic},
    {0xf65e34be, L"borderWidth",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_BorderWidth, -1,
     XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x68, L"h", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_H, XFA_SCRIPT_Basic},
    {0x77, L"w", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_W, XFA_SCRIPT_Basic},
    {0x78, L"x", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_X, XFA_SCRIPT_Basic},
    {0x79, L"y", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Y, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd843798, L"fullText", (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
                                 Script_EventPseudoModel_FullText,
     -1, XFA_SCRIPT_Basic},
    {0x1b6d1cf5, L"reenter", (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
                                 Script_EventPseudoModel_Reenter,
     -1, XFA_SCRIPT_Basic},
    {0x1e6ffa9a, L"prevContentType",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
         Script_EventPseudoModel_PrevContentType,
     -1, XFA_SCRIPT_Basic},
    {0x25a3c206, L"soapFaultString",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
         Script_EventPseudoModel_SoapFaultString,
     -1, XFA_SCRIPT_Basic},
    {0x2e00c007, L"newContentType",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
         Script_EventPseudoModel_NewContentType,
     -1, XFA_SCRIPT_Basic},
    {0x4570500f, L"modifier",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
         Script_EventPseudoModel_Modifier,
     -1, XFA_SCRIPT_Basic},
    {0x50e2e33b, L"selEnd", (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
                                Script_EventPseudoModel_SelEnd,
     -1, XFA_SCRIPT_Basic},
    {0x57de87c2, L"prevText",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
         Script_EventPseudoModel_PrevText,
     -1, XFA_SCRIPT_Basic},
    {0x6ea04e0a, L"soapFaultCode",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
         Script_EventPseudoModel_SoapFaultCode,
     -1, XFA_SCRIPT_Basic},
    {0x6f6556cf, L"newText", (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
                                 Script_EventPseudoModel_NewText,
     -1, XFA_SCRIPT_Basic},
    {0x891f4606, L"change", (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
                                Script_EventPseudoModel_Change,
     -1, XFA_SCRIPT_Basic},
    {0x8fa3c19e, L"shift", (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
                               Script_EventPseudoModel_Shift,
     -1, XFA_SCRIPT_Basic},
    {0xa9d9b2e1, L"keyDown", (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
                                 Script_EventPseudoModel_KeyDown,
     -1, XFA_SCRIPT_Basic},
    {0xbfc89db2, L"selStart",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
         Script_EventPseudoModel_SelStart,
     -1, XFA_SCRIPT_Basic},
    {0xc32a5812, L"commitKey",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
         Script_EventPseudoModel_CommitKey,
     -1, XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target", (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::
                                Script_EventPseudoModel_Target,
     -1, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xa2e3514, L"cap",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Cap, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x5392ea58, L"stroke",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Stroke, XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0x94446dcc, L"thickness",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Thickness, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1ec8ab2c, L"rate",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Rate, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x7b29630a, L"sourceBelow",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_SourceBelow, XFA_SCRIPT_Basic},
    {0x8fc36c0a, L"outputBelow",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_OutputBelow, XFA_SCRIPT_Basic},
    {0xe996b2fe, L"sourceAbove",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_SourceAbove, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x68, L"h", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_H, XFA_SCRIPT_Basic},
    {0x77, L"w", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_W, XFA_SCRIPT_Basic},
    {0x78, L"x", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_X, XFA_SCRIPT_Basic},
    {0x79, L"y", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Y, XFA_SCRIPT_Basic},
    {0x2282c73, L"hAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HAlign, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xf23332f, L"errorText",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_ExclGroup_ErrorText, -1,
     XFA_SCRIPT_Basic},
    {0x1abbd7e0, L"dataNode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DataNode, -1,
     XFA_SCRIPT_Object},
    {0x25839852, L"access",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Access, XFA_SCRIPT_Basic},
    {0x3b1ddd06, L"fillColor",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_FillColor, -1,
     XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0x5a3b375d, L"borderColor",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_BorderColor, -1,
     XFA_SCRIPT_Basic},
    {0x79b67434, L"mandatoryMessage",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_MandatoryMessage, -1,
     XFA_SCRIPT_Basic},
    {0x7a7cc341, L"vAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_VAlign, XFA_SCRIPT_Basic},
    {0x7c2ff6ae, L"maxH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxH, XFA_SCRIPT_Basic},
    {0x7c2ff6bd, L"maxW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxW, XFA_SCRIPT_Basic},
    {0x7d02356c, L"minH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinH, XFA_SCRIPT_Basic},
    {0x7d02357b, L"minW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinW, XFA_SCRIPT_Basic},
    {0x7e7e845e, L"layout",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Layout, XFA_SCRIPT_Basic},
    {0x846599f8, L"transient",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_ExclGroup_Transient, -1,
     XFA_SCRIPT_Basic},
    {0x85fd6faf, L"mandatory",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_Mandatory, -1,
     XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xa03cf627, L"rawValue",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_ExclGroup_DefaultAndRawValue,
     -1, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_ExclGroup_DefaultAndRawValue,
     -1, XFA_SCRIPT_Basic},
    {0xac06e2b0, L"colSpan",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ColSpan, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc2bd40fd, L"anchorType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AnchorType, XFA_SCRIPT_Basic},
    {0xc4fed09b, L"accessKey",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AccessKey, XFA_SCRIPT_Basic},
    {0xcabfa3d0, L"validationMessage",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_ValidationMessage, -1,
     XFA_SCRIPT_Basic},
    {0xf65e34be, L"borderWidth",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_BorderWidth, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xeda9017a, L"scope",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Scope, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x47d03490, L"connection",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Connection, XFA_SCRIPT_Basic},
    {0x6cfa828a, L"runAt",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_RunAt, XFA_SCRIPT_Basic},
    {0xa1b0d2f5, L"executeType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ExecuteType, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe6f99487, L"hScrollPolicy",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HScrollPolicy, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x42fed1fd, L"contentType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ContentType, XFA_SCRIPT_Basic},
    {0x54fa722c, L"transferEncoding",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TransferEncoding, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue_Read, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd171b240, L"aspect",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Aspect, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue_Read, -1,
     XFA_SCRIPT_Basic},
    {0xdb55fec5, L"href",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Href, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Value, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0x7f6fd3d7, L"server",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Server, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x4b8bc840, L"fracDigits",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_FracDigits, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xde7f92ba, L"leadDigits",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LeadDigits, XFA_SCRIPT_Basic},
    {0x68, L"h", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_H, XFA_SCRIPT_Basic},
    {0x77, L"w", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_W, XFA_SCRIPT_Basic},
    {0x78, L"x", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_X, XFA_SCRIPT_Basic},
    {0x79, L"y", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Y, XFA_SCRIPT_Basic},
    {0x2282c73, L"hAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HAlign, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1414d431, L"allowMacro",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AllowMacro, XFA_SCRIPT_Basic},
    {0x1517dfa1, L"columnWidths",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ColumnWidths, XFA_SCRIPT_Basic},
    {0x1abbd7e0, L"dataNode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DataNode, -1,
     XFA_SCRIPT_Object},
    {0x1ee2d24d, L"instanceIndex",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_InstanceIndex, -1,
     XFA_SCRIPT_Basic},
    {0x25839852, L"access",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Access, XFA_SCRIPT_Basic},
    {0x3b1ddd06, L"fillColor",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_FillColor, -1,
     XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0x5a3b375d, L"borderColor",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_BorderColor, -1,
     XFA_SCRIPT_Basic},
    {0x7a7cc341, L"vAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_VAlign, XFA_SCRIPT_Basic},
    {0x7c2ff6ae, L"maxH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxH, XFA_SCRIPT_Basic},
    {0x7c2ff6bd, L"maxW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxW, XFA_SCRIPT_Basic},
    {0x7d02356c, L"minH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinH, XFA_SCRIPT_Basic},
    {0x7d02357b, L"minW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinW, XFA_SCRIPT_Basic},
    {0x7e7e845e, L"layout",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Layout, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0x9cc17d75, L"mergeMode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MergeMode, XFA_SCRIPT_Basic},
    {0x9f3e9510, L"instanceManager",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Subform_InstanceManager, -1,
     XFA_SCRIPT_Object},
    {0xac06e2b0, L"colSpan",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ColSpan, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbc8fa350, L"locale",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Subform_Locale, -1,
     XFA_SCRIPT_Basic},
    {0xc2bd40fd, L"anchorType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AnchorType, XFA_SCRIPT_Basic},
    {0xcabfa3d0, L"validationMessage",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_ValidationMessage, -1,
     XFA_SCRIPT_Basic},
    {0xe4c3a5e5, L"restoreState",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_RestoreState, XFA_SCRIPT_Basic},
    {0xeda9017a, L"scope",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Scope, XFA_SCRIPT_Basic},
    {0xf65e34be, L"borderWidth",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_BorderWidth, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0x5a50e9e6, L"version",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Handler_Version, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x4107ed, L"foxitAppType",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::
         Script_HostPseudoModel_FoxitAppType,
     -1, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name", (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::
                             Script_HostPseudoModel_Name,
     -1, XFA_SCRIPT_Basic},
    {0x66c1ae9, L"validationsEnabled",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::
         Script_HostPseudoModel_ValidationsEnabled,
     -1, XFA_SCRIPT_Basic},
    {0x14d04502, L"title", (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::
                               Script_HostPseudoModel_Title,
     -1, XFA_SCRIPT_Basic},
    {0x193afe8b, L"foxitName",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::
         Script_HostPseudoModel_FoxitName,
     -1, XFA_SCRIPT_Basic},
    {0x392ae445, L"platform", (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::
                                  Script_HostPseudoModel_Platform,
     -1, XFA_SCRIPT_Basic},
    {0x5a50e9e6, L"version", (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::
                                 Script_HostPseudoModel_Version,
     -1, XFA_SCRIPT_Basic},
    {0x66cb1eed, L"variation",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::
         Script_HostPseudoModel_Variation,
     -1, XFA_SCRIPT_Basic},
    {0x7717cbc4, L"language", (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::
                                  Script_HostPseudoModel_Language,
     -1, XFA_SCRIPT_Basic},
    {0x86698963, L"appType", (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::
                                 Script_HostPseudoModel_AppType,
     -1, XFA_SCRIPT_Basic},
    {0x94ff9e8d, L"calculationsEnabled",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::
         Script_HostPseudoModel_CalculationsEnabled,
     -1, XFA_SCRIPT_Basic},
    {0xbcd44940, L"currentPage",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::
         Script_HostPseudoModel_CurrentPage,
     -1, XFA_SCRIPT_Basic},
    {0xd4286870, L"foxitVersion",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::
         Script_HostPseudoModel_FoxitVersion,
     -1, XFA_SCRIPT_Basic},
    {0xd592b920, L"numPages", (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::
                                  Script_HostPseudoModel_NumPages,
     -1, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x24d85167, L"timeout",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Timeout, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x7d9fd7c5, L"mode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Mode, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x7d9fd7c5, L"mode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_SubmitFormat_Mode, -1,
     XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2038c9b2, L"role",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Role, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xfcef86b5, L"ready", (XFA_ATTRIBUTE_CALLBACK)&CScript_LayoutPseudoModel::
                               Script_LayoutPseudoModel_Ready,
     -1, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x5392ea58, L"stroke",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Stroke, XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0x7b95e661, L"inverted",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Inverted, XFA_SCRIPT_Basic},
    {0x94446dcc, L"thickness",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Thickness, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe8dddf50, L"join",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Join, XFA_SCRIPT_Basic},
    {0xe948b9a8, L"radius",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Radius, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xabfa6c4f, L"cSpace",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CSpace, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Value, XFA_SCRIPT_Basic},
    {0x3848b3f, L"next",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Next, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x6a3405dd, L"previous",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Previous, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xf6b59543, L"intact",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Intact, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x268b7ec1, L"commandType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CommandType, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbde9abda, L"data",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Data, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x5b707a35, L"scriptTest",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ScriptTest, XFA_SCRIPT_Basic},
    {0x6b6ddcfb, L"nullTest",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_NullTest, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xe64b1129, L"formatTest",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_FormatTest, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x8c99377e, L"relation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relation, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x25363, L"to",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_To, XFA_SCRIPT_Basic},
    {0x66642f8f, L"force",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Force, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xcd7f7b54, L"from",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_From, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Value, XFA_SCRIPT_Basic},
    {0x2b5df51e, L"dataDescription",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataDescription, XFA_SCRIPT_Basic},
    {0xbb8df5d, L"ref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Ref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x226ca8f1, L"operation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Operation, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xfb67185, L"recordsBefore", (XFA_ATTRIBUTE_CALLBACK)&CScript_DataWindow::
                                      Script_DataWindow_RecordsBefore,
     -1, XFA_SCRIPT_Basic},
    {0x21d5dfcb, L"currentRecordNumber",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_DataWindow::
         Script_DataWindow_CurrentRecordNumber,
     -1, XFA_SCRIPT_Basic},
    {0x312af044, L"recordsAfter", (XFA_ATTRIBUTE_CALLBACK)&CScript_DataWindow::
                                      Script_DataWindow_RecordsAfter,
     -1, XFA_SCRIPT_Basic},
    {0x6aab37cb, L"isDefined",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_DataWindow::Script_DataWindow_IsDefined,
     -1, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x42fed1fd, L"contentType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ContentType, XFA_SCRIPT_Basic},
    {0x6cfa828a, L"runAt",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_RunAt, XFA_SCRIPT_Basic},
    {0xa021b738, L"stateless",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Script_Stateless, -1,
     XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xadc4c77b, L"binding",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Binding, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x7a0cc471, L"passwordChar",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_PasswordChar, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe6f99487, L"hScrollPolicy",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HScrollPolicy, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe6f99487, L"hScrollPolicy",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HScrollPolicy, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x14a32d52, L"pagePosition",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_PagePosition, XFA_SCRIPT_Basic},
    {0x8340ea66, L"oddOrEven",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_OddOrEven, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xa85e74f3, L"initialNumber",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_InitialNumber, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe9ba472, L"numbered",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Numbered, XFA_SCRIPT_Basic},
    {0xd70798c2, L"blankOrNotBlank",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_BlankOrNotBlank, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x34ae103c, L"reserve",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Reserve, XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xf2009339, L"placement",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Placement, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x42fed1fd, L"contentType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ContentType, XFA_SCRIPT_Basic},
    {0x54fa722c, L"transferEncoding",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TransferEncoding, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc4547a08, L"maxLength",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxLength, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xdb55fec5, L"href",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Href, XFA_SCRIPT_Basic},
    {0x29418bb7, L"abbr",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Abbr, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf531b059, L"writingScript",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_WritingScript, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1b8dce3e, L"action",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Action, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x9dcc3ab3, L"trailer",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Trailer, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Target, XFA_SCRIPT_Basic},
    {0xcbcaf66d, L"leader",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Leader, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xb3543a6, L"max",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_InstanceManager_Max, -1,
     XFA_SCRIPT_Basic},
    {0xb356ca4, L"min",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_InstanceManager_Min, -1,
     XFA_SCRIPT_Basic},
    {0x6f544d49, L"count",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_InstanceManager_Count, -1,
     XFA_SCRIPT_Basic},
    {0x25363, L"to",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_To, XFA_SCRIPT_Basic},
    {0xa0933954, L"unicodeRange",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_UnicodeRange, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xcd7f7b54, L"from",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_From, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x4ef3d02c, L"orientation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Orientation, XFA_SCRIPT_Basic},
    {0x65e30c67, L"imagingBBox",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ImagingBBox, XFA_SCRIPT_Basic},
    {0x9041d4b0, L"short",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Short, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe349d044, L"stock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Stock, XFA_SCRIPT_Basic},
    {0xf6b4afb0, L"long",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Long, XFA_SCRIPT_Basic},
    {0x5ce6195, L"vScrollPolicy",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_VScrollPolicy, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1ef3a64a, L"allowRichText",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AllowRichText, XFA_SCRIPT_Basic},
    {0x5a32e493, L"multiLine",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MultiLine, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe6f99487, L"hScrollPolicy",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HScrollPolicy, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xd52482e0, L"maxEntries",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxEntries, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x42fed1fd, L"contentType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ContentType, XFA_SCRIPT_Basic},
    {0x8855805f, L"contains",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Contains, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xe372ae97, L"isNull",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_IsNull, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x2b5df51e, L"dataDescription",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataDescription, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbb8df5d, L"ref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Ref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x226ca8f1, L"operation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Operation, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Target, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbb8df5d, L"ref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Ref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x42fed1fd, L"contentType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ContentType, XFA_SCRIPT_Basic},
    {0x54fa722c, L"transferEncoding",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TransferEncoding, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xf197844d, L"match",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Match, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd996fa9b, L"hand",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Hand, XFA_SCRIPT_Basic},
    {0x21aed, L"id",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Id, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x28dee6e9, L"format",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Encrypt_Format, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x68, L"h", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_H, XFA_SCRIPT_Basic},
    {0x77, L"w", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_W, XFA_SCRIPT_Basic},
    {0x78, L"x", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_X, XFA_SCRIPT_Basic},
    {0x79, L"y", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Y, XFA_SCRIPT_Basic},
    {0x2282c73, L"hAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HAlign, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2ee7678f, L"rotate",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Rotate, XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0x7a7cc341, L"vAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_VAlign, XFA_SCRIPT_Basic},
    {0x7c2ff6ae, L"maxH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxH, XFA_SCRIPT_Basic},
    {0x7c2ff6bd, L"maxW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxW, XFA_SCRIPT_Basic},
    {0x7d02356c, L"minH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinH, XFA_SCRIPT_Basic},
    {0x7d02357b, L"minW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinW, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xa03cf627, L"rawValue",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xac06e2b0, L"colSpan",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ColSpan, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbc8fa350, L"locale",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Locale, XFA_SCRIPT_Basic},
    {0xc2bd40fd, L"anchorType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AnchorType, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x39cdb0a2, L"priority",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Priority, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xeb511b54, L"disable",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Disable, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Value, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x21aed, L"id",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Id, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xcb0ac9, L"lineThrough",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LineThrough, XFA_SCRIPT_Basic},
    {0x2c1c7f1, L"typeface",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Typeface, XFA_SCRIPT_Basic},
    {0x8c74ae9, L"fontHorizontalScale",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_FontHorizontalScale, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2cd79033, L"kerningMode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_KerningMode, XFA_SCRIPT_Basic},
    {0x3a0273a6, L"underline",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Underline, XFA_SCRIPT_Basic},
    {0x4873c601, L"baselineShift",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_BaselineShift, XFA_SCRIPT_Basic},
    {0x4b319767, L"overlinePeriod",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_OverlinePeriod, XFA_SCRIPT_Basic},
    {0x79543055, L"letterSpacing",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LetterSpacing, XFA_SCRIPT_Basic},
    {0x8ec6204c, L"lineThroughPeriod",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LineThroughPeriod, XFA_SCRIPT_Basic},
    {0x907c7719, L"fontVerticalScale",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_FontVerticalScale, XFA_SCRIPT_Basic},
    {0xa686975b, L"size",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Size, XFA_SCRIPT_Basic},
    {0xb5e49bf2, L"posture",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Posture, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbd6e1d88, L"weight",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Weight, XFA_SCRIPT_Basic},
    {0xbd96a0e9, L"underlinePeriod",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_UnderlinePeriod, XFA_SCRIPT_Basic},
    {0xc0ec9fa4, L"overline",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Overline, XFA_SCRIPT_Basic},
    {0xaf754613, L"checksum",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Form_Checksum, -1,
     XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xea7090a0, L"override",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Override, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x9dcc3ab3, L"trailer",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Trailer, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xcbcaf66d, L"leader",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Leader, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x60a61edd, L"codeType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CodeType, XFA_SCRIPT_Basic},
    {0xb373a862, L"archive",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Archive, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe1a26b56, L"codeBase",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CodeBase, XFA_SCRIPT_Basic},
    {0xeb091003, L"classId",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ClassId, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x47d03490, L"connection",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Connection, XFA_SCRIPT_Basic},
    {0xc39a88bd, L"labelRef",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LabelRef, XFA_SCRIPT_Basic},
    {0xd50f903a, L"valueRef",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ValueRef, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xea7090a0, L"override",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Override, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Extras_Type, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbb8df5d, L"ref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Ref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x24d85167, L"timeout",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Timeout, XFA_SCRIPT_Basic},
    {0x47d03490, L"connection",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Connection, XFA_SCRIPT_Basic},
    {0x552d9ad5, L"usage",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usage, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc860f30a, L"delayedOpen",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DelayedOpen, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x28dee6e9, L"format",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Format, XFA_SCRIPT_Basic},
    {0x824f21b7, L"embedPDF",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_EmbedPDF, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Target, XFA_SCRIPT_Basic},
    {0xdc75676c, L"textEncoding",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TextEncoding, XFA_SCRIPT_Basic},
    {0xf889e747, L"xdpContent",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_XdpContent, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x97be91b, L"content",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Packet_Content, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x4156ee3f, L"delimiter",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Delimiter, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x21aed, L"id",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Id, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbb8df5d, L"ref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Ref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x21aed, L"id",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Id, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x453eaf38, L"startNew",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_StartNew, XFA_SCRIPT_Basic},
    {0x9dcc3ab3, L"trailer",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Trailer, XFA_SCRIPT_Basic},
    {0xa6118c89, L"targetType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TargetType, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Target, XFA_SCRIPT_Basic},
    {0xcbcaf66d, L"leader",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Leader, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xabef37e3, L"slope",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Slope, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd996fa9b, L"hand",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Hand, XFA_SCRIPT_Basic},
    {0xa60dd202, L"length",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_NodeList::Script_ListClass_Length, -1,
     XFA_SCRIPT_Basic},
    {0x20146, L"db", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Source_Db, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xb3543a6, L"max", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Occur_Max,
     -1, XFA_SCRIPT_Basic},
    {0xb356ca4, L"min", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Occur_Min,
     -1, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x7d0b5fca, L"initial",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Initial, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x29418bb7, L"abbr",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Abbr, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbb8df5d, L"ref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Ref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0xa5b410cf, L"save",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Save, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xb2c80857, L"className",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Object::Script_ObjectClass_ClassName, -1,
     XFA_SCRIPT_Basic},
    {0xa60dd202, L"length",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_NodeList::Script_ListClass_Length, -1,
     XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0x9f9d0f9, L"all",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_TreeClass_All, -1,
     XFA_SCRIPT_Object},
    {0x4df15659, L"nodes",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_TreeClass_Nodes, -1,
     XFA_SCRIPT_Object},
    {0x78a8d6cf, L"classAll",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_TreeClass_ClassAll, -1,
     XFA_SCRIPT_Object},
    {0xcad6d8ca, L"parent",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_TreeClass_Parent, -1,
     XFA_SCRIPT_Object},
    {0xd5679c78, L"index",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_TreeClass_Index, -1,
     XFA_SCRIPT_Basic},
    {0xdb5b4bce, L"classIndex",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_TreeClass_ClassIndex, -1,
     XFA_SCRIPT_Basic},
    {0xe4989adf, L"somExpression",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_TreeClass_SomExpression, -1,
     XFA_SCRIPT_Basic},
    {0x21aed, L"id",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Id, XFA_SCRIPT_Basic},
    {0x234a1, L"ns", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_NodeClass_Ns,
     -1, XFA_SCRIPT_Basic},
    {0x50d1a9d1, L"model",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_NodeClass_Model, -1,
     XFA_SCRIPT_Object},
    {0xacb4823f, L"isContainer",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_NodeClass_IsContainer, -1,
     XFA_SCRIPT_Basic},
    {0xe372ae97, L"isNull",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_NodeClass_IsNull, -1,
     XFA_SCRIPT_Basic},
    {0xfe612a5b, L"oneOfChild",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_NodeClass_OneOfChild, -1,
     XFA_SCRIPT_Object},
    {0x97c1c65, L"context",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_ModelClass_Context, -1,
     XFA_SCRIPT_Object},
    {0x58be2870, L"aliasNode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_ModelClass_AliasNode, -1,
     XFA_SCRIPT_Object},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
};
const int32_t g_iSomAttributeCount =
    sizeof(g_SomAttributeData) / sizeof(XFA_ATTRIBUTEINFO);
