# Copyright 2015 PDFium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'chromium_code': 1,

    'variables': {
      'clang_use_pdfium_plugins%': 0,
    },
    'clang_use_pdfium_plugins%': '<(clang_use_pdfium_plugins)',

    'pdf_use_skia%': 0,
    'pdf_enable_v8%': 1,
    'pdf_enable_xfa%': 0, # Set to 1 by standalone.gypi in a standalone build.
    'conditions': [
      ['OS=="linux"', {
        'bundle_freetype%': 0,
      }, {  # On Android there's no system FreeType. On Windows and Mac, only a
            # few methods are used from it.
        'bundle_freetype%': 1,
      }],
      ['clang_use_pdfium_plugins==1', {
        'variables': {
          'conditions': [
            ['OS!="win"', {
              'variables': {
                'conditions': [
                  ['OS=="mac" or OS=="ios"', {
                    'clang_lib_path%': '<!(cd <(DEPTH) && pwd -P)/third_party/llvm-build/Release+Asserts/lib/libFindBadConstructs.dylib',
                  }, { # OS != "mac" or OS != "ios"
                    'clang_lib_path%': '<!(cd <(DEPTH) && pwd -P)/third_party/llvm-build/Release+Asserts/lib/libFindBadConstructs.so',
                  }],
                ],
              },
              'clang_dynlib_flags%': '-Xclang -load -Xclang <(clang_lib_path) ',
            }, { # OS == "win"
              # On Windows, the plugin is built directly into clang, so there's
              # no need to load it dynamically.
              'clang_dynlib_flags%': '',
            }],
          ],
          'clang_plugin_args%': '-Xclang -plugin-arg-find-bad-constructs -Xclang check-templates '
          '-Xclang -plugin-arg-find-bad-constructs -Xclang follow-macro-expansion ',
        },
        'clang_pdfium_plugins_flags%':
          '<(clang_dynlib_flags)'
          '-Xclang -add-plugin -Xclang find-bad-constructs <(clang_plugin_args)',
      }],
    ],
  },
  'target_defaults': {
    'defines' : [
      'OPJ_STATIC',
      'PNG_PREFIX',
      'PNG_USE_READ_MACROS',
      'V8_DEPRECATION_WARNINGS',
    ],
    'include_dirs': [
      # This is implicit in GN.
      '<(DEPTH)',
      '.',
      'third_party/freetype/include',
      'third_party/freetype/include/freetype',
    ],
    'conditions': [
      ['pdf_use_skia==1', {
        'defines': ['_SKIA_SUPPORT_'],
      }],
      ['pdf_enable_v8==1', {
        'defines': ['PDF_ENABLE_V8'],
      }],
      ['pdf_enable_xfa==1', {
        'defines': ['PDF_ENABLE_XFA'],
      }],
      ['OS=="linux"', {
        'conditions': [
          ['target_arch=="x64"', {
            'defines' : [ '_FX_CPU_=_FX_X64_', ],
            'cflags': [ '-fPIC', ],
          }],
          ['target_arch=="ia32"', {
            'defines' : [ '_FX_CPU_=_FX_X86_', ],
          }],
        ],
      }],
      ['clang==1 and clang_use_pdfium_plugins==1', {
        'cflags': [
          '<@(clang_pdfium_plugins_flags)',
        ],
      }],
    ],
    'msvs_disabled_warnings': [
      4267,
    ],
  },
  'targets': [
    {
      'target_name': 'pdfium',
      'type': 'static_library',
      'dependencies': [
        'third_party/third_party.gyp:bigint',
        'third_party/third_party.gyp:pdfium_base',
        'fdrm',
        'fpdfdoc',
        'fpdfapi',
        'fpdftext',
        'formfiller',
        'fxcodec',
        'fxcrt',
        'fxedit',
        'fxge',
        'javascript',
        'pdfwindow',
      ],
      'sources': [
        'fpdfsdk/cfx_systemhandler.cpp',
        'fpdfsdk/cfx_systemhandler.h',
        'fpdfsdk/include/fsdk_actionhandler.h',
        'fpdfsdk/include/fsdk_annothandler.h',
        'fpdfsdk/include/fsdk_baseannot.h',
        'fpdfsdk/include/fsdk_baseform.h',
        'fpdfsdk/fpdfdoc.cpp',
        'fpdfsdk/fpdfeditimg.cpp',
        'fpdfsdk/fpdfeditpage.cpp',
        'fpdfsdk/fpdfformfill.cpp',
        'fpdfsdk/fpdfppo.cpp',
        'fpdfsdk/fpdfsave.cpp',
        'fpdfsdk/fpdftext.cpp',
        'fpdfsdk/fpdfview.cpp',
        'fpdfsdk/fpdf_dataavail.cpp',
        'fpdfsdk/fpdf_ext.cpp',
        'fpdfsdk/fpdf_flatten.cpp',
        'fpdfsdk/fpdf_progressive.cpp',
        'fpdfsdk/fpdf_searchex.cpp',
        'fpdfsdk/fpdf_sysfontinfo.cpp',
        'fpdfsdk/fpdf_transformpage.cpp',
        'fpdfsdk/fsdk_actionhandler.cpp',
        'fpdfsdk/fsdk_annothandler.cpp',
        'fpdfsdk/fsdk_baseannot.cpp',
        'fpdfsdk/fsdk_baseform.cpp',
        'fpdfsdk/fsdk_mgr.cpp',
        'fpdfsdk/fsdk_rendercontext.cpp',
        'public/fpdf_dataavail.h',
        'public/fpdf_doc.h',
        'public/fpdf_edit.h',
        'public/fpdf_ext.h',
        'public/fpdf_flatten.h',
        'public/fpdf_formfill.h',
        'public/fpdf_fwlevent.h',
        'public/fpdf_ppo.h',
        'public/fpdf_progressive.h',
        'public/fpdf_save.h',
        'public/fpdf_searchex.h',
        'public/fpdf_sysfontinfo.h',
        'public/fpdf_text.h',
        'public/fpdf_transformpage.h',
        'public/fpdfview.h',
      ],
      'conditions': [
        ['pdf_enable_xfa==1', {
          'dependencies': [
            'fpdfxfa',
           ],
        }],
        ['bundle_freetype==1', {
          'dependencies': [
            'third_party/third_party.gyp:fx_freetype',
          ],
        }, {
          'link_settings': {
            'libraries': [
              '-lfreetype',
            ],
          },
        }],
      ],
      'all_dependent_settings': {
        'msvs_settings': {
          'VCLinkerTool': {
            'AdditionalDependencies': [
              'advapi32.lib',
              'gdi32.lib',
              'user32.lib',
            ],
          },
        },
        'conditions': [
          ['OS=="mac"', {
            'link_settings': {
              'libraries': [
                '$(SDKROOT)/System/Library/Frameworks/AppKit.framework',
                '$(SDKROOT)/System/Library/Frameworks/CoreFoundation.framework',
              ],
            },
          }],
        ],
      },
    },
    {
      'target_name': 'fdrm',
      'type': 'static_library',
      'sources': [
        'core/fdrm/crypto/include/fx_crypt.h',
        'core/fdrm/crypto/fx_crypt.cpp',
        'core/fdrm/crypto/fx_crypt_aes.cpp',
        'core/fdrm/crypto/fx_crypt_sha.cpp',
      ],
    },
    {
      'target_name': 'fpdfdoc',
      'type': 'static_library',
      'sources': [
        'core/fpdfdoc/clines.cpp',
        'core/fpdfdoc/clines.h',
        'core/fpdfdoc/include/fpdf_doc.h',
        'core/fpdfdoc/include/fpdf_tagged.h',
        'core/fpdfdoc/cpdf_variabletext.cpp',
        'core/fpdfdoc/cpvt_color.cpp',
        'core/fpdfdoc/cpvt_color.h',
        'core/fpdfdoc/cpvt_dash.h',
        'core/fpdfdoc/cpvt_floatrect.h',
        'core/fpdfdoc/cpvt_fontmap.cpp',
        'core/fpdfdoc/cpvt_fontmap.h',
        'core/fpdfdoc/cpvt_generateap.cpp',
        'core/fpdfdoc/cpvt_generateap.h',
        'core/fpdfdoc/cpvt_lineinfo.h',
        'core/fpdfdoc/cpvt_sectioninfo.h',
        'core/fpdfdoc/cpvt_wordinfo.h',
        'core/fpdfdoc/csection.cpp',
        'core/fpdfdoc/csection.h',
        'core/fpdfdoc/ctypeset.cpp',
        'core/fpdfdoc/ctypeset.h',
        'core/fpdfdoc/doc_action.cpp',
        'core/fpdfdoc/doc_annot.cpp',
        'core/fpdfdoc/doc_basic.cpp',
        'core/fpdfdoc/doc_bookmark.cpp',
        'core/fpdfdoc/doc_form.cpp',
        'core/fpdfdoc/doc_formcontrol.cpp',
        'core/fpdfdoc/doc_formfield.cpp',
        'core/fpdfdoc/doc_link.cpp',
        'core/fpdfdoc/doc_metadata.cpp',
        'core/fpdfdoc/doc_ocg.cpp',
        'core/fpdfdoc/doc_tagged.cpp',
        'core/fpdfdoc/doc_utils.cpp',
        'core/fpdfdoc/doc_utils.h',
        'core/fpdfdoc/doc_viewerPreferences.cpp',
        'core/fpdfdoc/doc_vt.cpp',
        'core/fpdfdoc/include/cpdf_variabletext.h',
        'core/fpdfdoc/include/cpvt_line.h',
        'core/fpdfdoc/include/cpvt_secprops.h',
        'core/fpdfdoc/include/cpvt_section.h',
        'core/fpdfdoc/include/cpvt_word.h',
        'core/fpdfdoc/include/cpvt_wordplace.h',
        'core/fpdfdoc/include/cpvt_wordprops.h',
        'core/fpdfdoc/include/cpvt_wordrange.h',
        'core/fpdfdoc/include/ipvt_fontmap.h',
        'core/fpdfdoc/pdf_vt.h',
        'core/fpdfdoc/tagged_int.h',
      ],
    },
    {
      'target_name': 'fpdfapi',
      'type': 'static_library',
      'sources': [
        'core/fpdfapi/cpdf_modulemgr.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/Adobe-CNS1-UCS2_5.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/B5pc-H_0.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/B5pc-V_0.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/CNS-EUC-H_0.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/CNS-EUC-V_0.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/ETen-B5-H_0.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/ETen-B5-V_0.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/ETenms-B5-H_0.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/ETenms-B5-V_0.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/HKscs-B5-H_5.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/HKscs-B5-V_5.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/UniCNS-UCS2-H_3.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/UniCNS-UCS2-V_3.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/UniCNS-UTF16-H_0.cpp',
        'core/fpdfapi/fpdf_cmaps/CNS1/cmaps_cns1.cpp',
        'core/fpdfapi/fpdf_cmaps/GB1/Adobe-GB1-UCS2_5.cpp',
        'core/fpdfapi/fpdf_cmaps/GB1/GB-EUC-H_0.cpp',
        'core/fpdfapi/fpdf_cmaps/GB1/GB-EUC-V_0.cpp',
        'core/fpdfapi/fpdf_cmaps/GB1/GBK-EUC-H_2.cpp',
        'core/fpdfapi/fpdf_cmaps/GB1/GBK-EUC-V_2.cpp',
        'core/fpdfapi/fpdf_cmaps/GB1/GBK2K-H_5.cpp',
        'core/fpdfapi/fpdf_cmaps/GB1/GBK2K-V_5.cpp',
        'core/fpdfapi/fpdf_cmaps/GB1/GBKp-EUC-H_2.cpp',
        'core/fpdfapi/fpdf_cmaps/GB1/GBKp-EUC-V_2.cpp',
        'core/fpdfapi/fpdf_cmaps/GB1/GBpc-EUC-H_0.cpp',
        'core/fpdfapi/fpdf_cmaps/GB1/GBpc-EUC-V_0.cpp',
        'core/fpdfapi/fpdf_cmaps/GB1/UniGB-UCS2-H_4.cpp',
        'core/fpdfapi/fpdf_cmaps/GB1/UniGB-UCS2-V_4.cpp',
        'core/fpdfapi/fpdf_cmaps/GB1/cmaps_gb1.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/83pv-RKSJ-H_1.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/90ms-RKSJ-H_2.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/90ms-RKSJ-V_2.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/90msp-RKSJ-H_2.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/90msp-RKSJ-V_2.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/90pv-RKSJ-H_1.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/Add-RKSJ-H_1.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/Add-RKSJ-V_1.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/Adobe-Japan1-UCS2_4.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/EUC-H_1.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/EUC-V_1.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/Ext-RKSJ-H_2.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/Ext-RKSJ-V_2.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/H_1.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/UniJIS-UCS2-HW-H_4.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/UniJIS-UCS2-HW-V_4.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/UniJIS-UCS2-H_4.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/UniJIS-UCS2-V_4.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/V_1.cpp',
        'core/fpdfapi/fpdf_cmaps/Japan1/cmaps_japan1.cpp',
        'core/fpdfapi/fpdf_cmaps/Korea1/Adobe-Korea1-UCS2_2.cpp',
        'core/fpdfapi/fpdf_cmaps/Korea1/KSC-EUC-H_0.cpp',
        'core/fpdfapi/fpdf_cmaps/Korea1/KSC-EUC-V_0.cpp',
        'core/fpdfapi/fpdf_cmaps/Korea1/KSCms-UHC-HW-H_1.cpp',
        'core/fpdfapi/fpdf_cmaps/Korea1/KSCms-UHC-HW-V_1.cpp',
        'core/fpdfapi/fpdf_cmaps/Korea1/KSCms-UHC-H_1.cpp',
        'core/fpdfapi/fpdf_cmaps/Korea1/KSCms-UHC-V_1.cpp',
        'core/fpdfapi/fpdf_cmaps/Korea1/KSCpc-EUC-H_0.cpp',
        'core/fpdfapi/fpdf_cmaps/Korea1/UniKS-UCS2-H_1.cpp',
        'core/fpdfapi/fpdf_cmaps/Korea1/UniKS-UCS2-V_1.cpp',
        'core/fpdfapi/fpdf_cmaps/Korea1/UniKS-UTF16-H_0.cpp',
        'core/fpdfapi/fpdf_cmaps/Korea1/cmaps_korea1.cpp',
        'core/fpdfapi/fpdf_cmaps/cmap_int.h',
        'core/fpdfapi/fpdf_cmaps/fpdf_cmaps.cpp',
        'core/fpdfapi/fpdf_edit/cpdf_pagecontentgenerator.cpp',
        'core/fpdfapi/fpdf_edit/editint.h',
        'core/fpdfapi/fpdf_edit/fpdf_edit_create.cpp',
        'core/fpdfapi/fpdf_edit/include/cpdf_creator.h',
        'core/fpdfapi/fpdf_edit/include/cpdf_pagecontentgenerator.h',
        'core/fpdfapi/fpdf_font/cpdf_cidfont.cpp',
        'core/fpdfapi/fpdf_font/cpdf_cidfont.h',
        'core/fpdfapi/fpdf_font/cpdf_font.cpp',
        'core/fpdfapi/fpdf_font/cpdf_fontencoding.cpp',
        'core/fpdfapi/fpdf_font/cpdf_simplefont.cpp',
        'core/fpdfapi/fpdf_font/cpdf_simplefont.h',
        'core/fpdfapi/fpdf_font/cpdf_truetypefont.cpp',
        'core/fpdfapi/fpdf_font/cpdf_truetypefont.h',
        'core/fpdfapi/fpdf_font/cpdf_type1font.cpp',
        'core/fpdfapi/fpdf_font/cpdf_type1font.h',
        'core/fpdfapi/fpdf_font/cpdf_type3char.cpp',
        'core/fpdfapi/fpdf_font/cpdf_type3char.h',
        'core/fpdfapi/fpdf_font/cpdf_type3font.cpp',
        'core/fpdfapi/fpdf_font/cpdf_type3font.h',
        'core/fpdfapi/fpdf_font/font_int.h',
        'core/fpdfapi/fpdf_font/fpdf_font.cpp',
        'core/fpdfapi/fpdf_font/fpdf_font_cid.cpp',
        'core/fpdfapi/fpdf_font/include/cpdf_font.h',
        'core/fpdfapi/fpdf_font/include/cpdf_fontencoding.h',
        'core/fpdfapi/fpdf_font/ttgsubtable.cpp',
        'core/fpdfapi/fpdf_font/ttgsubtable.h',
        'core/fpdfapi/fpdf_page/cpdf_allstates.cpp',
        'core/fpdfapi/fpdf_page/cpdf_allstates.h',
        'core/fpdfapi/fpdf_page/cpdf_clippath.cpp',
        'core/fpdfapi/fpdf_page/cpdf_clippathdata.cpp',
        'core/fpdfapi/fpdf_page/cpdf_clippathdata.h',
        'core/fpdfapi/fpdf_page/cpdf_color.cpp',
        'core/fpdfapi/fpdf_page/cpdf_colorspace.cpp',
        'core/fpdfapi/fpdf_page/cpdf_colorstate.cpp',
        'core/fpdfapi/fpdf_page/cpdf_colorstate.h',
        'core/fpdfapi/fpdf_page/cpdf_colorstatedata.cpp',
        'core/fpdfapi/fpdf_page/cpdf_colorstatedata.h',
        'core/fpdfapi/fpdf_page/cpdf_contentmark.cpp',
        'core/fpdfapi/fpdf_page/cpdf_contentmark.h',
        'core/fpdfapi/fpdf_page/cpdf_contentmarkdata.cpp',
        'core/fpdfapi/fpdf_page/cpdf_contentmarkdata.h',
        'core/fpdfapi/fpdf_page/cpdf_contentmarkitem.cpp',
        'core/fpdfapi/fpdf_page/cpdf_contentmarkitem.h',
        'core/fpdfapi/fpdf_page/cpdf_countedobject.h',
        'core/fpdfapi/fpdf_page/cpdf_form.cpp',
        'core/fpdfapi/fpdf_page/cpdf_formobject.cpp',
        'core/fpdfapi/fpdf_page/cpdf_generalstate.cpp',
        'core/fpdfapi/fpdf_page/cpdf_generalstatedata.cpp',
        'core/fpdfapi/fpdf_page/cpdf_graphicstates.cpp',
        'core/fpdfapi/fpdf_page/cpdf_graphicstates.h',
        'core/fpdfapi/fpdf_page/cpdf_graphstate.h',
        'core/fpdfapi/fpdf_page/cpdf_image.cpp',
        'core/fpdfapi/fpdf_page/cpdf_imageobject.cpp',
        'core/fpdfapi/fpdf_page/cpdf_meshstream.cpp',
        'core/fpdfapi/fpdf_page/cpdf_meshstream.h',
        'core/fpdfapi/fpdf_page/cpdf_page.cpp',
        'core/fpdfapi/fpdf_page/cpdf_pagemodule.cpp',
        'core/fpdfapi/fpdf_page/cpdf_pagemodule.h',
        'core/fpdfapi/fpdf_page/cpdf_pageobject.cpp',
        'core/fpdfapi/fpdf_page/cpdf_pageobjectholder.cpp',
        'core/fpdfapi/fpdf_page/cpdf_pageobjectlist.cpp',
        'core/fpdfapi/fpdf_page/cpdf_pageobjectlist.h',
        'core/fpdfapi/fpdf_page/cpdf_pathobject.cpp',
        'core/fpdfapi/fpdf_page/cpdf_pattern.cpp',
        'core/fpdfapi/fpdf_page/cpdf_pattern.h',
        'core/fpdfapi/fpdf_page/cpdf_shadingobject.cpp',
        'core/fpdfapi/fpdf_page/cpdf_shadingpattern.cpp',
        'core/fpdfapi/fpdf_page/cpdf_shadingpattern.h',
        'core/fpdfapi/fpdf_page/cpdf_textobject.cpp',
        'core/fpdfapi/fpdf_page/cpdf_textstate.cpp',
        'core/fpdfapi/fpdf_page/cpdf_textstate.h',
        'core/fpdfapi/fpdf_page/cpdf_textstatedata.cpp',
        'core/fpdfapi/fpdf_page/cpdf_tilingpattern.cpp',
        'core/fpdfapi/fpdf_page/cpdf_tilingpattern.h',
        'core/fpdfapi/fpdf_page/fpdf_page_colors.cpp',
        'core/fpdfapi/fpdf_page/fpdf_page_doc.cpp',
        'core/fpdfapi/fpdf_page/fpdf_page_func.cpp',
        'core/fpdfapi/fpdf_page/fpdf_page_parser.cpp',
        'core/fpdfapi/fpdf_page/fpdf_page_parser_old.cpp',
        'core/fpdfapi/fpdf_page/include/cpdf_clippath.h',
        'core/fpdfapi/fpdf_page/include/cpdf_color.h',
        'core/fpdfapi/fpdf_page/include/cpdf_colorspace.h',
        'core/fpdfapi/fpdf_page/include/cpdf_form.h',
        'core/fpdfapi/fpdf_page/include/cpdf_formobject.h',
        'core/fpdfapi/fpdf_page/include/cpdf_generalstatedata.h',
        'core/fpdfapi/fpdf_page/include/cpdf_image.h',
        'core/fpdfapi/fpdf_page/include/cpdf_imageobject.h',
        'core/fpdfapi/fpdf_page/include/cpdf_page.h',
        'core/fpdfapi/fpdf_page/include/cpdf_pageobject.h',
        'core/fpdfapi/fpdf_page/include/cpdf_pageobjectholder.h',
        'core/fpdfapi/fpdf_page/include/cpdf_path.h',
        'core/fpdfapi/fpdf_page/include/cpdf_pathobject.h',
        'core/fpdfapi/fpdf_page/include/cpdf_shadingobject.h',
        'core/fpdfapi/fpdf_page/include/cpdf_textobject.h',
        'core/fpdfapi/fpdf_page/include/cpdf_textstatedata.h',
        'core/fpdfapi/fpdf_page/pageint.h',
        'core/fpdfapi/fpdf_parser/cfdf_document.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_array.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_boolean.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_boolean.h',
        'core/fpdfapi/fpdf_parser/cpdf_crypto_handler.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_crypto_handler.h',
        'core/fpdfapi/fpdf_parser/cpdf_data_avail.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_dictionary.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_document.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_hint_tables.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_hint_tables.h',
        'core/fpdfapi/fpdf_parser/cpdf_indirect_object_holder.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_name.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_null.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_null.h',
        'core/fpdfapi/fpdf_parser/cpdf_number.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_object.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_parser.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_reference.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_security_handler.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_security_handler.h',
        'core/fpdfapi/fpdf_parser/cpdf_simple_parser.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_stream.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_stream_acc.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_string.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_syntax_parser.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_syntax_parser.h',
        'core/fpdfapi/fpdf_parser/fpdf_parser_decode.cpp',
        'core/fpdfapi/fpdf_parser/fpdf_parser_utility.cpp',
        'core/fpdfapi/fpdf_parser/fpdf_parser_utility.h',
        'core/fpdfapi/fpdf_parser/include/cfdf_document.h',
        'core/fpdfapi/fpdf_parser/include/cpdf_array.h',
        'core/fpdfapi/fpdf_parser/include/cpdf_data_avail.h',
        'core/fpdfapi/fpdf_parser/include/cpdf_dictionary.h',
        'core/fpdfapi/fpdf_parser/include/cpdf_document.h',
        'core/fpdfapi/fpdf_parser/include/cpdf_indirect_object_holder.h',
        'core/fpdfapi/fpdf_parser/include/cpdf_name.h',
        'core/fpdfapi/fpdf_parser/include/cpdf_number.h',
        'core/fpdfapi/fpdf_parser/include/cpdf_object.h',
        'core/fpdfapi/fpdf_parser/include/cpdf_parser.h',
        'core/fpdfapi/fpdf_parser/include/cpdf_reference.h',
        'core/fpdfapi/fpdf_parser/include/cpdf_simple_parser.h',
        'core/fpdfapi/fpdf_parser/include/cpdf_stream.h',
        'core/fpdfapi/fpdf_parser/include/cpdf_stream_acc.h',
        'core/fpdfapi/fpdf_parser/include/cpdf_string.h',
        'core/fpdfapi/fpdf_parser/include/fpdf_parser_decode.h',
        'core/fpdfapi/fpdf_render/cpdf_pagerendercache.h',
        'core/fpdfapi/fpdf_render/fpdf_render.cpp',
        'core/fpdfapi/fpdf_render/fpdf_render_cache.cpp',
        'core/fpdfapi/fpdf_render/fpdf_render_image.cpp',
        'core/fpdfapi/fpdf_render/fpdf_render_loadimage.cpp',
        'core/fpdfapi/fpdf_render/fpdf_render_pattern.cpp',
        'core/fpdfapi/fpdf_render/fpdf_render_text.cpp',
        'core/fpdfapi/fpdf_render/include/cpdf_progressiverenderer.h',
        'core/fpdfapi/fpdf_render/include/cpdf_rendercontext.h',
        'core/fpdfapi/fpdf_render/include/cpdf_renderoptions.h',
        'core/fpdfapi/fpdf_render/include/cpdf_textrenderer.h',
        'core/fpdfapi/fpdf_render/render_int.h',
        'core/fpdfapi/include/cpdf_modulemgr.h',
      ],
    },
    {
      'target_name': 'fpdftext',
      'type': 'static_library',
      'sources': [
        'core/fpdftext/include/cpdf_linkextract.h',
        'core/fpdftext/include/cpdf_textpage.h',
        'core/fpdftext/include/cpdf_textpagefind.h',
        'core/fpdftext/fpdf_text_int.cpp',
        'core/fpdftext/unicodenormalizationdata.cpp',
        'core/fpdftext/unicodenormalizationdata.h',
      ],
    },
    {
      'target_name': 'fxcodec',
      'type': 'static_library',
      'dependencies': [
        '<(libjpeg_gyp_path):libjpeg',
        'third_party/third_party.gyp:fx_lcms2',
        'third_party/third_party.gyp:fx_libopenjpeg',
        'third_party/third_party.gyp:fx_zlib',
      ],
      'sources': [
        'core/fxcodec/include/fx_codec.h',
        'core/fxcodec/include/fx_codec_def.h',
        'core/fxcodec/codec/ccodec_basicmodule.h',
        'core/fxcodec/codec/ccodec_faxmodule.h',
        'core/fxcodec/codec/ccodec_flatemodule.h',
        'core/fxcodec/codec/ccodec_iccmodule.h',
        'core/fxcodec/codec/ccodec_jbig2module.h',
        'core/fxcodec/codec/ccodec_jpegmodule.h',
        'core/fxcodec/codec/ccodec_jpxmodule.h',
        'core/fxcodec/codec/ccodec_scanlinedecoder.h',
        'core/fxcodec/codec/codec_int.h',
        'core/fxcodec/codec/fx_codec.cpp',
        'core/fxcodec/codec/fx_codec_fax.cpp',
        'core/fxcodec/codec/fx_codec_flate.cpp',
        'core/fxcodec/codec/fx_codec_icc.cpp',
        'core/fxcodec/codec/fx_codec_jbig.cpp',
        'core/fxcodec/codec/fx_codec_jpeg.cpp',
        'core/fxcodec/codec/fx_codec_jpx_opj.cpp',
        'core/fxcodec/jbig2/JBig2_ArithDecoder.cpp',
        'core/fxcodec/jbig2/JBig2_ArithDecoder.h',
        'core/fxcodec/jbig2/JBig2_ArithIntDecoder.cpp',
        'core/fxcodec/jbig2/JBig2_ArithIntDecoder.h',
        'core/fxcodec/jbig2/JBig2_BitStream.cpp',
        'core/fxcodec/jbig2/JBig2_BitStream.h',
        'core/fxcodec/jbig2/JBig2_Context.cpp',
        'core/fxcodec/jbig2/JBig2_Context.h',
        'core/fxcodec/jbig2/JBig2_Define.h',
        'core/fxcodec/jbig2/JBig2_GrdProc.cpp',
        'core/fxcodec/jbig2/JBig2_GrdProc.h',
        'core/fxcodec/jbig2/JBig2_GrrdProc.cpp',
        'core/fxcodec/jbig2/JBig2_GrrdProc.h',
        'core/fxcodec/jbig2/JBig2_GsidProc.cpp',
        'core/fxcodec/jbig2/JBig2_GsidProc.h',
        'core/fxcodec/jbig2/JBig2_HtrdProc.cpp',
        'core/fxcodec/jbig2/JBig2_HtrdProc.h',
        'core/fxcodec/jbig2/JBig2_HuffmanDecoder.cpp',
        'core/fxcodec/jbig2/JBig2_HuffmanDecoder.h',
        'core/fxcodec/jbig2/JBig2_HuffmanTable.cpp',
        'core/fxcodec/jbig2/JBig2_HuffmanTable.h',
        'core/fxcodec/jbig2/JBig2_HuffmanTable_Standard.cpp',
        'core/fxcodec/jbig2/JBig2_HuffmanTable_Standard.h',
        'core/fxcodec/jbig2/JBig2_Image.cpp',
        'core/fxcodec/jbig2/JBig2_Image.h',
        'core/fxcodec/jbig2/JBig2_List.h',
        'core/fxcodec/jbig2/JBig2_Page.h',
        'core/fxcodec/jbig2/JBig2_PatternDict.cpp',
        'core/fxcodec/jbig2/JBig2_PatternDict.h',
        'core/fxcodec/jbig2/JBig2_PddProc.cpp',
        'core/fxcodec/jbig2/JBig2_PddProc.h',
        'core/fxcodec/jbig2/JBig2_SddProc.cpp',
        'core/fxcodec/jbig2/JBig2_SddProc.h',
        'core/fxcodec/jbig2/JBig2_Segment.cpp',
        'core/fxcodec/jbig2/JBig2_Segment.h',
        'core/fxcodec/jbig2/JBig2_SymbolDict.cpp',
        'core/fxcodec/jbig2/JBig2_SymbolDict.h',
        'core/fxcodec/jbig2/JBig2_TrdProc.cpp',
        'core/fxcodec/jbig2/JBig2_TrdProc.h',
      ],
      'msvs_settings': {
        'VCCLCompilerTool': {
          # Unresolved warnings in fx_codec_jpx_opj.cpp
          # https://code.google.com/p/pdfium/issues/detail?id=100
          'WarnAsError': 'false',
        },
      },
      'conditions': [
        ['pdf_enable_xfa==1', {
          'dependencies': [
            'third_party/third_party.gyp:fx_lpng',
            'third_party/third_party.gyp:fx_tiff',
          ],
          'sources': [
            'core/fxcodec/codec/ccodec_bmpmodule.h',
            'core/fxcodec/codec/ccodec_gifmodule.h',
            'core/fxcodec/codec/ccodec_pngmodule.h',
            'core/fxcodec/codec/ccodec_tiffmodule.h',
            'core/fxcodec/codec/fx_codec_bmp.cpp',
            'core/fxcodec/codec/fx_codec_gif.cpp',
            'core/fxcodec/codec/fx_codec_png.cpp',
            'core/fxcodec/codec/fx_codec_progress.cpp',
            'core/fxcodec/codec/fx_codec_tiff.cpp',
            'core/fxcodec/codec/include/ccodec_progressivedecoder.h',
            'core/fxcodec/lbmp/fx_bmp.cpp',
            'core/fxcodec/lbmp/fx_bmp.h',
            'core/fxcodec/lgif/fx_gif.cpp',
            'core/fxcodec/lgif/fx_gif.h',
          ],
        }],
        ['os_posix==1', {
          # core/fxcodec/fx_libopenjpeg/src/fx_mct.c does an pointer-to-int
          # conversion to check that an address is 16-bit aligned (benign).
          'cflags_c': [ '-Wno-pointer-to-int-cast' ],
        }],
      ],
    },
    {
      'target_name': 'fxcrt',
      'type': 'static_library',
      'sources': [
        'core/fxcrt/cfx_string_c_template.h',
        'core/fxcrt/cfx_string_data_template.h',
        'core/fxcrt/extension.h',
        'core/fxcrt/fx_basic_array.cpp',
        'core/fxcrt/fx_basic_bstring.cpp',
        'core/fxcrt/fx_basic_buffer.cpp',
        'core/fxcrt/fx_basic_coords.cpp',
        'core/fxcrt/fx_basic_gcc.cpp',
        'core/fxcrt/fx_basic_list.cpp',
        'core/fxcrt/fx_basic_memmgr.cpp',
        'core/fxcrt/fx_basic_plex.cpp',
        'core/fxcrt/fx_basic_utf.cpp',
        'core/fxcrt/fx_basic_util.cpp',
        'core/fxcrt/fx_basic_wstring.cpp',
        'core/fxcrt/fx_bidi.cpp',
        'core/fxcrt/fx_bidi.h',
        'core/fxcrt/fx_extension.cpp',
        'core/fxcrt/fx_ucddata.cpp',
        'core/fxcrt/fx_unicode.cpp',
        'core/fxcrt/fx_xml_composer.cpp',
        'core/fxcrt/fx_xml_parser.cpp',
        'core/fxcrt/fxcrt_posix.cpp',
        'core/fxcrt/fxcrt_posix.h',
        'core/fxcrt/fxcrt_stream.cpp',
        'core/fxcrt/fxcrt_windows.cpp',
        'core/fxcrt/fxcrt_windows.h',
        'core/fxcrt/include/cfx_retain_ptr.h',
        'core/fxcrt/include/fx_basic.h',
        'core/fxcrt/include/fx_coordinates.h',
        'core/fxcrt/include/fx_ext.h',
        'core/fxcrt/include/fx_memory.h',
        'core/fxcrt/include/fx_safe_types.h',
        'core/fxcrt/include/fx_stream.h',
        'core/fxcrt/include/fx_string.h',
        'core/fxcrt/include/fx_system.h',
        'core/fxcrt/include/fx_ucd.h',
        'core/fxcrt/include/fx_xml.h',
        'core/fxcrt/plex.h',
        'core/fxcrt/xml_int.h',
      ],
      'conditions': [
        ['pdf_enable_xfa==1', {
          'sources': [
            'core/fxcrt/fx_arabic.cpp',
            'core/fxcrt/fx_basic_maps.cpp',
            'core/fxcrt/include/fx_arabic.h',
            'core/fxcrt/include/fx_arb.h',
          ],
        }],
      ],
    },
    {
      'target_name': 'fxge',
      'type': 'static_library',
      'dependencies': [
        'third_party/third_party.gyp:fx_agg',
      ],
      'sources': [
        'core/fxge/agg/fx_agg_driver.h',
        'core/fxge/agg/fx_agg_driver.cpp',
        'core/fxge/android/fpf_skiafont.cpp',
        'core/fxge/android/fpf_skiafont.h',
        'core/fxge/android/fpf_skiafontmgr.cpp',
        'core/fxge/android/fpf_skiafontmgr.h',
        'core/fxge/android/fpf_skiamodule.cpp',
        'core/fxge/android/fpf_skiamodule.h',
        'core/fxge/android/fx_android_font.cpp',
        'core/fxge/android/fx_android_font.h',
        'core/fxge/android/fx_android_imp.cpp',
        'core/fxge/apple/apple_int.h',
        'core/fxge/apple/fx_apple_platform.cpp',
        'core/fxge/apple/fx_mac_imp.cpp',
        'core/fxge/apple/fx_quartz_device.cpp',
        'core/fxge/dib/dib_int.h',
        'core/fxge/dib/fx_dib_composite.cpp',
        'core/fxge/dib/fx_dib_convert.cpp',
        'core/fxge/dib/fx_dib_engine.cpp',
        'core/fxge/dib/fx_dib_main.cpp',
        'core/fxge/dib/fx_dib_transform.cpp',
        'core/fxge/fontdata/chromefontdata/chromefontdata.h',
        'core/fxge/fontdata/chromefontdata/FoxitDingbats.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitFixed.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitFixedBold.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitFixedBoldItalic.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitFixedItalic.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitSans.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitSansBold.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitSansBoldItalic.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitSansItalic.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitSansMM.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitSerif.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitSerifBold.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitSerifBoldItalic.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitSerifItalic.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitSerifMM.cpp',
        'core/fxge/fontdata/chromefontdata/FoxitSymbol.cpp',
        'core/fxge/freetype/fx_freetype.cpp',
        'core/fxge/ge/fx_ge.cpp',
        'core/fxge/ge/fx_ge_device.cpp',
        'core/fxge/ge/fx_ge_font.cpp',
        'core/fxge/ge/fx_ge_fontmap.cpp',
        'core/fxge/ge/fx_ge_linux.cpp',
        'core/fxge/ge/fx_ge_path.cpp',
        'core/fxge/ge/fx_ge_text.cpp',
        'core/fxge/ge/fx_text_int.h',
        'core/fxge/ifx_renderdevicedriver.cpp',
        'core/fxge/include/fx_dib.h',
        'core/fxge/include/fx_font.h',
        'core/fxge/include/fx_freetype.h',
        'core/fxge/include/fx_ge.h',
        'core/fxge/include/fx_ge_apple.h',
        'core/fxge/include/fx_ge_win32.h',
        'core/fxge/include/ifx_renderdevicedriver.h',
      ],
      'variables': {
        'clang_warning_flags': [
          # http://code.google.com/p/pdfium/issues/detail?id=188
          '-Wno-switch',
        ],
      },
      'conditions': [
        ['pdf_use_skia==1', {
          'sources': [
            'core/fxge/skia/fx_skia_device.cpp',
          ],
          'sources!': [
            'core/fxge/agg/fx_agg_driver.h',
            'core/fxge/agg/fx_agg_driver.cpp',
          ],
          'dependencies': [
            '<(DEPTH)/skia/skia.gyp:skia',
          ],
          'dependencies!': [
            'third_party/third_party.gyp:fx_agg',
          ],
        }],
        ['OS=="win"', {
          'defines!': [
            'WIN32_LEAN_AND_MEAN'
          ],
          'sources': [
            'core/fxge/win32/dwrite_int.h',
            'core/fxge/win32/fx_win32_device.cpp',
            'core/fxge/win32/fx_win32_dib.cpp',
            'core/fxge/win32/fx_win32_dwrite.cpp',
            'core/fxge/win32/fx_win32_gdipext.cpp',
            'core/fxge/win32/fx_win32_print.cpp',
            'core/fxge/win32/win32_int.h',
          ],
        }],
      ],
    },
    {
      'target_name': 'fxedit',
      'type': 'static_library',
      'sources': [
        'fpdfsdk/fxedit/include/fx_edit.h',
        'fpdfsdk/fxedit/include/fxet_edit.h',
        'fpdfsdk/fxedit/include/fxet_list.h',
        'fpdfsdk/fxedit/fxet_ap.cpp',
        'fpdfsdk/fxedit/fxet_edit.cpp',
        'fpdfsdk/fxedit/fxet_list.cpp',
        'fpdfsdk/fxedit/fxet_module.cpp',
        'fpdfsdk/fxedit/fxet_pageobjs.cpp',
      ],
    },
    {
      'target_name': 'pdfwindow',
      'type': 'static_library',
      'sources': [
        'fpdfsdk/pdfwindow/PWL_Button.cpp',
        'fpdfsdk/pdfwindow/PWL_Button.h',
        'fpdfsdk/pdfwindow/PWL_Caret.cpp',
        'fpdfsdk/pdfwindow/PWL_Caret.h',
        'fpdfsdk/pdfwindow/PWL_ComboBox.cpp',
        'fpdfsdk/pdfwindow/PWL_ComboBox.h',
        'fpdfsdk/pdfwindow/PWL_Edit.cpp',
        'fpdfsdk/pdfwindow/PWL_Edit.h',
        'fpdfsdk/pdfwindow/PWL_EditCtrl.cpp',
        'fpdfsdk/pdfwindow/PWL_EditCtrl.h',
        'fpdfsdk/pdfwindow/PWL_FontMap.cpp',
        'fpdfsdk/pdfwindow/PWL_FontMap.h',
        'fpdfsdk/pdfwindow/PWL_Icon.cpp',
        'fpdfsdk/pdfwindow/PWL_Icon.h',
        'fpdfsdk/pdfwindow/PWL_ListBox.cpp',
        'fpdfsdk/pdfwindow/PWL_ListBox.h',
        'fpdfsdk/pdfwindow/PWL_ScrollBar.cpp',
        'fpdfsdk/pdfwindow/PWL_ScrollBar.h',
        'fpdfsdk/pdfwindow/PWL_SpecialButton.cpp',
        'fpdfsdk/pdfwindow/PWL_SpecialButton.h',
        'fpdfsdk/pdfwindow/PWL_Utils.cpp',
        'fpdfsdk/pdfwindow/PWL_Utils.h',
        'fpdfsdk/pdfwindow/PWL_Wnd.cpp',
        'fpdfsdk/pdfwindow/PWL_Wnd.h',
      ],
    },
    {
      'target_name': 'javascript',
      'type': 'static_library',
      'sources': [
        'fpdfsdk/javascript/ijs_context.h',
        'fpdfsdk/javascript/ijs_runtime.h',
        'fpdfsdk/javascript/JS_Runtime_Stub.cpp',
      ],
      'conditions': [
        ['pdf_enable_v8==1', {
          'include_dirs': [
            '<(DEPTH)/v8',
            '<(DEPTH)/v8/include',
          ],
          'dependencies': [
            '<(DEPTH)/v8/src/v8.gyp:v8',
          ],
          'export_dependent_settings': [
            '<(DEPTH)/v8/src/v8.gyp:v8',
          ],
          'sources!': [
            'fpdfsdk/javascript/JS_Runtime_Stub.cpp',
          ],
          'sources': [
            'fpdfsdk/javascript/Consts.cpp',
            'fpdfsdk/javascript/Consts.h',
            'fpdfsdk/javascript/Document.cpp',
            'fpdfsdk/javascript/Document.h',
            'fpdfsdk/javascript/Field.cpp',
            'fpdfsdk/javascript/Field.h',
            'fpdfsdk/javascript/Icon.cpp',
            'fpdfsdk/javascript/Icon.h',
            'fpdfsdk/javascript/JS_Define.h',
            'fpdfsdk/javascript/JS_EventHandler.cpp',
            'fpdfsdk/javascript/JS_EventHandler.h',
            'fpdfsdk/javascript/JS_GlobalData.cpp',
            'fpdfsdk/javascript/JS_GlobalData.h',
            'fpdfsdk/javascript/JS_Object.cpp',
            'fpdfsdk/javascript/JS_Object.h',
            'fpdfsdk/javascript/JS_Value.cpp',
            'fpdfsdk/javascript/JS_Value.h',
            'fpdfsdk/javascript/PublicMethods.cpp',
            'fpdfsdk/javascript/PublicMethods.h',
            'fpdfsdk/javascript/app.cpp',
            'fpdfsdk/javascript/app.cpp',
            'fpdfsdk/javascript/app.h',
            'fpdfsdk/javascript/color.cpp',
            'fpdfsdk/javascript/color.cpp',
            'fpdfsdk/javascript/color.h',
            'fpdfsdk/javascript/console.cpp',
            'fpdfsdk/javascript/console.cpp',
            'fpdfsdk/javascript/console.h',
            'fpdfsdk/javascript/cjs_context.cpp',
            'fpdfsdk/javascript/cjs_context.h',
            'fpdfsdk/javascript/cjs_runtime.cpp',
            'fpdfsdk/javascript/cjs_runtime.h',
            'fpdfsdk/javascript/event.cpp',
            'fpdfsdk/javascript/event.h',
            'fpdfsdk/javascript/global.cpp',
            'fpdfsdk/javascript/global.h',
            'fpdfsdk/javascript/report.cpp',
            'fpdfsdk/javascript/report.h',
            'fpdfsdk/javascript/resource.cpp',
            'fpdfsdk/javascript/resource.h',
            'fpdfsdk/javascript/util.cpp',
            'fpdfsdk/javascript/util.h',
            'fpdfsdk/jsapi/include/fxjs_v8.h',
            'fpdfsdk/jsapi/fxjs_v8.cpp',
          ],
        }],
      ],
    },
    {
      'target_name': 'formfiller',
      'type': 'static_library',
      'sources': [
        'fpdfsdk/formfiller/cba_fontmap.cpp',
        'fpdfsdk/formfiller/cba_fontmap.h',
        'fpdfsdk/formfiller/cffl_checkbox.cpp',
        'fpdfsdk/formfiller/cffl_checkbox.h',
        'fpdfsdk/formfiller/cffl_combobox.cpp',
        'fpdfsdk/formfiller/cffl_combobox.h',
        'fpdfsdk/formfiller/cffl_formfiller.cpp',
        'fpdfsdk/formfiller/cffl_formfiller.h',
        'fpdfsdk/formfiller/cffl_iformfiller.cpp',
        'fpdfsdk/formfiller/cffl_iformfiller.h',
        'fpdfsdk/formfiller/cffl_listbox.cpp',
        'fpdfsdk/formfiller/cffl_listbox.h',
        'fpdfsdk/formfiller/cffl_pushbutton.cpp',
        'fpdfsdk/formfiller/cffl_pushbutton.h',
        'fpdfsdk/formfiller/cffl_radiobutton.cpp',
        'fpdfsdk/formfiller/cffl_radiobutton.h',
        'fpdfsdk/formfiller/cffl_textfield.cpp',
        'fpdfsdk/formfiller/cffl_textfield.h',
      ],
    },
    {
      'target_name': 'pdfium_unittests',
      'type': 'executable',
      'dependencies': [
        '<(DEPTH)/testing/gtest.gyp:gtest_main',
        '<(DEPTH)/testing/gtest.gyp:gtest',
        'pdfium',
        'test_support',
      ],
      'sources': [
        'core/fxcrt/cfx_retain_ptr_unittest.cpp',
        'core/fpdfapi/fpdf_font/fpdf_font_cid_unittest.cpp',
        'core/fpdfapi/fpdf_font/fpdf_font_unittest.cpp',
        'core/fpdfapi/fpdf_page/fpdf_page_parser_unittest.cpp',
        'core/fpdfapi/fpdf_page/fpdf_page_parser_old_unittest.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_array_unittest.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_object_unittest.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_parser_unittest.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_simple_parser_unittest.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_syntax_parser_unittest.cpp',
        'core/fpdfapi/fpdf_parser/fpdf_parser_decode_unittest.cpp',
        'core/fpdfdoc/doc_basic_unittest.cpp',
        'core/fpdftext/fpdf_text_int_unittest.cpp',
        'core/fxcodec/codec/fx_codec_jpx_unittest.cpp',
        'core/fxcrt/fx_basic_bstring_unittest.cpp',
        'core/fxcrt/fx_basic_gcc_unittest.cpp',
        'core/fxcrt/fx_basic_memmgr_unittest.cpp',
        'core/fxcrt/fx_basic_util_unittest.cpp',
        'core/fxcrt/fx_basic_wstring_unittest.cpp',
        'core/fxcrt/fx_bidi_unittest.cpp',
        'core/fxcrt/fx_extension_unittest.cpp',
        'core/fxcrt/fx_system_unittest.cpp',
        'fpdfsdk/fpdfdoc_unittest.cpp',
        'testing/fx_string_testhelpers.h',
        'testing/fx_string_testhelpers.cpp',
      ],
      'conditions': [
        ['pdf_enable_xfa==1', {
          'sources': [
            'xfa/fde/css/fde_cssdatatable.cpp',
            'xfa/fde/xml/fde_xml_imp_unittest.cpp',
            'xfa/fxbarcode/pdf417/BC_PDF417HighLevelEncoder_unittest.cpp',
            'xfa/fxfa/app/xfa_textlayout_unittest.cpp',
            'xfa/fxfa/parser/xfa_utils_imp_unittest.cpp',
          ],
        }],
        ['pdf_enable_v8==1', {
          'include_dirs': [
            '<(DEPTH)/v8',
            '<(DEPTH)/v8/include',
          ],
          'sources': [
            'fpdfsdk/javascript/public_methods_unittest.cpp',
          ],
        }],
      ],
    },
    {
      'target_name': 'pdfium_embeddertests',
      'type': 'executable',
      'dependencies': [
        '<(DEPTH)/testing/gmock.gyp:gmock',
        '<(DEPTH)/testing/gtest.gyp:gtest',
        'pdfium',
        'test_support',
      ],
      'sources': [
        'core/fpdfapi/fpdf_page/fpdf_page_func_embeddertest.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_parser_embeddertest.cpp',
        'core/fpdfapi/fpdf_parser/cpdf_security_handler_embeddertest.cpp',
        'core/fpdfapi/fpdf_parser/fpdf_parser_decode_embeddertest.cpp',
        'core/fpdfapi/fpdf_render/fpdf_render_loadimage_embeddertest.cpp',
        'core/fpdfapi/fpdf_render/fpdf_render_pattern_embeddertest.cpp',
        'core/fxge/ge/fx_ge_text_embeddertest.cpp',
        'fpdfsdk/fpdf_dataavail_embeddertest.cpp',
        'fpdfsdk/fpdfdoc_embeddertest.cpp',
        'fpdfsdk/fpdfedit_embeddertest.cpp',
        'fpdfsdk/fpdfext_embeddertest.cpp',
        'fpdfsdk/fpdfformfill_embeddertest.cpp',
        'fpdfsdk/fpdfsave_embeddertest.cpp',
        'fpdfsdk/fpdftext_embeddertest.cpp',
        'fpdfsdk/fpdfview_c_api_test.c',
        'fpdfsdk/fpdfview_c_api_test.h',
        'fpdfsdk/fpdfview_embeddertest.cpp',
        'fpdfsdk/fsdk_baseform_embeddertest.cpp',
        'testing/embedder_test.cpp',
        'testing/embedder_test.h',
        'testing/embedder_test_mock_delegate.h',
        'testing/embedder_test_timer_handling_delegate.h',
      ],
      'conditions': [
        ['pdf_enable_xfa==1', {
          'sources': [
            'xfa/fxfa/parser/xfa_parser_imp_embeddertest.cpp',
          ],
        }],
        ['pdf_enable_v8==1', {
          'include_dirs': [
            '<(DEPTH)/v8',
            '<(DEPTH)/v8/include',
          ],
          'dependencies': [
            '<(DEPTH)/v8/src/v8.gyp:v8',
            '<(DEPTH)/v8/src/v8.gyp:v8_libplatform',
          ],
          'sources': [
            'fpdfsdk/javascript/public_methods_embeddertest.cpp',
            'fpdfsdk/jsapi/fxjs_v8_embeddertest.cpp',
            'testing/js_embedder_test.cpp',
            'testing/js_embedder_test.h',
          ],
        }],
      ],
    },
    {
      'target_name': 'test_support',
      'type': 'static_library',
      'dependencies': [
        '<(DEPTH)/testing/gmock.gyp:gmock',
        '<(DEPTH)/testing/gtest.gyp:gtest',
      ],
      'sources': [
        'testing/fx_string_testhelpers.cpp',
        'testing/fx_string_testhelpers.h',
        'testing/test_support.cpp',
        'testing/test_support.h',
        'testing/utils/path_service.cpp',
      ],
      'conditions': [
        ['pdf_enable_v8==1', {
          'include_dirs': [
            '<(DEPTH)/v8',
            '<(DEPTH)/v8/include',
          ],
          'dependencies': [
            '<(DEPTH)/v8/src/v8.gyp:v8',
            '<(DEPTH)/v8/src/v8.gyp:v8_libplatform',
          ],
        }],
      ],
    },
  ],
  'conditions': [
    ['pdf_enable_xfa==1', {
      'targets': [
        {
          'target_name': 'fpdfxfa',
          'type': 'static_library',
          'dependencies': [
            'javascript',
            'xfa.gyp:xfa',
          ],
          'sources': [
            'fpdfsdk/fpdfxfa/fpdfxfa_app.cpp',
            'fpdfsdk/fpdfxfa/fpdfxfa_doc.cpp',
            'fpdfsdk/fpdfxfa/fpdfxfa_page.cpp',
            'fpdfsdk/fpdfxfa/fpdfxfa_util.cpp',
            'fpdfsdk/fpdfxfa/include/fpdfxfa_app.h',
            'fpdfsdk/fpdfxfa/include/fpdfxfa_doc.h',
            'fpdfsdk/fpdfxfa/include/fpdfxfa_page.h',
            'fpdfsdk/fpdfxfa/include/fpdfxfa_util.h',
          ],
        },
      ]
    }],
  ]
}
