# Copyright 2014 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'chromium_code': 1,
  },
  'targets': [
    {
      # GN version: //ios/chrome/app
      'target_name': 'ios_chrome_app',
      'type': 'static_library',
      'include_dirs': [
        '../..',
      ],
      'dependencies': [
        '../../base/base.gyp:base',
        'ios_chrome_browser',
      ],
      'link_settings': {
        'libraries': [
          '$(SDKROOT)/System/Library/Frameworks/Foundation.framework',
          '$(SDKROOT)/System/Library/Frameworks/UIKit.framework',
        ],
      },
      'sources': [
        'app/application_delegate/memory_warning_helper.h',
        'app/application_delegate/memory_warning_helper.mm',
        'app/UIApplication+ExitsOnSuspend.h',
        'app/UIApplication+ExitsOnSuspend.mm',
        'app/deferred_initialization_runner.h',
        'app/deferred_initialization_runner.mm',
        'app/safe_mode_crashing_modules_config.h',
        'app/safe_mode_crashing_modules_config.mm',
        'app/safe_mode_util.cc',
        'app/safe_mode_util.h',
      ],
    },
    {
      # GN version: //ios/chrome/browser
      'target_name': 'ios_chrome_browser',
      'type': 'static_library',
      'include_dirs': [
        '../..',
      ],
      'dependencies': [
        '../../base/base.gyp:base',
        '../../breakpad/breakpad.gyp:breakpad_client',
        '../../components/components.gyp:about_handler',
        '../../components/components.gyp:autofill_core_browser',
        '../../components/components.gyp:autofill_core_common',
        '../../components/components.gyp:autofill_ios_browser',
        '../../components/components.gyp:bookmarks_browser',
        '../../components/components.gyp:browser_sync_browser',
        '../../components/components.gyp:browser_sync_common',
        '../../components/components.gyp:certificate_reporting',
        '../../components/components.gyp:component_updater',
        '../../components/components.gyp:content_settings_core_browser',
        '../../components/components.gyp:cookie_config',
        '../../components/components.gyp:crash_core_browser',
        '../../components/components.gyp:crash_core_common',
        '../../components/components.gyp:dom_distiller_core',
        '../../components/components.gyp:dom_distiller_ios',
        '../../components/components.gyp:favicon_base',
        '../../components/components.gyp:favicon_core',
        '../../components/components.gyp:gcm_driver',
        '../../components/components.gyp:google_core_browser',
        '../../components/components.gyp:history_core_browser',
        '../../components/components.gyp:history_ios_browser',
        '../../components/components.gyp:image_fetcher',
        '../../components/components.gyp:infobars_core',
        '../../components/components.gyp:invalidation_impl',
        '../../components/components.gyp:invalidation_public',
        '../../components/components.gyp:keyed_service_core',
        '../../components/components.gyp:keyed_service_ios',
        '../../components/components.gyp:language_usage_metrics',
        '../../components/components.gyp:leveldb_proto',
        '../../components/components.gyp:metrics',
        '../../components/components.gyp:metrics_net',
        '../../components/components.gyp:metrics_profiler',
        '../../components/components.gyp:metrics_profiler_ios',
        '../../components/components.gyp:metrics_services_manager',
        '../../components/components.gyp:metrics_ui',
        '../../components/components.gyp:navigation_metrics',
        '../../components/components.gyp:net_log',
        '../../components/components.gyp:network_session_configurator',
        '../../components/components.gyp:network_time',
        '../../components/components.gyp:ntp_snippets',
        '../../components/components.gyp:omnibox_browser',
        '../../components/components.gyp:open_from_clipboard',
        '../../components/components.gyp:password_manager_core_browser',
        '../../components/components.gyp:password_manager_sync_browser',
        '../../components/components.gyp:pref_registry',
        '../../components/components.gyp:profile_metrics',
        '../../components/components.gyp:proxy_config',
        '../../components/components.gyp:rappor',
        '../../components/components.gyp:search',
        '../../components/components.gyp:search_engines',
        '../../components/components.gyp:security_interstitials_core',
        '../../components/components.gyp:security_state',
        '../../components/components.gyp:sessions_ios',
        '../../components/components.gyp:signin_core_browser',
        '../../components/components.gyp:signin_core_common',
        '../../components/components.gyp:signin_ios_browser',
        '../../components/components.gyp:ssl_config',
        '../../components/components.gyp:suggestions',
        '../../components/components.gyp:sync_driver',
        '../../components/components.gyp:syncable_prefs',
        '../../components/components.gyp:translate_core_browser',
        '../../components/components.gyp:translate_ios_browser',
        '../../components/components.gyp:undo_component',
        '../../components/components.gyp:update_client',
        '../../components/components.gyp:upload_list',
        '../../components/components.gyp:user_prefs',
        '../../components/components.gyp:variations',
        '../../components/components.gyp:variations_service',
        '../../components/components.gyp:version_info',
        '../../components/components.gyp:version_ui',
        '../../components/components.gyp:web_resource',
        '../../components/components.gyp:webdata_services',
        '../../components/components.gyp:webp_transcode',
        '../../components/components_resources.gyp:components_resources',
        '../../components/components_strings.gyp:components_strings',
        '../../components/prefs/prefs.gyp:prefs',
        '../../components/url_formatter/url_formatter.gyp:url_formatter',
        '../../google_apis/google_apis.gyp:google_apis',
        '../../net/net.gyp:net',
        '../../net/net.gyp:net_extras',
        '../../services/shell/shell_public.gyp:shell_public',
        '../../skia/skia.gyp:skia',
        '../../sync/sync.gyp:sync',
        '../../third_party/brotli/brotli.gyp:brotli',
        '../../third_party/google_toolbox_for_mac/google_toolbox_for_mac.gyp:google_toolbox_for_mac',
        '../../ui/base/ui_base.gyp:ui_base',
        '../../ui/gfx/gfx.gyp:gfx',
        '../../url/url.gyp:url_lib',
        '../provider/ios_provider_chrome.gyp:ios_provider_chrome_browser',
        '../web/ios_web.gyp:ios_web',
        'injected_js',
        'ios_chrome_browser_about_flags',
        'ios_chrome_common',
        'ios_chrome_resources.gyp:ios_chrome_resources',
        'ios_chrome_resources.gyp:ios_chrome_ui_string_overrider_factory',
        'ios_chrome_resources.gyp:ios_chrome_ui_string_overrider_factory_gen',
      ],
      'export_dependent_settings': [
        '../../components/components.gyp:dom_distiller_core',
      ],
      'link_settings': {
        'libraries': [
          '$(SDKROOT)/System/Library/Frameworks/Accelerate.framework',
          '$(SDKROOT)/System/Library/Frameworks/CoreGraphics.framework',
          '$(SDKROOT)/System/Library/Frameworks/CoreLocation.framework',
          '$(SDKROOT)/System/Library/Frameworks/Foundation.framework',
          '$(SDKROOT)/System/Library/Frameworks/Photos.framework',
          '$(SDKROOT)/System/Library/Frameworks/QuartzCore.framework',
          '$(SDKROOT)/System/Library/Frameworks/UIKit.framework',
        ],
      },
      'sources': [
        'browser/app_startup_parameters.h',
        'browser/app_startup_parameters.mm',
        'browser/application_context.cc',
        'browser/application_context.h',
        'browser/application_context_impl.cc',
        'browser/application_context_impl.h',
        'browser/arch_util.cc',
        'browser/arch_util.h',
        'browser/autocomplete/autocomplete_classifier_factory.cc',
        'browser/autocomplete/autocomplete_classifier_factory.h',
        'browser/autocomplete/autocomplete_provider_client_impl.cc',
        'browser/autocomplete/autocomplete_provider_client_impl.h',
        'browser/autocomplete/autocomplete_scheme_classifier_impl.h',
        'browser/autocomplete/autocomplete_scheme_classifier_impl.mm',
        'browser/autocomplete/in_memory_url_index_factory.cc',
        'browser/autocomplete/in_memory_url_index_factory.h',
        'browser/autocomplete/shortcuts_backend_factory.h',
        'browser/autocomplete/shortcuts_backend_factory.mm',
        'browser/autofill/form_input_accessory_view.h',
        'browser/autofill/form_input_accessory_view.mm',
        'browser/autofill/form_input_accessory_view_controller.h',
        'browser/autofill/form_input_accessory_view_controller.mm',
        'browser/autofill/form_input_accessory_view_delegate.h',
        'browser/autofill/form_suggestion_controller.h',
        'browser/autofill/form_suggestion_controller.mm',
        'browser/autofill/form_suggestion_label.h',
        'browser/autofill/form_suggestion_label.mm',
        'browser/autofill/form_suggestion_provider.h',
        'browser/autofill/form_suggestion_view.h',
        'browser/autofill/form_suggestion_view.mm',
        'browser/autofill/form_suggestion_view_client.h',
        'browser/autofill/personal_data_manager_factory.cc',
        'browser/autofill/personal_data_manager_factory.h',
        'browser/bookmarks/bookmark_client_impl.cc',
        'browser/bookmarks/bookmark_client_impl.h',
        'browser/bookmarks/bookmark_model_factory.cc',
        'browser/bookmarks/bookmark_model_factory.h',
        'browser/bookmarks/bookmarks_utils.cc',
        'browser/bookmarks/bookmarks_utils.h',
        'browser/bookmarks/startup_task_runner_service_factory.cc',
        'browser/bookmarks/startup_task_runner_service_factory.h',
        'browser/browser_state/bookmark_model_loaded_observer.cc',
        'browser/browser_state/bookmark_model_loaded_observer.h',
        'browser/browser_state/browser_state_info_cache.cc',
        'browser/browser_state/browser_state_info_cache.h',
        'browser/browser_state/browser_state_info_cache_observer.h',
        'browser/browser_state/browser_state_keyed_service_factories.h',
        'browser/browser_state/browser_state_keyed_service_factories.mm',
        'browser/browser_state/browser_state_otr_helper.cc',
        'browser/browser_state/browser_state_otr_helper.h',
        'browser/browser_state/chrome_browser_state.h',
        'browser/browser_state/chrome_browser_state.mm',
        'browser/browser_state/chrome_browser_state_impl.cc',
        'browser/browser_state/chrome_browser_state_impl.h',
        'browser/browser_state/chrome_browser_state_impl_io_data.h',
        'browser/browser_state/chrome_browser_state_impl_io_data.mm',
        'browser/browser_state/chrome_browser_state_io_data.cc',
        'browser/browser_state/chrome_browser_state_io_data.h',
        'browser/browser_state/chrome_browser_state_manager.h',
        'browser/browser_state/chrome_browser_state_manager_impl.cc',
        'browser/browser_state/chrome_browser_state_manager_impl.h',
        'browser/browser_state/chrome_browser_state_removal_controller.h',
        'browser/browser_state/chrome_browser_state_removal_controller.mm',
        'browser/browser_state/off_the_record_chrome_browser_state_impl.cc',
        'browser/browser_state/off_the_record_chrome_browser_state_impl.h',
        'browser/browser_state/off_the_record_chrome_browser_state_io_data.h',
        'browser/browser_state/off_the_record_chrome_browser_state_io_data.mm',
        'browser/browser_state_metrics/browser_state_metrics.cc',
        'browser/browser_state_metrics/browser_state_metrics.h',
        'browser/browsing_data/browsing_data_change_listening.h',
        'browser/browsing_data/browsing_data_remover_helper.cc',
        'browser/browsing_data/browsing_data_remover_helper.h',
        'browser/browsing_data/ios_chrome_browsing_data_remover.h',
        'browser/browsing_data/ios_chrome_browsing_data_remover.mm',
        'browser/chrome_constants.cc',
        'browser/chrome_constants.h',
        'browser/chrome_paths.h',
        'browser/chrome_paths.mm',
        'browser/chrome_paths_internal.h',
        'browser/chrome_switches.cc',
        'browser/chrome_switches.h',
        'browser/chrome_url_constants.cc',
        'browser/chrome_url_constants.h',
        'browser/chrome_url_util.h',
        'browser/chrome_url_util.mm',
        'browser/component_updater/ios_component_updater_configurator.cc',
        'browser/component_updater/ios_component_updater_configurator.h',
        'browser/content_settings/cookie_settings_factory.cc',
        'browser/content_settings/cookie_settings_factory.h',
        'browser/content_settings/host_content_settings_map_factory.cc',
        'browser/content_settings/host_content_settings_map_factory.h',
        'browser/crash_loop_detection_util.h',
        'browser/crash_loop_detection_util.mm',
        'browser/crash_report/breakpad_helper.h',
        'browser/crash_report/breakpad_helper.mm',
        'browser/crash_report/crash_keys.cc',
        'browser/crash_report/crash_keys.h',
        'browser/crash_report/crash_report_background_uploader.h',
        'browser/crash_report/crash_report_background_uploader.mm',
        'browser/crash_report/crash_report_multi_parameter.h',
        'browser/crash_report/crash_report_multi_parameter.mm',
        'browser/crash_report/crash_report_user_application_state.h',
        'browser/crash_report/crash_report_user_application_state.mm',
        'browser/crash_report/crash_upload_list.cc',
        'browser/crash_report/crash_upload_list.h',
        'browser/dom_distiller/distiller_viewer.cc',
        'browser/dom_distiller/distiller_viewer.h',
        'browser/dom_distiller/dom_distiller_service_factory.cc',
        'browser/dom_distiller/dom_distiller_service_factory.h',
        'browser/experimental_flags.h',
        'browser/experimental_flags.mm',
        'browser/favicon/favicon_client_impl.h',
        'browser/favicon/favicon_client_impl.mm',
        'browser/favicon/favicon_loader.h',
        'browser/favicon/favicon_loader.mm',
        'browser/favicon/favicon_service_factory.cc',
        'browser/favicon/favicon_service_factory.h',
        'browser/favicon/ios_chrome_favicon_loader_factory.h',
        'browser/favicon/ios_chrome_favicon_loader_factory.mm',
        'browser/favicon/ios_chrome_large_icon_cache_factory.cc',
        'browser/favicon/ios_chrome_large_icon_cache_factory.h',
        'browser/favicon/ios_chrome_large_icon_service_factory.cc',
        'browser/favicon/ios_chrome_large_icon_service_factory.h',
        'browser/favicon/large_icon_cache.cc',
        'browser/favicon/large_icon_cache.h',
        'browser/file_metadata_util.h',
        'browser/file_metadata_util.mm',
        'browser/find_in_page/find_in_page_controller.h',
        'browser/find_in_page/find_in_page_controller.mm',
        'browser/find_in_page/find_in_page_model.h',
        'browser/find_in_page/find_in_page_model.mm',
        'browser/find_in_page/js_findinpage_manager.h',
        'browser/find_in_page/js_findinpage_manager.mm',
        'browser/first_run/first_run.h',
        'browser/first_run/first_run.mm',
        'browser/first_run/first_run_configuration.h',
        'browser/first_run/first_run_configuration.mm',
        'browser/first_run/first_run_metrics.h',
        'browser/geolocation/CLLocation+OmniboxGeolocation.h',
        'browser/geolocation/CLLocation+OmniboxGeolocation.mm',
        'browser/geolocation/CLLocation+XGeoHeader.h',
        'browser/geolocation/CLLocation+XGeoHeader.mm',
        'browser/geolocation/location_manager.h',
        'browser/geolocation/location_manager.mm',
        'browser/geolocation/omnibox_geolocation_authorization_alert.h',
        'browser/geolocation/omnibox_geolocation_authorization_alert.mm',
        'browser/geolocation/omnibox_geolocation_config.h',
        'browser/geolocation/omnibox_geolocation_config.mm',
        'browser/geolocation/omnibox_geolocation_local_state.h',
        'browser/geolocation/omnibox_geolocation_local_state.mm',
        'browser/google/google_brand.h',
        'browser/google/google_brand.mm',
        'browser/google/google_url_tracker_client_impl.cc',
        'browser/google/google_url_tracker_client_impl.h',
        'browser/google/google_url_tracker_factory.cc',
        'browser/google/google_url_tracker_factory.h',
        'browser/history/history_backend_client_impl.cc',
        'browser/history/history_backend_client_impl.h',
        'browser/history/history_client_impl.cc',
        'browser/history/history_client_impl.h',
        'browser/history/history_service_factory.cc',
        'browser/history/history_service_factory.h',
        'browser/history/history_utils.cc',
        'browser/history/history_utils.h',
        'browser/history/top_sites_factory.cc',
        'browser/history/top_sites_factory.h',
        'browser/history/web_history_service_factory.cc',
        'browser/history/web_history_service_factory.h',
        'browser/infobars/confirm_infobar_controller.h',
        'browser/infobars/confirm_infobar_controller.mm',
        'browser/infobars/infobar.h',
        'browser/infobars/infobar.mm',
        'browser/infobars/infobar_container_ios.h',
        'browser/infobars/infobar_container_ios.mm',
        'browser/infobars/infobar_container_view.h',
        'browser/infobars/infobar_container_view.mm',
        'browser/infobars/infobar_controller.h',
        'browser/infobars/infobar_controller.mm',
        'browser/infobars/infobar_manager_impl.h',
        'browser/infobars/infobar_manager_impl.mm',
        'browser/infobars/infobar_utils.h',
        'browser/infobars/infobar_utils.mm',
        'browser/install_time_util.h',
        'browser/install_time_util.mm',
        'browser/installation_notifier.h',
        'browser/installation_notifier.mm',
        'browser/interstitials/ios_chrome_controller_client.h',
        'browser/interstitials/ios_chrome_controller_client.mm',
        'browser/interstitials/ios_chrome_metrics_helper.h',
        'browser/interstitials/ios_chrome_metrics_helper.mm',
        'browser/interstitials/ios_security_interstitial_page.h',
        'browser/interstitials/ios_security_interstitial_page.mm',
        'browser/invalidation/ios_chrome_profile_invalidation_provider_factory.h',
        'browser/invalidation/ios_chrome_profile_invalidation_provider_factory.mm',
        'browser/ios_chrome_field_trials.cc',
        'browser/ios_chrome_field_trials.h',
        'browser/ios_chrome_io_thread.h',
        'browser/ios_chrome_io_thread.mm',
        'browser/ios_chrome_main_parts.h',
        'browser/ios_chrome_main_parts.mm',
        'browser/memory/memory_debugger.h',
        'browser/memory/memory_debugger.mm',
        'browser/memory/memory_debugger_manager.h',
        'browser/memory/memory_debugger_manager.mm',
        'browser/memory/memory_metrics.cc',
        'browser/memory/memory_metrics.h',
        'browser/metrics/field_trial_synchronizer.cc',
        'browser/metrics/field_trial_synchronizer.h',
        'browser/metrics/ios_chrome_metrics_service_accessor.cc',
        'browser/metrics/ios_chrome_metrics_service_accessor.h',
        'browser/metrics/ios_chrome_metrics_service_client.cc',
        'browser/metrics/ios_chrome_metrics_service_client.h',
        'browser/metrics/ios_chrome_metrics_services_manager_client.h',
        'browser/metrics/ios_chrome_metrics_services_manager_client.mm',
        'browser/metrics/ios_chrome_origins_seen_service_factory.cc',
        'browser/metrics/ios_chrome_origins_seen_service_factory.h',
        'browser/metrics/ios_chrome_stability_metrics_provider.cc',
        'browser/metrics/ios_chrome_stability_metrics_provider.h',
        'browser/metrics/mobile_session_shutdown_metrics_provider.h',
        'browser/metrics/mobile_session_shutdown_metrics_provider.mm',
        'browser/metrics/previous_session_info.h',
        'browser/metrics/previous_session_info.mm',
        'browser/metrics/previous_session_info_private.h',
        'browser/net/chrome_cookie_store_ios_client.h',
        'browser/net/chrome_cookie_store_ios_client.mm',
        'browser/net/connection_type_observer_bridge.h',
        'browser/net/connection_type_observer_bridge.mm',
        'browser/net/cookie_util.h',
        'browser/net/cookie_util.mm',
        'browser/net/crl_set_fetcher.cc',
        'browser/net/crl_set_fetcher.h',
        'browser/net/http_server_properties_manager_factory.cc',
        'browser/net/http_server_properties_manager_factory.h',
        'browser/net/image_fetcher.h',
        'browser/net/image_fetcher.mm',
        'browser/net/ios_chrome_http_user_agent_settings.h',
        'browser/net/ios_chrome_http_user_agent_settings.mm',
        'browser/net/ios_chrome_network_delegate.cc',
        'browser/net/ios_chrome_network_delegate.h',
        'browser/net/ios_chrome_url_request_context_getter.cc',
        'browser/net/ios_chrome_url_request_context_getter.h',
        'browser/net/metrics_network_client.h',
        'browser/net/metrics_network_client.mm',
        'browser/net/metrics_network_client_manager.h',
        'browser/net/metrics_network_client_manager.mm',
        'browser/net/net_types.h',
        'browser/net/proxy_service_factory.cc',
        'browser/net/proxy_service_factory.h',
        'browser/net/retryable_url_fetcher.h',
        'browser/net/retryable_url_fetcher.mm',
        'browser/notification_promo.h',
        'browser/notification_promo.cc',
        'browser/ntp_snippets/ios_chrome_ntp_snippets_service_factory.cc',
        'browser/ntp_snippets/ios_chrome_ntp_snippets_service_factory.h',
        'browser/open_from_clipboard/create_clipboard_recent_content.h',
        'browser/open_from_clipboard/create_clipboard_recent_content.mm',
        'browser/passwords/credential_manager.h',
        'browser/passwords/credential_manager.mm',
        'browser/passwords/ios_chrome_password_manager_client.h',
        'browser/passwords/ios_chrome_password_manager_client.mm',
        'browser/passwords/ios_chrome_password_manager_driver.h',
        'browser/passwords/ios_chrome_password_manager_driver.mm',
        'browser/passwords/ios_chrome_password_manager_infobar_delegate.h',
        'browser/passwords/ios_chrome_password_manager_infobar_delegate.mm',
        'browser/passwords/ios_chrome_password_manager_setting_migrator_service_factory.cc',
        'browser/passwords/ios_chrome_password_manager_setting_migrator_service_factory.h',
        'browser/passwords/ios_chrome_password_store_factory.cc',
        'browser/passwords/ios_chrome_password_store_factory.h',
        'browser/passwords/ios_chrome_save_password_infobar_delegate.h',
        'browser/passwords/ios_chrome_save_password_infobar_delegate.mm',
        'browser/passwords/js_credential_manager.h',
        'browser/passwords/js_credential_manager.mm',
        'browser/passwords/js_password_manager.h',
        'browser/passwords/js_password_manager.mm',
        'browser/passwords/password_controller.h',
        'browser/passwords/password_controller.mm',
        'browser/passwords/password_generation_agent.h',
        'browser/passwords/password_generation_agent.mm',
        'browser/passwords/password_generation_edit_view.h',
        'browser/passwords/password_generation_edit_view.mm',
        'browser/passwords/password_generation_offer_view.h',
        'browser/passwords/password_generation_offer_view.mm',
        'browser/passwords/password_generation_prompt_delegate.h',
        'browser/passwords/password_generation_utils.h',
        'browser/passwords/password_generation_utils.mm',
        'browser/passwords/passwords_ui_delegate.h',
        'browser/pref_names.cc',
        'browser/pref_names.h',
        'browser/prefs/browser_prefs.h',
        'browser/prefs/browser_prefs.mm',
        'browser/prefs/ios_chrome_pref_model_associator_client.cc',
        'browser/prefs/ios_chrome_pref_model_associator_client.h',
        'browser/prefs/ios_chrome_pref_service_factory.cc',
        'browser/prefs/ios_chrome_pref_service_factory.h',
        'browser/prefs/pref_observer_bridge.h',
        'browser/prefs/pref_observer_bridge.mm',
        'browser/procedural_block_types.h',
        'browser/reading_list/reading_list_entry.cc',
        'browser/reading_list/reading_list_entry.h',
        'browser/reading_list/reading_list_model.cc',
        'browser/reading_list/reading_list_model.h',
        'browser/reading_list/reading_list_model_impl.cc',
        'browser/reading_list/reading_list_model_impl.h',
        'browser/reading_list/reading_list_model_observer.h',
        'browser/reading_list/reading_list_model_factory.cc',
        'browser/reading_list/reading_list_model_factory.h',
        'browser/reading_list/reading_list_model_observer.h',
        'browser/reading_list/reading_list_model_storage.h',
        'browser/reading_list/reading_list_model_storage_defaults.h',
        'browser/reading_list/reading_list_model_storage_defaults.mm',
        'browser/search/search_util.h',
        'browser/search/search_util.mm',
        'browser/search_engines/search_engines_util.cc',
        'browser/search_engines/search_engines_util.h',
        'browser/search_engines/template_url_service_client_impl.cc',
        'browser/search_engines/template_url_service_client_impl.h',
        'browser/search_engines/template_url_service_factory.cc',
        'browser/search_engines/template_url_service_factory.h',
        'browser/search_engines/ui_thread_search_terms_data.cc',
        'browser/search_engines/ui_thread_search_terms_data.h',
        'browser/services/gcm/ios_chrome_gcm_profile_service_factory.cc',
        'browser/services/gcm/ios_chrome_gcm_profile_service_factory.h',
        'browser/sessions/ios_chrome_session_tab_helper.h',
        'browser/sessions/ios_chrome_session_tab_helper.mm',
        'browser/sessions/ios_chrome_tab_restore_service_client.h',
        'browser/sessions/ios_chrome_tab_restore_service_client.mm',
        'browser/sessions/ios_chrome_tab_restore_service_factory.cc',
        'browser/sessions/ios_chrome_tab_restore_service_factory.h',
        'browser/share_extension/share_extension_item_receiver.h',
        'browser/share_extension/share_extension_item_receiver.mm',
        'browser/share_extension/share_extension_service.h',
        'browser/share_extension/share_extension_service.mm',
        'browser/share_extension/share_extension_service_factory.cc',
        'browser/share_extension/share_extension_service_factory.h',
        'browser/signin/about_signin_internals_factory.cc',
        'browser/signin/about_signin_internals_factory.h',
        'browser/signin/account_consistency_service_factory.h',
        'browser/signin/account_consistency_service_factory.mm',
        'browser/signin/account_fetcher_service_factory.cc',
        'browser/signin/account_fetcher_service_factory.h',
        'browser/signin/account_reconcilor_factory.cc',
        'browser/signin/account_reconcilor_factory.h',
        'browser/signin/account_tracker_service_factory.cc',
        'browser/signin/account_tracker_service_factory.h',
        'browser/signin/browser_state_data_remover.h',
        'browser/signin/browser_state_data_remover.mm',
        'browser/signin/chrome_identity_service_observer_bridge.h',
        'browser/signin/chrome_identity_service_observer_bridge.mm',
        'browser/signin/constants.h',
        'browser/signin/constants.mm',
        'browser/signin/gaia_auth_fetcher_ios.h',
        'browser/signin/gaia_auth_fetcher_ios.mm',
        'browser/signin/gaia_auth_fetcher_ios_private.h',
        'browser/signin/gaia_cookie_manager_service_factory.cc',
        'browser/signin/gaia_cookie_manager_service_factory.h',
        'browser/signin/ios_chrome_signin_status_metrics_provider_delegate.cc',
        'browser/signin/ios_chrome_signin_status_metrics_provider_delegate.h',
        'browser/signin/oauth2_token_service_factory.h',
        'browser/signin/oauth2_token_service_factory.mm',
        'browser/signin/signin_client_factory.cc',
        'browser/signin/signin_client_factory.h',
        'browser/signin/signin_client_impl.h',
        'browser/signin/signin_client_impl.mm',
        'browser/signin/signin_error_controller_factory.cc',
        'browser/signin/signin_error_controller_factory.h',
        'browser/signin/signin_manager_factory.cc',
        'browser/signin/signin_manager_factory.h',
        'browser/signin/signin_manager_factory_observer.h',
        'browser/signin/signin_util.h',
        'browser/signin/signin_util.mm',
        'browser/snapshots/lru_cache.h',
        'browser/snapshots/lru_cache.mm',
        'browser/snapshots/snapshot_cache.h',
        'browser/snapshots/snapshot_cache.mm',
        'browser/snapshots/snapshot_manager.h',
        'browser/snapshots/snapshot_manager.mm',
        'browser/snapshots/snapshot_overlay.h',
        'browser/snapshots/snapshot_overlay.mm',
        'browser/snapshots/snapshots_util.h',
        'browser/snapshots/snapshots_util.mm',
        'browser/ssl/ios_chrome_security_state_model_client.h',
        'browser/ssl/ios_chrome_security_state_model_client.mm',
        'browser/ssl/ios_ssl_blocking_page.h',
        'browser/ssl/ios_ssl_blocking_page.mm',
        'browser/ssl/ios_ssl_error_handler.h',
        'browser/ssl/ios_ssl_error_handler.mm',
        'browser/suggestions/image_fetcher_impl.h',
        'browser/suggestions/image_fetcher_impl.mm',
        'browser/suggestions/ios_image_decoder_impl.h',
        'browser/suggestions/ios_image_decoder_impl.mm',
        'browser/suggestions/suggestions_service_factory.h',
        'browser/suggestions/suggestions_service_factory.mm',
        'browser/sync/glue/sync_start_util.cc',
        'browser/sync/glue/sync_start_util.h',
        'browser/sync/ios_chrome_profile_sync_service_factory.cc',
        'browser/sync/ios_chrome_profile_sync_service_factory.h',
        'browser/sync/ios_chrome_sync_client.h',
        'browser/sync/ios_chrome_sync_client.mm',
        'browser/sync/ios_chrome_synced_tab_delegate.h',
        'browser/sync/ios_chrome_synced_tab_delegate.mm',
        'browser/sync/sessions/ios_chrome_local_session_event_router.h',
        'browser/sync/sessions/ios_chrome_local_session_event_router.mm',
        'browser/sync/sync_observer_bridge.h',
        'browser/sync/sync_observer_bridge.mm',
        'browser/sync/sync_setup_service.cc',
        'browser/sync/sync_setup_service.h',
        'browser/sync/sync_setup_service_factory.cc',
        'browser/sync/sync_setup_service_factory.h',
        'browser/tab_parenting_global_observer.cc',
        'browser/tab_parenting_global_observer.h',
        'browser/translate/after_translate_infobar_controller.h',
        'browser/translate/after_translate_infobar_controller.mm',
        'browser/translate/before_translate_infobar_controller.h',
        'browser/translate/before_translate_infobar_controller.mm',
        'browser/translate/chrome_ios_translate_client.h',
        'browser/translate/chrome_ios_translate_client.mm',
        'browser/translate/never_translate_infobar_controller.h',
        'browser/translate/never_translate_infobar_controller.mm',
        'browser/translate/translate_accept_languages_factory.cc',
        'browser/translate/translate_accept_languages_factory.h',
        'browser/translate/translate_infobar_tags.h',
        'browser/translate/translate_message_infobar_controller.h',
        'browser/translate/translate_message_infobar_controller.mm',
        'browser/translate/translate_service_ios.cc',
        'browser/translate/translate_service_ios.h',
        'browser/ui/UIView+SizeClassSupport.h',
        'browser/ui/UIView+SizeClassSupport.mm',
        'browser/ui/animation_util.h',
        'browser/ui/animation_util.mm',
        'browser/ui/autofill/autofill_client_ios.h',
        'browser/ui/autofill/autofill_client_ios.mm',
        'browser/ui/autofill/autofill_save_card_infobar.mm',
        'browser/ui/background_generator.h',
        'browser/ui/background_generator.mm',
        'browser/ui/browser_otr_state.h',
        'browser/ui/browser_otr_state.mm',
        'browser/ui/commands/UIKit+ChromeExecuteCommand.h',
        'browser/ui/commands/UIKit+ChromeExecuteCommand.mm',
        'browser/ui/commands/clear_browsing_data_command.h',
        'browser/ui/commands/clear_browsing_data_command.mm',
        'browser/ui/commands/generic_chrome_command.h',
        'browser/ui/commands/generic_chrome_command.mm',
        'browser/ui/commands/ios_command_ids.h',
        'browser/ui/commands/open_url_command.h',
        'browser/ui/commands/open_url_command.mm',
        'browser/ui/commands/reading_list_add_command.h',
        'browser/ui/commands/reading_list_add_command.mm',
        'browser/ui/commands/set_up_for_testing_command.h',
        'browser/ui/commands/set_up_for_testing_command.mm',
        'browser/ui/commands/show_mail_composer_command.h',
        'browser/ui/commands/show_mail_composer_command.mm',
        'browser/ui/commands/show_signin_command.h',
        'browser/ui/commands/show_signin_command.mm',
        'browser/ui/context_menu/context_menu_coordinator.h',
        'browser/ui/context_menu/context_menu_coordinator.mm',
        'browser/ui/file_locations.h',
        'browser/ui/file_locations.mm',
        'browser/ui/image_util.h',
        'browser/ui/image_util.mm',
        'browser/ui/keyboard/UIKeyCommand+Chrome.h',
        'browser/ui/keyboard/UIKeyCommand+Chrome.mm',
        'browser/ui/keyboard/hardware_keyboard_watcher.h',
        'browser/ui/keyboard/hardware_keyboard_watcher.mm',
        'browser/ui/native_content_controller.h',
        'browser/ui/native_content_controller.mm',
        'browser/ui/omnibox/web_omnibox_edit_controller.cc',
        'browser/ui/omnibox/web_omnibox_edit_controller.h',
        'browser/ui/orientation_limiting_navigation_controller.h',
        'browser/ui/orientation_limiting_navigation_controller.mm',
        'browser/ui/prerender_final_status.h',
        'browser/ui/reversed_animation.h',
        'browser/ui/reversed_animation.mm',
        'browser/ui/rtl_geometry.h',
        'browser/ui/rtl_geometry.mm',
        'browser/ui/show_mail_composer_util.h',
        'browser/ui/show_mail_composer_util.mm',
        'browser/ui/show_privacy_settings_util.h',
        'browser/ui/show_privacy_settings_util.mm',
        'browser/ui/side_swipe_gesture_recognizer.h',
        'browser/ui/side_swipe_gesture_recognizer.mm',
        'browser/ui/size_class_support_util.h',
        'browser/ui/size_class_support_util.mm',
        'browser/ui/ui_util.h',
        'browser/ui/ui_util.mm',
        'browser/ui/uikit_ui_util.h',
        'browser/ui/uikit_ui_util.mm',
        'browser/ui/url_loader.h',
        'browser/ui/webui/about_ui.cc',
        'browser/ui/webui/about_ui.h',
        'browser/ui/webui/crashes_ui.cc',
        'browser/ui/webui/crashes_ui.h',
        'browser/ui/webui/flags_ui.cc',
        'browser/ui/webui/flags_ui.h',
        'browser/ui/webui/gcm/gcm_internals_ui.cc',
        'browser/ui/webui/gcm/gcm_internals_ui.h',
        'browser/ui/webui/history/browsing_history_handler.cc',
        'browser/ui/webui/history/browsing_history_handler.h',
        'browser/ui/webui/history/favicon_source.cc',
        'browser/ui/webui/history/favicon_source.h',
        'browser/ui/webui/history/history_ui.h',
        'browser/ui/webui/history/history_ui.mm',
        'browser/ui/webui/history/metrics_handler.cc',
        'browser/ui/webui/history/metrics_handler.h',
        'browser/ui/webui/mojo_web_ui_ios_controller.h',
        'browser/ui/webui/net_export/net_export_ui.cc',
        'browser/ui/webui/net_export/net_export_ui.h',
        'browser/ui/webui/sync_internals/sync_internals_message_handler.cc',
        'browser/ui/webui/sync_internals/sync_internals_message_handler.h',
        'browser/ui/webui/sync_internals/sync_internals_ui.cc',
        'browser/ui/webui/sync_internals/sync_internals_ui.h',
        'browser/ui/webui/version_handler.cc',
        'browser/ui/webui/version_handler.h',
        'browser/ui/webui/version_ui.h',
        'browser/ui/webui/version_ui.mm',
        'browser/undo/bookmark_undo_service_factory.cc',
        'browser/undo/bookmark_undo_service_factory.h',
        'browser/updatable_config/updatable_array.h',
        'browser/updatable_config/updatable_array.mm',
        'browser/updatable_config/updatable_config_base.h',
        'browser/updatable_config/updatable_config_base.mm',
        'browser/updatable_config/updatable_dictionary.h',
        'browser/updatable_config/updatable_dictionary.mm',
        'browser/update_client/ios_chrome_update_query_params_delegate.cc',
        'browser/update_client/ios_chrome_update_query_params_delegate.h',
        'browser/variations/ios_chrome_variations_service_client.cc',
        'browser/variations/ios_chrome_variations_service_client.h',
        'browser/web/dom_altering_lock.h',
        'browser/web/dom_altering_lock.mm',
        'browser/web/resubmit_data_controller.h',
        'browser/web/resubmit_data_controller.mm',
        'browser/web_data_service_factory.cc',
        'browser/web_data_service_factory.h',
        'browser/web_resource/web_resource_util.cc',
        'browser/web_resource/web_resource_util.h',
        'browser/xcallback_parameters.h',
        'browser/xcallback_parameters.mm',
      ],
      'conditions': [
        ['enable_rlz==1', {
          'dependencies': [
            '../../components/components.gyp:rlz',
            'ios_chrome_browser_rlz',
          ],
        }],
      ],
    },
    {
      # GN version: //ios/chrome/browser:about_flags
      # This is a separate target so that the 'defines' does not leak to the
      # other files (which would increase the compilation time when changing
      # the value).
      'target_name': 'ios_chrome_browser_about_flags',
      'type': 'static_library',
      'include_dirs': [
        '../..',
      ],
      'dependencies': [
        '../../base/base.gyp:base',
        '../../components/components.gyp:autofill_core_common',
        '../../components/components.gyp:dom_distiller_core',
        '../../components/components.gyp:flags_ui',
        '../../components/components.gyp:sync_driver',
        '../../components/components_strings.gyp:components_strings',
        '../../google_apis/google_apis.gyp:google_apis',
        '../web/ios_web.gyp:ios_web',
        'ios_chrome_resources.gyp:ios_strings_gen',
      ],
      'sources': [
        'browser/about_flags.h',
        'browser/about_flags.mm',
      ],
      'defines': [
        'GOOGLE_STAGING_API_URL="<(google_staging_api_url)"',
        'GOOGLE_STAGING_LSO_URL="<(google_staging_lso_url)"',
        'GOOGLE_TEST_API_URL="<(google_test_api_url)"',
        'GOOGLE_TEST_LSO_URL="<(google_test_lso_url)"',
        'GOOGLE_TEST_OAUTH_CLIENT_ID="<(google_test_oauth_client_id)"',
        'GOOGLE_TEST_OAUTH_CLIENT_SECRET="<(google_test_oauth_client_secret)"',
        'GOOGLE_TEST_OAUTH_URL="<(google_test_oauth_url)"',
        'GOOGLE_TEST_SYNC_URL="<(google_test_sync_url)"',
      ],
      'variables': {
        'google_staging_api_url%': '',
        'google_staging_lso_url%': '',
        'google_test_api_url%': '',
        'google_test_lso_url%': '',
        'google_test_oauth_client_id%': '',
        'google_test_oauth_client_secret%': '',
        'google_test_oauth_url%': '',
        'google_test_sync_url%': '',
      },
    },
    {
      # GN version: //ios/chrome/browser:chrome_coordinators
      'target_name': 'ios_chrome_browser_chrome_coordinators',
      'type': 'static_library',
      'include_dirs': [
        '../..',
      ],
      'dependencies': [
        '../../base/base.gyp:base',
      ],
      'sources': [
        'browser/chrome_coordinator.h',
        'browser/chrome_coordinator.mm',
        'browser/root_coordinator.h',
        'browser/root_coordinator.mm',
       ]
    },
    {
      # GN version: //ios/chrome/common
      'target_name': 'ios_chrome_common',
      'type': 'static_library',
      'include_dirs': [
        '../..',
      ],
      'dependencies': [
        '../../base/base.gyp:base',
        '../../components/components.gyp:version_info',
        'app_group_mainapp',
      ],
      'link_settings': {
        'libraries': [
          '$(SDKROOT)/System/Library/Frameworks/CoreGraphics.framework',
          '$(SDKROOT)/System/Library/Frameworks/Foundation.framework',
          '$(SDKROOT)/System/Library/Frameworks/QuartzCore.framework',
          '$(SDKROOT)/System/Library/Frameworks/UIKit.framework',
        ],
      },
      'sources': [
        'common/channel_info.h',
        'common/channel_info.mm',
        'common/material_timing.h',
        'common/material_timing.mm',
        'common/string_util.h',
        'common/string_util.mm',
      ],
    },
    {
      # GN version: //ios/chrome/browser:injected_js
      'target_name': 'injected_js',
      'type': 'none',
      'sources': [
        'browser/find_in_page/resources/find_in_page.js',
        'browser/passwords/resources/credential_manager.js',
        'browser/passwords/resources/password_controller.js',
      ],
      'includes': [ '../../ios/web/js_compile.gypi' ],
      'link_settings': {
        'mac_bundle_resources': [
          '<(SHARED_INTERMEDIATE_DIR)/credential_manager.js',
          '<(SHARED_INTERMEDIATE_DIR)/find_in_page.js',
          '<(SHARED_INTERMEDIATE_DIR)/password_controller.js',
        ],
      },
    },
    {
      # GN version: //ios/chrome/common/app_group
      'target_name': 'app_group_common',
      'type': 'static_library',
      'sources': [
        'common/app_group/app_group_constants.h',
        'common/app_group/app_group_constants.mm',
        'common/app_group/app_group_metrics.h',
        'common/app_group/app_group_metrics.mm',
      ],
      'dependencies': [
        # This target will be included into application extensions and the list
        # of its dependencies must be kept as short as possible.
        '../../base/base.gyp:base',
        '../../components/components.gyp:version_info',
      ],
      'include_dirs': [
        '../..',
      ],
    },
    {
      # GN version: //ios/chrome/common/app_group:client
      'target_name': 'app_group_client',
      'type': 'static_library',
      'sources': [
        'common/app_group/app_group_metrics_client.h',
        'common/app_group/app_group_metrics_client.mm',
      ],
      'dependencies': [
        # This target will be included into application extensions and the list
        # of its dependencies must be kept as short as possible.
        'app_group_common',
      ],
      'include_dirs': [
        '../..',
      ],
    },
    {
      # GN version: //ios/chrome/common/app_group:main_app
      'target_name': 'app_group_mainapp',
      'type': 'static_library',
      'sources': [
        'common/app_group/app_group_metrics_mainapp.h',
        'common/app_group/app_group_metrics_mainapp.mm',
      ],
      'dependencies': [
        'app_group_common',
      ],
      'include_dirs': [
        '../..',
      ],
    },
  ],
  'conditions': [
    ['enable_rlz_support==1', {
      'targets': [
        {
          # GN version: //ios/chrome/browser/rlz
          'target_name': 'ios_chrome_browser_rlz',
          'type': 'static_library',
          'sources': [
            'browser/rlz/rlz_tracker_delegate_impl.cc',
            'browser/rlz/rlz_tracker_delegate_impl.h',
          ],
          'dependencies': [
            '../../components/components.gyp:google_core_browser',
            '../../components/components.gyp:omnibox_browser',
            '../../components/components.gyp:rlz',
            '../../components/components.gyp:search_engines',
            '../../rlz/rlz.gyp:rlz_lib',
          ],
        },
      ],
    }],
  ],
}
