# Copyright 2014 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      # GN version: //components/password_manager/core/browser
      'target_name': 'password_manager_core_browser',
      'type': 'static_library',
      'dependencies': [
        '../base/base.gyp:base',
        '../net/net.gyp:net',
        '../sql/sql.gyp:sql',
        '../sync/sync.gyp:sync',
        '../third_party/protobuf/protobuf.gyp:protobuf_lite',
        '../url/url.gyp:url_lib',
        'autofill_core_common',
        'components_strings.gyp:components_strings',
        'keyed_service_core',
        'os_crypt',
        '../third_party/re2/re2.gyp:re2',
        'password_manager_core_common',
        'password_manager_core_browser_proto',
        'sync_driver',
        'url_formatter/url_formatter.gyp:url_formatter',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        # Note: sources list duplicated in GN build.
        'password_manager/core/browser/affiliated_match_helper.cc',
        'password_manager/core/browser/affiliated_match_helper.h',
        'password_manager/core/browser/affiliation_backend.cc',
        'password_manager/core/browser/affiliation_backend.h',
        'password_manager/core/browser/affiliation_database.cc',
        'password_manager/core/browser/affiliation_database.h',
        'password_manager/core/browser/affiliation_fetch_throttler.cc',
        'password_manager/core/browser/affiliation_fetch_throttler.h',
        'password_manager/core/browser/affiliation_fetch_throttler_delegate.h',
        'password_manager/core/browser/affiliation_fetcher.cc',
        'password_manager/core/browser/affiliation_fetcher.h',
        'password_manager/core/browser/affiliation_fetcher_delegate.h',
        'password_manager/core/browser/affiliation_service.cc',
        'password_manager/core/browser/affiliation_service.h',
        'password_manager/core/browser/affiliation_utils.cc',
        'password_manager/core/browser/affiliation_utils.h',
        'password_manager/core/browser/browser_save_password_progress_logger.cc',
        'password_manager/core/browser/browser_save_password_progress_logger.h',
        'password_manager/core/browser/credential_manager_password_form_manager.cc',
        'password_manager/core/browser/credential_manager_password_form_manager.h',
        'password_manager/core/browser/credential_manager_pending_request_task.cc',
        'password_manager/core/browser/credential_manager_pending_request_task.h',
        'password_manager/core/browser/credential_manager_pending_require_user_mediation_task.cc',
        'password_manager/core/browser/credential_manager_pending_require_user_mediation_task.h',
        'password_manager/core/browser/credentials_filter.h',
        'password_manager/core/browser/export/csv_writer.cc',
        'password_manager/core/browser/export/csv_writer.h',
        'password_manager/core/browser/export/password_csv_writer.cc',
        'password_manager/core/browser/export/password_csv_writer.h',
        'password_manager/core/browser/export/password_exporter.cc',
        'password_manager/core/browser/export/password_exporter.h',
        'password_manager/core/browser/facet_manager.cc',
        'password_manager/core/browser/facet_manager.h',
        'password_manager/core/browser/facet_manager_host.h',
        'password_manager/core/browser/form_saver.h',
        'password_manager/core/browser/form_saver_impl.cc',
        'password_manager/core/browser/form_saver_impl.h',
        'password_manager/core/browser/import/csv_reader.cc',
        'password_manager/core/browser/import/csv_reader.h',
        'password_manager/core/browser/import/password_csv_reader.cc',
        'password_manager/core/browser/import/password_csv_reader.h',
        'password_manager/core/browser/import/password_importer.cc',
        'password_manager/core/browser/import/password_importer.h',
        'password_manager/core/browser/keychain_migration_status_mac.h',
        'password_manager/core/browser/log_manager.cc',
        'password_manager/core/browser/log_manager.h',
        'password_manager/core/browser/log_receiver.h',
        'password_manager/core/browser/log_router.cc',
        'password_manager/core/browser/log_router.h',
        'password_manager/core/browser/login_database.cc',
        'password_manager/core/browser/login_database.h',
        'password_manager/core/browser/login_database_ios.cc',
        'password_manager/core/browser/login_database_mac.cc',
        'password_manager/core/browser/login_database_posix.cc',
        'password_manager/core/browser/login_database_win.cc',
        'password_manager/core/browser/login_model.cc',
        'password_manager/core/browser/login_model.h',
        'password_manager/core/browser/password_autofill_manager.cc',
        'password_manager/core/browser/password_autofill_manager.h',
        'password_manager/core/browser/password_bubble_experiment.cc',
        'password_manager/core/browser/password_bubble_experiment.h',
        'password_manager/core/browser/password_form_manager.cc',
        'password_manager/core/browser/password_form_manager.h',
        'password_manager/core/browser/password_generation_manager.cc',
        'password_manager/core/browser/password_generation_manager.h',
        'password_manager/core/browser/password_manager.cc',
        'password_manager/core/browser/password_manager.h',
        'password_manager/core/browser/password_manager_client.cc',
        'password_manager/core/browser/password_manager_client.h',
        'password_manager/core/browser/password_manager_constants.cc',
        'password_manager/core/browser/password_manager_constants.h',
        'password_manager/core/browser/password_manager_driver.h',
        'password_manager/core/browser/password_manager_internals_service.cc',
        'password_manager/core/browser/password_manager_internals_service.h',
        'password_manager/core/browser/password_manager_metrics_util.cc',
        'password_manager/core/browser/password_manager_metrics_util.h',
        'password_manager/core/browser/password_manager_settings_migration_experiment.cc',
        'password_manager/core/browser/password_manager_settings_migration_experiment.h',
        'password_manager/core/browser/password_manager_util.cc',
        'password_manager/core/browser/password_manager_util.h',
        'password_manager/core/browser/password_store.cc',
        'password_manager/core/browser/password_store.h',
        'password_manager/core/browser/password_store_change.cc',
        'password_manager/core/browser/password_store_change.h',
        'password_manager/core/browser/password_store_consumer.cc',
        'password_manager/core/browser/password_store_consumer.h',
        'password_manager/core/browser/password_store_default.cc',
        'password_manager/core/browser/password_store_default.h',
        'password_manager/core/browser/password_store_factory_util.cc',
        'password_manager/core/browser/password_store_factory_util.h',
        'password_manager/core/browser/password_store_sync.cc',
        'password_manager/core/browser/password_store_sync.h',
        'password_manager/core/browser/password_syncable_service.cc',
        'password_manager/core/browser/password_syncable_service.h',
        'password_manager/core/browser/password_ui_utils.cc',
        'password_manager/core/browser/password_ui_utils.h',
        'password_manager/core/browser/psl_matching_helper.cc',
        'password_manager/core/browser/psl_matching_helper.h',
        'password_manager/core/browser/statistics_table.cc',
        'password_manager/core/browser/statistics_table.h',
        'password_manager/core/browser/test_affiliation_fetcher_factory.h',
        'password_manager/core/browser/types.h',
        'password_manager/core/browser/webdata/logins_table.cc',
        'password_manager/core/browser/webdata/logins_table.h',
        'password_manager/core/browser/webdata/logins_table_win.cc',
        'password_manager/core/browser/webdata/password_web_data_service_win.cc',
        'password_manager/core/browser/webdata/password_web_data_service_win.h',
      ],
      'conditions': [
        ['OS=="ios"', {
          'sources!': [
            'password_manager/core/browser/login_database_posix.cc',
          ],
        }],
        ['OS=="mac"', {
          'sources!': [
            'password_manager/core/browser/login_database_posix.cc',
          ],
        }],
      ],
      # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
      'msvs_disabled_warnings': [ 4267, ],
    },
    {
      # GN version: //components/password_manager/core/browser:proto
      'target_name': 'password_manager_core_browser_proto',
      'type': 'static_library',
      'sources': [
        'password_manager/core/browser/affiliation_api.proto'
      ],
      'variables': {
        'proto_in_dir': 'password_manager/core/browser',
        'proto_out_dir': 'components/password_manager/core/browser',
      },
      'includes': ['../build/protoc.gypi'],
    },
    {
      # GN version: //components/password_manager/core/browser:test_support
      'target_name': 'password_manager_core_browser_test_support',
      'type': 'static_library',
      'dependencies': [
        'autofill_core_common',
        '../base/base.gyp:base',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        'autofill_server_proto',
      ],
      'export_dependent_settings': [
        '../testing/gmock.gyp:gmock',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'password_manager/core/browser/fake_affiliation_api.cc',
        'password_manager/core/browser/fake_affiliation_api.h',
        'password_manager/core/browser/fake_affiliation_fetcher.cc',
        'password_manager/core/browser/fake_affiliation_fetcher.h',
        'password_manager/core/browser/mock_affiliation_consumer.cc',
        'password_manager/core/browser/mock_affiliation_consumer.h',
        'password_manager/core/browser/mock_password_store.cc',
        'password_manager/core/browser/mock_password_store.h',
        'password_manager/core/browser/password_manager_test_utils.cc',
        'password_manager/core/browser/password_manager_test_utils.h',
        # Note: sources list duplicated in GN build.
        'password_manager/core/browser/stub_form_saver.h',
        'password_manager/core/browser/stub_log_manager.cc',
        'password_manager/core/browser/stub_log_manager.h',
        'password_manager/core/browser/stub_password_manager_client.cc',
        'password_manager/core/browser/stub_password_manager_client.h',
        'password_manager/core/browser/stub_password_manager_driver.cc',
        'password_manager/core/browser/stub_password_manager_driver.h',
        'password_manager/core/browser/test_password_store.cc',
        'password_manager/core/browser/test_password_store.h',
      ],
    },
    {
      # GN version: //components/password_manager/core/common
      'target_name': 'password_manager_core_common',
      'type': 'static_library',
      'dependencies': [
        '../base/base.gyp:base',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        # Note: sources list duplicated in GN build.
        'password_manager/core/common/credential_manager_types.cc',
        'password_manager/core/common/credential_manager_types.h',
        'password_manager/core/common/experiments.cc',
        'password_manager/core/common/experiments.h',
        'password_manager/core/common/password_manager_features.cc',
        'password_manager/core/common/password_manager_features.h',
        'password_manager/core/common/password_manager_pref_names.cc',
        'password_manager/core/common/password_manager_pref_names.h',
        'password_manager/core/common/password_manager_ui.h',
      ],
    },
    {
      # GN version: //components/password_manager/sync/browser
      'target_name': 'password_manager_sync_browser',
      'type': 'static_library',
      'dependencies': [
        '../base/base.gyp:base',
        '../google_apis/google_apis.gyp:google_apis',
        '../net/net.gyp:net',
        '../sync/sync.gyp:sync',
        'autofill_core_common',
        'password_manager_core_browser',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        # Note: sources list duplicated in GN build.
        'password_manager/sync/browser/password_data_type_controller.cc',
        'password_manager/sync/browser/password_data_type_controller.h',
        'password_manager/sync/browser/password_manager_setting_migrator_service.cc',
        'password_manager/sync/browser/password_manager_setting_migrator_service.h',
        'password_manager/sync/browser/password_model_worker.cc',
        'password_manager/sync/browser/password_model_worker.h',
        'password_manager/sync/browser/password_sync_util.cc',
        'password_manager/sync/browser/password_sync_util.h',
        'password_manager/sync/browser/sync_credentials_filter.cc',
        'password_manager/sync/browser/sync_credentials_filter.h',
      ],
    },
  ],
  'conditions': [
    ['OS != "ios"', {
      'targets': [
        {
          # GN version: //components/password_manager/content/public/interfaces
          'target_name': 'password_manager_content_mojo_bindings_mojom',
          'type': 'none',
          'variables': {
            'mojom_files': [
              'password_manager/content/public/interfaces/credential_manager.mojom',
            ],
            'mojom_typemaps': [
              '<(DEPTH)/url/mojo/gurl.typemap',
              '<(DEPTH)/url/mojo/origin.typemap',
            ],
          },
          'include_dirs': [
            '..',
          ],
          'includes': [
            '../mojo/mojom_bindings_generator_explicit.gypi',
          ],
        },
        {
          # GN version: //components/password_manager/content/public/cpp
          'target_name': 'password_manager_content_mojo_bindings',
          'type': 'static_library',
          'dependencies': [
            '../base/base.gyp:base',
            '../mojo/mojo_base.gyp:mojo_common_lib',
            '../mojo/mojo_public.gyp:mojo_cpp_bindings',
            '../third_party/WebKit/public/blink.gyp:blink',
            '../url/url.gyp:url_mojom',
            'password_manager_content_mojo_bindings_mojom',
            'password_manager_core_common',
          ],
          'export_dependent_settings': [
             '../url/url.gyp:url_mojom',
           ],
          'include_dirs': [
            '..',
          ],
          'sources': [
            'password_manager/content/public/cpp/type_converters.cc',
            'password_manager/content/public/cpp/type_converters.h',
          ],
        },
        {
          # GN version: //components/password_manager/content/renderer
          'target_name': 'password_manager_content_renderer',
          'type': 'static_library',
          'dependencies': [
            '../base/base.gyp:base',
            '../content/content.gyp:content_common',
            '../third_party/WebKit/public/blink.gyp:blink',
            'password_manager_content_mojo_bindings',
            'password_manager_core_common',
          ],
          'include_dirs': [
            '..',
          ],
          'sources': [
            'password_manager/content/renderer/credential_manager_client.cc',
            'password_manager/content/renderer/credential_manager_client.h',
          ],
        },
        {
          # GN version: //components/password_manager/content/browser
          'target_name': 'password_manager_content_browser',
          'type': 'static_library',
          'dependencies': [
            '../base/base.gyp:base',
            '../content/content.gyp:content_browser',
            '../content/content.gyp:content_common',
            '../ipc/ipc.gyp:ipc',
            '../net/net.gyp:net',
            'autofill_content_browser',
            'autofill_content_common',
            'autofill_core_common',
            'keyed_service_content',
            'password_manager_content_mojo_bindings',
            'password_manager_core_browser',
          ],
          'include_dirs': [
            '..',
          ],
          'sources': [
            # Note: sources list duplicated in GN build.
            'password_manager/content/browser/bad_message.cc',
            'password_manager/content/browser/bad_message.h',
            'password_manager/content/browser/content_password_manager_driver.cc',
            'password_manager/content/browser/content_password_manager_driver.h',
            'password_manager/content/browser/content_password_manager_driver_factory.cc',
            'password_manager/content/browser/content_password_manager_driver_factory.h',
            'password_manager/content/browser/credential_manager_impl.cc',
            'password_manager/content/browser/credential_manager_impl.h',
            'password_manager/content/browser/password_manager_internals_service_factory.cc',
            'password_manager/content/browser/password_manager_internals_service_factory.h',
          ],
        },
      ],
    }],
  ],
}
