/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd and/or its subsidiary(-ies).
** Contact: http://www.qt.io/licensing/
**
** This file is part of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL3$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPLv3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or later as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file. Please review the following information to
** ensure the GNU General Public License version 2.0 requirements will be
** met: http://www.gnu.org/licenses/gpl-2.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QAUDIOOUTPUTWASAPI_H
#define QAUDIOOUTPUTWASAPI_H

#include <QtCore/QLoggingCategory>
#include <QtCore/QMutex>
#include <QtCore/QTime>
#include <QtMultimedia/QAbstractAudioOutput>
#include <QtMultimedia/QAudio>

#include <QReadWriteLock>
#include <wrl.h>

struct IAudioRenderClient;
struct IAudioStreamVolume;

QT_BEGIN_NAMESPACE

class AudioInterface;
class WasapiOutputDevicePrivate;
class QWasapiProcessThread;

Q_DECLARE_LOGGING_CATEGORY(lcMmAudioOutput)

class QWasapiAudioOutput : public QAbstractAudioOutput
{
    Q_OBJECT
public:
    explicit QWasapiAudioOutput(const QByteArray &device);
    ~QWasapiAudioOutput();

    void start(QIODevice* device) Q_DECL_OVERRIDE;
    QIODevice* start() Q_DECL_OVERRIDE;
    void stop() Q_DECL_OVERRIDE;
    void reset() Q_DECL_OVERRIDE;
    void suspend() Q_DECL_OVERRIDE;
    void resume() Q_DECL_OVERRIDE;
    int bytesFree() const Q_DECL_OVERRIDE;
    int periodSize() const Q_DECL_OVERRIDE;
    void setBufferSize(int value) Q_DECL_OVERRIDE;
    int bufferSize() const Q_DECL_OVERRIDE;
    void setNotifyInterval(int milliSeconds) Q_DECL_OVERRIDE;
    int notifyInterval() const Q_DECL_OVERRIDE;
    qint64 processedUSecs() const Q_DECL_OVERRIDE;
    qint64 elapsedUSecs() const Q_DECL_OVERRIDE;
    QAudio::Error error() const Q_DECL_OVERRIDE;
    QAudio::State state() const Q_DECL_OVERRIDE;
    void setFormat(const QAudioFormat& fmt) Q_DECL_OVERRIDE;
    QAudioFormat format() const Q_DECL_OVERRIDE;
    void setVolume(qreal) Q_DECL_OVERRIDE;
    qreal volume() const Q_DECL_OVERRIDE;

    void process();
private:
    bool initStart(bool pull);
    friend class WasapiOutputDevicePrivate;
    friend class WasapiOutputPrivate;
    QByteArray m_deviceName;
    Microsoft::WRL::ComPtr<AudioInterface> m_interface;
    Microsoft::WRL::ComPtr<IAudioRenderClient> m_renderer;
#if defined(CLASSIC_APP_BUILD) || _MSC_VER >= 1900
    Microsoft::WRL::ComPtr<IAudioStreamVolume> m_volumeControl;
    qreal m_volumeCache;
#endif
    QMutex m_mutex;
    QAudio::State m_currentState;
    QAudio::Error m_currentError;
    QAudioFormat m_currentFormat;
    qint64 m_bytesProcessed;
    QTime m_openTime;
    int m_openTimeOffset;
    int m_interval;
    bool m_pullMode;
    quint32 m_bufferFrames;
    quint32 m_bufferBytes;
    HANDLE m_event;
    QWasapiProcessThread *m_eventThread;
    QIODevice *m_eventDevice;
};

QT_END_NAMESPACE

#endif
