// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CachedMetadataHandler_h
#define CachedMetadataHandler_h

#include "wtf/Forward.h"

namespace blink {

class CachedMetadata;

// Handler class for caching operations.
class CachedMetadataHandler {
public:
    enum CacheType {
        SendToPlatform, // send cache data to blink::Platform::cacheMetadata
        CacheLocally // cache only in Resource's member variables
    };
    virtual ~CachedMetadataHandler() { }
    // Caches the given metadata in association with this resource and suggests
    // that the platform persist it. The dataTypeID is a pseudo-randomly chosen
    // identifier that is used to distinguish data generated by the caller.
    virtual void setCachedMetadata(unsigned dataTypeID, const char*, size_t, CacheType = SendToPlatform) = 0;
    // Reset existing metadata, to allow setting new data.
    virtual void clearCachedMetadata(CacheType = CacheLocally) = 0;
    // Returns cached metadata of the given type associated with this resource.
    virtual CachedMetadata* cachedMetadata(unsigned dataTypeID) const = 0;
    // Returns the encoding to which the cache is specific.
    virtual String encoding() const = 0;

protected:
    CachedMetadataHandler() { }
};
}

#endif // CachedMetadataHandler_h
