C++11 in Skia
=============

Skia is exploring the use of C++11.  As a library, we are technically limited
by what our clients support and what our build bots support.

Skia may also be limited by restrictions we choose put on ourselves.  This
document is not concerned with C++11 policy in Skia, only its technical
feasibility.  This is about what we can use, a superset of what we may use.

The gist:

-   C++11 the language as supported by GCC 4.4 or later is probably usable.
-   If you break a bot, that feature is not usable.
-   The C++11 standard library can't generally be used.
-   Local statics are not thread safe.


Clients
-------

The clients we pay most attention to are Chrome, Android, Mozilla, and a few
internal Google projects.

Chrome builds with a recent Clang on Mac and Linux and with a recent MSVC on
Windows.  These toolchains are new enough to not be the weak link to use any
C++11 language feature.  But Chrome still supports Mac OS X 10.6, which does
not ship with a C++11 standard library.  So [Chrome has banned the use of the
C++11 standard library](http://chromium-cpp.appspot.com/).  Some header-only
features are probably technically fine, but the Mac toolchain will prevent us
from even trying at compile time as long as we target 10.6 as our minimum API
level.

Chrome intentionally disables thread-safe initialization of static variables,
and MSVC doesn't support it at all, so we cannot rely on that.

Android builds with either a recent GCC or a recent Clang.  They're generally
not a weak link for C++11 language features.  Android's C++ standard library
has always been a pain, but since we can't use it anyway (see Chrome), don't
worry about it.

Mozilla's current weak link is a minimum requirement of GCC 4.6.  Most features
marked in red on Mozilla's C++11 [feature
matrix](https://developer.mozilla.org/en-US/docs/Using_CXX_in_Mozilla_code) are
marked that way because they arrived in GCC 4.7 or GCC 4.8.  Their
minimum-supported Clang and MSVC toolchains are great.  They also appear to ban
the C++ standard library.

Internal Google projects tend to support C++11 completely, including the
full C++11 standard library.


Bots
----

Most of our bots are pretty up-to-date: the Windows bots use MSVC 2013, the Mac
bots a recent Clang, and the Linux bots GCC 4.8 or a recent Clang.  Our Android
bots use a recent toolchain from Android (see above), and our Chrome bots use
Chrome's toolchains (see above).  I'm not exactly sure what our Chrome OS bots
are using, but they've never been a problem.

A few miscellaneous compile-only bots are actually our current overall weak link:

-   Our iOS builds are driven from a Mac 10.7 machine using some unknown old Clang.
    Who knows how old that is or what it supports?  It's probably due for an update.

If we were to eliminate the problems of iOS bots, our ability to
use C++11 would match Mozilla's list nearly identically.
