
(function(){
/**
`iron-signals` provides basic publish-subscribe functionality.

Note: avoid using `iron-signals` whenever you can use
a controller (parent element) to mediate communication
instead.

To send a signal, fire a custom event of type `iron-signal`, with
a detail object containing `name` and `data` fields.

    this.fire('iron-signal', {name: 'hello', data: null});

To receive a signal, listen for `iron-signal-<name>` event on a
`iron-signals` element.

  <iron-signals on-iron-signal-hello="{{helloSignal}}">

You can fire a signal event from anywhere, and all
`iron-signals` elements will receive the event, regardless
of where they are in DOM.

@demo demo/index.html
*/
  Polymer({
    is: 'iron-signals',

    attached: function() {
      signals.push(this);
    },
    detached: function() {
      var i = signals.indexOf(this);
      if (i >= 0) {
        signals.splice(i, 1);
      }
    }
  });

  // private shared database
  var signals = [];

  // signal dispatcher
  function notify(name, data) {
    // convert generic-signal event to named-signal event
    var signal = new CustomEvent('iron-signal-' + name, {
      // if signals bubble, it's easy to get confusing duplicates
      // (1) listen on a container on behalf of local child
      // (2) some deep child ignores the event and it bubbles
      //     up to said container
      // (3) local child event bubbles up to container
      // also, for performance, we avoid signals flying up the
      // tree from all over the place
      bubbles: false,
      detail: data
    });
    // dispatch named-signal to all 'signals' instances,
    // only interested listeners will react
    signals.forEach(function(s) {
      s.dispatchEvent(signal);
    });
  }

  // signal listener at document
  document.addEventListener('iron-signal', function(e) {
    notify(e.detail.name, e.detail.data);
  });

})();
