/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayDeque;
import java.util.Deque;

public final class ModifiedControlVariableCheck
extends Check {
    public static final String MSG_KEY = "modified.control.variable";
    private Deque<String> currentVariables = new ArrayDeque<String>();
    private final Deque<Deque<String>> variableStack = new ArrayDeque<Deque<String>>();

    @Override
    public int[] getDefaultTokens() {
        return new int[]{6, 91, 37, 156, 80, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 129, 25, 130, 26};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{6, 91, 37, 156, 80, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 129, 25, 130, 26};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.currentVariables.clear();
        this.variableStack.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 6: {
                this.enterBlock();
                break;
            }
            case 37: 
            case 91: 
            case 156: {
                break;
            }
            case 25: 
            case 26: 
            case 80: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 129: 
            case 130: {
                this.checkIdent(ast);
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 37: {
                this.leaveForIter(ast.getParent());
                break;
            }
            case 156: {
                this.leaveForEach(ast);
                break;
            }
            case 91: {
                this.leaveForDef(ast);
                break;
            }
            case 6: {
                this.exitBlock();
                break;
            }
            case 25: 
            case 26: 
            case 80: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 129: 
            case 130: {
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    private void enterBlock() {
        this.variableStack.push(this.currentVariables);
        this.currentVariables = new ArrayDeque<String>();
    }

    private void exitBlock() {
        this.currentVariables = this.variableStack.pop();
    }

    private void checkIdent(DetailAST ast) {
        DetailAST identAST;
        if (this.currentVariables != null && !this.currentVariables.isEmpty() && (identAST = ast.getFirstChild()) != null && identAST.getType() == 58 && this.currentVariables.contains(identAST.getText())) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, identAST.getText());
        }
    }

    private void leaveForIter(DetailAST ast) {
        DetailAST forInitAST = ast.findFirstToken(35);
        for (DetailAST parameterDefAST = forInitAST.findFirstToken(10); parameterDefAST != null; parameterDefAST = parameterDefAST.getNextSibling()) {
            if (parameterDefAST.getType() != 10) continue;
            DetailAST param = parameterDefAST.findFirstToken(58);
            this.currentVariables.push(param.getText());
        }
    }

    private void leaveForEach(DetailAST forEach) {
        DetailAST paramDef = forEach.findFirstToken(10);
        DetailAST paramName = paramDef.findFirstToken(58);
        this.currentVariables.push(paramName.getText());
    }

    private void leaveForDef(DetailAST ast) {
        DetailAST forInitAST = ast.findFirstToken(35);
        if (forInitAST != null) {
            for (DetailAST parameterDefAST = forInitAST.findFirstToken(10); parameterDefAST != null; parameterDefAST = parameterDefAST.getNextSibling()) {
                if (parameterDefAST.getType() != 10) continue;
                this.currentVariables.pop();
            }
        } else {
            this.currentVariables.pop();
        }
    }
}

