// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/payments/content/can_make_payment_query_factory.h"

#include "base/memory/singleton.h"
#include "components/keyed_service/content/browser_context_dependency_manager.h"
#include "components/payments/core/can_make_payment_query.h"

namespace payments {

// static
CanMakePaymentQueryFactory* CanMakePaymentQueryFactory::GetInstance() {
  return base::Singleton<CanMakePaymentQueryFactory>::get();
}

CanMakePaymentQuery* CanMakePaymentQueryFactory::GetForContext(
    content::BrowserContext* context) {
  return static_cast<CanMakePaymentQuery*>(
      GetInstance()->GetServiceForBrowserContext(context, true));
}

CanMakePaymentQueryFactory::CanMakePaymentQueryFactory()
    : BrowserContextKeyedServiceFactory(
          "CanMakePaymentQuery",
          BrowserContextDependencyManager::GetInstance()) {}

CanMakePaymentQueryFactory::~CanMakePaymentQueryFactory() {}

KeyedService* CanMakePaymentQueryFactory::BuildServiceInstanceFor(
    content::BrowserContext* context) const {
  return new CanMakePaymentQuery;
}

}  // namespace payments
